/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.roster.PresenceEventListener;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoService;
import org.jivesoftware.smackx.omemo.exceptions.CannotEstablishOmemoSessionException;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.internal.OmemoCachedDeviceList;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.trust.OmemoFingerprint;
import org.jivesoftware.smackx.omemo.trust.OmemoTrustCallback;
import org.jivesoftware.smackx.omemo.util.EphemeralTrustCallback;
import org.jivesoftware.smackx.omemo.util.OmemoConstants;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.junit.Assert;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.FullJid;
import org.jxmpp.jid.Jid;

public class OmemoManagerSetupHelper {
    public static void syncSubscribePresence(XMPPConnection subscriber, XMPPConnection target, String targetNick, String[] targetGroups) throws Exception {
        final SimpleResultSyncPoint subscribed = new SimpleResultSyncPoint();
        Roster subscriberRoster = Roster.getInstanceFor((XMPPConnection)subscriber);
        Roster targetRoster = Roster.getInstanceFor((XMPPConnection)target);
        targetRoster.setSubscriptionMode(Roster.SubscriptionMode.accept_all);
        subscriberRoster.addPresenceEventListener(new PresenceEventListener(){

            public void presenceAvailable(FullJid address, Presence availablePresence) {
            }

            public void presenceUnavailable(FullJid address, Presence presence) {
            }

            public void presenceError(Jid address, Presence errorPresence) {
                subscribed.signalFailure();
            }

            public void presenceSubscribed(BareJid address, Presence subscribedPresence) {
                subscribed.signal();
            }

            public void presenceUnsubscribed(BareJid address, Presence unsubscribedPresence) {
            }
        });
        subscriberRoster.createEntry(target.getUser().asBareJid(), targetNick, targetGroups);
        subscribed.waitForResult(10000L);
    }

    public static void trustAllIdentities(OmemoManager alice, OmemoManager bob) throws InterruptedException, SmackException.NotConnectedException, SmackException.NotLoggedInException, SmackException.NoResponseException, CannotEstablishOmemoSessionException, CorruptedOmemoKeyException, XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException {
        Roster roster = Roster.getInstanceFor((XMPPConnection)alice.getConnection());
        if (!(alice.getOwnJid() == bob.getOwnJid() || roster.iAmSubscribedTo((Jid)bob.getOwnJid()) && roster.isSubscribedToMyPresence((Jid)bob.getOwnJid()))) {
            throw new IllegalStateException("Before trusting identities of a user, we must be subscribed to one another.");
        }
        alice.requestDeviceListUpdateFor(bob.getOwnJid());
        HashMap fingerprints = alice.getActiveFingerprints(bob.getOwnJid());
        for (OmemoDevice device : fingerprints.keySet()) {
            OmemoFingerprint fingerprint = (OmemoFingerprint)fingerprints.get(device);
            alice.trustOmemoIdentity(device, fingerprint);
        }
    }

    public static void trustAllIdentitiesWithTests(OmemoManager alice, OmemoManager bob) throws InterruptedException, SmackException.NotConnectedException, SmackException.NotLoggedInException, SmackException.NoResponseException, CannotEstablishOmemoSessionException, CorruptedOmemoKeyException, XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException {
        alice.requestDeviceListUpdateFor(bob.getOwnJid());
        HashMap fps1 = alice.getActiveFingerprints(bob.getOwnJid());
        Assert.assertFalse((boolean)fps1.isEmpty());
        OmemoManagerSetupHelper.assertAllDevicesAreUndecided(alice, fps1);
        OmemoManagerSetupHelper.assertAllDevicesAreUntrusted(alice, fps1);
        OmemoManagerSetupHelper.trustAllIdentities(alice, bob);
        HashMap fps2 = alice.getActiveFingerprints(bob.getOwnJid());
        Assert.assertEquals((long)fps1.size(), (long)fps2.size());
        Assert.assertTrue((boolean)Maps.difference((Map)fps1, (Map)fps2).areEqual());
        OmemoManagerSetupHelper.assertAllDevicesAreDecided(alice, fps2);
        OmemoManagerSetupHelper.assertAllDevicesAreTrusted(alice, fps2);
    }

    public static OmemoManager prepareOmemoManager(XMPPConnection connection) throws Exception {
        OmemoManager manager = OmemoManager.getInstanceFor((XMPPConnection)connection, (Integer)OmemoManager.randomDeviceId());
        manager.setTrustCallback((OmemoTrustCallback)new EphemeralTrustCallback());
        if (!connection.isAuthenticated()) {
            throw new AssertionError((Object)"Connection must be authenticated.");
        }
        manager.initialize();
        return manager;
    }

    public static void assertAllDevicesAreUndecided(OmemoManager manager, HashMap<OmemoDevice, OmemoFingerprint> devices) {
        for (OmemoDevice device : devices.keySet()) {
            Assert.assertFalse((boolean)manager.isDecidedOmemoIdentity(device, devices.get(device)));
        }
    }

    public static void assertAllDevicesAreUntrusted(OmemoManager manager, HashMap<OmemoDevice, OmemoFingerprint> devices) {
        for (OmemoDevice device : devices.keySet()) {
            Assert.assertFalse((boolean)manager.isTrustedOmemoIdentity(device, devices.get(device)));
        }
    }

    public static void assertAllDevicesAreDecided(OmemoManager manager, HashMap<OmemoDevice, OmemoFingerprint> devices) {
        for (OmemoDevice device : devices.keySet()) {
            Assert.assertTrue((boolean)manager.isDecidedOmemoIdentity(device, devices.get(device)));
        }
    }

    public static void assertAllDevicesAreTrusted(OmemoManager manager, HashMap<OmemoDevice, OmemoFingerprint> devices) {
        for (OmemoDevice device : devices.keySet()) {
            Assert.assertTrue((boolean)manager.isTrustedOmemoIdentity(device, devices.get(device)));
        }
    }

    public static void cleanUpPubSub(OmemoManager omemoManager) {
        PubSubManager pm = PubSubManager.getInstance((XMPPConnection)omemoManager.getConnection(), (BareJid)omemoManager.getOwnJid());
        try {
            omemoManager.requestDeviceListUpdateFor(omemoManager.getOwnJid());
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | PubSubException.NotALeafNodeException throwable) {
            // empty catch block
        }
        OmemoCachedDeviceList deviceList = OmemoService.getInstance().getOmemoStoreBackend().loadCachedDeviceList(omemoManager.getOwnDevice(), omemoManager.getOwnJid());
        Iterator iterator = deviceList.getAllDevices().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            try {
                pm.getLeafNode(OmemoConstants.PEP_NODE_BUNDLE_FROM_DEVICE_ID((int)id)).deleteAllItems();
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | PubSubException.NotALeafNodeException | PubSubException.NotAPubSubNodeException throwable) {
                // empty catch block
            }
            try {
                pm.deleteNode(OmemoConstants.PEP_NODE_BUNDLE_FROM_DEVICE_ID((int)id));
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException throwable) {}
        }
        try {
            pm.getLeafNode("eu.siacs.conversations.axolotl.devicelist").deleteAllItems();
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | PubSubException.NotALeafNodeException | PubSubException.NotAPubSubNodeException throwable) {
            // empty catch block
        }
        try {
            pm.deleteNode("eu.siacs.conversations.axolotl.devicelist");
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException throwable) {
            // empty catch block
        }
    }

    public static void cleanUpRoster(OmemoManager omemoManager) {
        Roster roster = Roster.getInstanceFor((XMPPConnection)omemoManager.getConnection());
        for (RosterEntry r : roster.getEntries()) {
            try {
                roster.removeEntry(r);
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | SmackException.NotLoggedInException | XMPPException.XMPPErrorException throwable) {}
        }
    }
}

