/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.util.Date;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.internal.OmemoCachedDeviceList;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.util.OmemoKeyUtil;
import org.jxmpp.jid.BareJid;

public class CachingOmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph>
extends OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> {
    private final HashMap<OmemoDevice, KeyCache<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess>> caches = new HashMap();
    private final OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> persistent;
    private final OmemoKeyUtil<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_ECPub, T_Bundle> keyUtil;

    public CachingOmemoStore(OmemoKeyUtil<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_ECPub, T_Bundle> keyUtil) {
        if (keyUtil == null) {
            throw new IllegalArgumentException("KeyUtil MUST NOT be null!");
        }
        this.keyUtil = keyUtil;
        this.persistent = null;
    }

    public CachingOmemoStore(OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> wrappedStore) {
        if (wrappedStore == null) {
            throw new NullPointerException("Wrapped OmemoStore MUST NOT be null!");
        }
        this.keyUtil = null;
        this.persistent = wrappedStore;
    }

    @Override
    public SortedSet<Integer> localDeviceIdsOf(BareJid localUser) {
        if (this.persistent != null) {
            return this.persistent.localDeviceIdsOf(localUser);
        }
        return new TreeSet<Integer>();
    }

    @Override
    public T_IdKeyPair loadOmemoIdentityKeyPair(OmemoDevice userDevice) throws CorruptedOmemoKeyException {
        Object pair = ((KeyCache)this.getCache(userDevice)).identityKeyPair;
        if (pair == null && this.persistent != null && (pair = this.persistent.loadOmemoIdentityKeyPair(userDevice)) != null) {
            ((KeyCache)this.getCache(userDevice)).identityKeyPair = pair;
        }
        return (T_IdKeyPair)pair;
    }

    @Override
    public void storeOmemoIdentityKeyPair(OmemoDevice userDevice, T_IdKeyPair identityKeyPair) {
        ((KeyCache)this.getCache(userDevice)).identityKeyPair = identityKeyPair;
        if (this.persistent != null) {
            this.persistent.storeOmemoIdentityKeyPair(userDevice, identityKeyPair);
        }
    }

    @Override
    public void removeOmemoIdentityKeyPair(OmemoDevice userDevice) {
        ((KeyCache)this.getCache(userDevice)).identityKeyPair = null;
        if (this.persistent != null) {
            this.persistent.removeOmemoIdentityKeyPair(userDevice);
        }
    }

    @Override
    public T_IdKey loadOmemoIdentityKey(OmemoDevice userDevice, OmemoDevice contactsDevice) throws CorruptedOmemoKeyException {
        Object idKey = ((KeyCache)this.getCache(userDevice)).identityKeys.get(contactsDevice);
        if (idKey == null && this.persistent != null && (idKey = this.persistent.loadOmemoIdentityKey(userDevice, contactsDevice)) != null) {
            ((KeyCache)this.getCache(userDevice)).identityKeys.put(contactsDevice, idKey);
        }
        return (T_IdKey)idKey;
    }

    @Override
    public void storeOmemoIdentityKey(OmemoDevice userDevice, OmemoDevice device, T_IdKey t_idKey) {
        ((KeyCache)this.getCache(userDevice)).identityKeys.put(device, t_idKey);
        if (this.persistent != null) {
            this.persistent.storeOmemoIdentityKey(userDevice, device, t_idKey);
        }
    }

    @Override
    public void removeOmemoIdentityKey(OmemoDevice userDevice, OmemoDevice contactsDevice) {
        ((KeyCache)this.getCache(userDevice)).identityKeys.remove(contactsDevice);
        if (this.persistent != null) {
            this.persistent.removeOmemoIdentityKey(userDevice, contactsDevice);
        }
    }

    @Override
    public void setDateOfLastReceivedMessage(OmemoDevice userDevice, OmemoDevice from, Date date) {
        ((KeyCache)this.getCache(userDevice)).lastMessagesDates.put(from, date);
        if (this.persistent != null) {
            this.persistent.setDateOfLastReceivedMessage(userDevice, from, date);
        }
    }

    @Override
    public Date getDateOfLastReceivedMessage(OmemoDevice userDevice, OmemoDevice from) {
        Date last = (Date)((KeyCache)this.getCache(userDevice)).lastMessagesDates.get(from);
        if (last == null && this.persistent != null && (last = this.persistent.getDateOfLastReceivedMessage(userDevice, from)) != null) {
            ((KeyCache)this.getCache(userDevice)).lastMessagesDates.put(from, last);
        }
        return last;
    }

    @Override
    public void setDateOfLastDeviceIdPublication(OmemoDevice userDevice, OmemoDevice contactsDevice, Date date) {
        ((KeyCache)this.getCache(userDevice)).lastDeviceIdPublicationDates.put(contactsDevice, date);
        if (this.persistent != null) {
            this.persistent.setDateOfLastReceivedMessage(userDevice, contactsDevice, date);
        }
    }

    @Override
    public Date getDateOfLastDeviceIdPublication(OmemoDevice userDevice, OmemoDevice contactsDevice) {
        Date last = (Date)((KeyCache)this.getCache(userDevice)).lastDeviceIdPublicationDates.get(contactsDevice);
        if (last == null && this.persistent != null && (last = this.persistent.getDateOfLastDeviceIdPublication(userDevice, contactsDevice)) != null) {
            ((KeyCache)this.getCache(userDevice)).lastDeviceIdPublicationDates.put(contactsDevice, last);
        }
        return last;
    }

    @Override
    public void setDateOfLastSignedPreKeyRenewal(OmemoDevice userDevice, Date date) {
        ((KeyCache)this.getCache(userDevice)).lastRenewalDate = date;
        if (this.persistent != null) {
            this.persistent.setDateOfLastSignedPreKeyRenewal(userDevice, date);
        }
    }

    @Override
    public Date getDateOfLastSignedPreKeyRenewal(OmemoDevice userDevice) {
        Date lastRenewal = ((KeyCache)this.getCache(userDevice)).lastRenewalDate;
        if (lastRenewal == null && this.persistent != null && (lastRenewal = this.persistent.getDateOfLastSignedPreKeyRenewal(userDevice)) != null) {
            ((KeyCache)this.getCache(userDevice)).lastRenewalDate = lastRenewal;
        }
        return lastRenewal;
    }

    @Override
    public T_PreKey loadOmemoPreKey(OmemoDevice userDevice, int preKeyId) {
        Object preKey = ((KeyCache)this.getCache(userDevice)).preKeys.get(preKeyId);
        if (preKey == null && this.persistent != null && (preKey = this.persistent.loadOmemoPreKey(userDevice, preKeyId)) != null) {
            ((KeyCache)this.getCache(userDevice)).preKeys.put(preKeyId, preKey);
        }
        return (T_PreKey)preKey;
    }

    @Override
    public void storeOmemoPreKey(OmemoDevice userDevice, int preKeyId, T_PreKey t_preKey) {
        ((KeyCache)this.getCache(userDevice)).preKeys.put(preKeyId, t_preKey);
        if (this.persistent != null) {
            this.persistent.storeOmemoPreKey(userDevice, preKeyId, t_preKey);
        }
    }

    @Override
    public void removeOmemoPreKey(OmemoDevice userDevice, int preKeyId) {
        ((KeyCache)this.getCache(userDevice)).preKeys.remove(preKeyId);
        if (this.persistent != null) {
            this.persistent.removeOmemoPreKey(userDevice, preKeyId);
        }
    }

    @Override
    public TreeMap<Integer, T_PreKey> loadOmemoPreKeys(OmemoDevice userDevice) {
        TreeMap preKeys = ((KeyCache)this.getCache(userDevice)).preKeys;
        if (preKeys.isEmpty() && this.persistent != null) {
            preKeys.putAll(this.persistent.loadOmemoPreKeys(userDevice));
        }
        return new TreeMap(preKeys);
    }

    @Override
    public T_SigPreKey loadOmemoSignedPreKey(OmemoDevice userDevice, int signedPreKeyId) {
        Object sigPreKey = ((KeyCache)this.getCache(userDevice)).signedPreKeys.get(signedPreKeyId);
        if (sigPreKey == null && this.persistent != null && (sigPreKey = this.persistent.loadOmemoSignedPreKey(userDevice, signedPreKeyId)) != null) {
            ((KeyCache)this.getCache(userDevice)).signedPreKeys.put(signedPreKeyId, sigPreKey);
        }
        return (T_SigPreKey)sigPreKey;
    }

    @Override
    public TreeMap<Integer, T_SigPreKey> loadOmemoSignedPreKeys(OmemoDevice userDevice) {
        TreeMap sigPreKeys = ((KeyCache)this.getCache(userDevice)).signedPreKeys;
        if (sigPreKeys.isEmpty() && this.persistent != null) {
            sigPreKeys.putAll(this.persistent.loadOmemoSignedPreKeys(userDevice));
        }
        return new TreeMap(sigPreKeys);
    }

    @Override
    public void storeOmemoSignedPreKey(OmemoDevice userDevice, int signedPreKeyId, T_SigPreKey signedPreKey) {
        ((KeyCache)this.getCache(userDevice)).signedPreKeys.put(signedPreKeyId, signedPreKey);
        if (this.persistent != null) {
            this.persistent.storeOmemoSignedPreKey(userDevice, signedPreKeyId, signedPreKey);
        }
    }

    @Override
    public void removeOmemoSignedPreKey(OmemoDevice userDevice, int signedPreKeyId) {
        ((KeyCache)this.getCache(userDevice)).signedPreKeys.remove(signedPreKeyId);
        if (this.persistent != null) {
            this.persistent.removeOmemoSignedPreKey(userDevice, signedPreKeyId);
        }
    }

    @Override
    public T_Sess loadRawSession(OmemoDevice userDevice, OmemoDevice contactsDevice) {
        Object session;
        HashMap contactSessions = (HashMap)((KeyCache)this.getCache(userDevice)).sessions.get(contactsDevice.getJid());
        if (contactSessions == null) {
            contactSessions = new HashMap();
            ((KeyCache)this.getCache(userDevice)).sessions.put(contactsDevice.getJid(), contactSessions);
        }
        if ((session = contactSessions.get(contactsDevice.getDeviceId())) == null && this.persistent != null && (session = this.persistent.loadRawSession(userDevice, contactsDevice)) != null) {
            contactSessions.put(contactsDevice.getDeviceId(), session);
        }
        return (T_Sess)session;
    }

    @Override
    public HashMap<Integer, T_Sess> loadAllRawSessionsOf(OmemoDevice userDevice, BareJid contact) {
        HashMap<Integer, T_Sess> sessions = (HashMap<Integer, T_Sess>)((KeyCache)this.getCache(userDevice)).sessions.get(contact);
        if (sessions == null) {
            sessions = new HashMap<Integer, T_Sess>();
            ((KeyCache)this.getCache(userDevice)).sessions.put(contact, sessions);
        }
        if (sessions.isEmpty() && this.persistent != null) {
            sessions.putAll(this.persistent.loadAllRawSessionsOf(userDevice, contact));
        }
        return new HashMap(sessions);
    }

    @Override
    public void storeRawSession(OmemoDevice userDevice, OmemoDevice contactsDevicece, T_Sess session) {
        HashMap<Integer, T_Sess> sessions = (HashMap<Integer, T_Sess>)((KeyCache)this.getCache(userDevice)).sessions.get(contactsDevicece.getJid());
        if (sessions == null) {
            sessions = new HashMap<Integer, T_Sess>();
            ((KeyCache)this.getCache(userDevice)).sessions.put(contactsDevicece.getJid(), sessions);
        }
        sessions.put(contactsDevicece.getDeviceId(), session);
        if (this.persistent != null) {
            this.persistent.storeRawSession(userDevice, contactsDevicece, session);
        }
    }

    @Override
    public void removeRawSession(OmemoDevice userDevice, OmemoDevice contactsDevice) {
        HashMap sessions = (HashMap)((KeyCache)this.getCache(userDevice)).sessions.get(contactsDevice.getJid());
        if (sessions != null) {
            sessions.remove(contactsDevice.getDeviceId());
        }
        if (this.persistent != null) {
            this.persistent.removeRawSession(userDevice, contactsDevice);
        }
    }

    @Override
    public void removeAllRawSessionsOf(OmemoDevice userDevice, BareJid contact) {
        ((KeyCache)this.getCache(userDevice)).sessions.remove(contact);
        if (this.persistent != null) {
            this.persistent.removeAllRawSessionsOf(userDevice, contact);
        }
    }

    @Override
    public boolean containsRawSession(OmemoDevice userDevice, OmemoDevice contactsDevice) {
        HashMap sessions = (HashMap)((KeyCache)this.getCache(userDevice)).sessions.get(contactsDevice.getJid());
        return sessions != null && sessions.get(contactsDevice.getDeviceId()) != null || this.persistent != null && this.persistent.containsRawSession(userDevice, contactsDevice);
    }

    @Override
    public OmemoCachedDeviceList loadCachedDeviceList(OmemoDevice userDevice, BareJid contact) {
        OmemoCachedDeviceList list = (OmemoCachedDeviceList)((KeyCache)this.getCache(userDevice)).deviceLists.get(contact);
        if (list == null && this.persistent != null && (list = this.persistent.loadCachedDeviceList(userDevice, contact)) != null) {
            ((KeyCache)this.getCache(userDevice)).deviceLists.put(contact, list);
        }
        return list == null ? new OmemoCachedDeviceList() : new OmemoCachedDeviceList(list);
    }

    @Override
    public void storeCachedDeviceList(OmemoDevice userDevice, BareJid contact, OmemoCachedDeviceList deviceList) {
        ((KeyCache)this.getCache(userDevice)).deviceLists.put(contact, new OmemoCachedDeviceList(deviceList));
        if (this.persistent != null) {
            this.persistent.storeCachedDeviceList(userDevice, contact, deviceList);
        }
    }

    @Override
    public void purgeOwnDeviceKeys(OmemoDevice userDevice) {
        this.caches.remove(userDevice);
        if (this.persistent != null) {
            this.persistent.purgeOwnDeviceKeys(userDevice);
        }
    }

    @Override
    public OmemoKeyUtil<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_ECPub, T_Bundle> keyUtil() {
        if (this.persistent != null) {
            return this.persistent.keyUtil();
        }
        return this.keyUtil;
    }

    private KeyCache<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess> getCache(OmemoDevice device) {
        KeyCache<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess> cache = this.caches.get(device);
        if (cache == null) {
            cache = new KeyCache();
            this.caches.put(device, cache);
        }
        return cache;
    }

    private static class KeyCache<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess> {
        private T_IdKeyPair identityKeyPair;
        private final TreeMap<Integer, T_PreKey> preKeys = new TreeMap();
        private final TreeMap<Integer, T_SigPreKey> signedPreKeys = new TreeMap();
        private final HashMap<BareJid, HashMap<Integer, T_Sess>> sessions = new HashMap();
        private final HashMap<OmemoDevice, T_IdKey> identityKeys = new HashMap();
        private final HashMap<OmemoDevice, Date> lastMessagesDates = new HashMap();
        private final HashMap<OmemoDevice, Date> lastDeviceIdPublicationDates = new HashMap();
        private final HashMap<BareJid, OmemoCachedDeviceList> deviceLists = new HashMap();
        private Date lastRenewalDate = null;

        private KeyCache() {
        }
    }
}

