/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.element;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.omemo.internal.OmemoCachedDeviceList;

public abstract class OmemoDeviceListElement
implements ExtensionElement {
    public static final String DEVICE = "device";
    public static final String ID = "id";
    public static final String LIST = "list";
    private final Set<Integer> deviceIds;

    public OmemoDeviceListElement(Set<Integer> deviceIds) {
        deviceIds = (Set)Objects.requireNonNull(deviceIds);
        this.deviceIds = Collections.unmodifiableSet(deviceIds);
    }

    public OmemoDeviceListElement(OmemoCachedDeviceList cachedList) {
        this.deviceIds = Collections.unmodifiableSet(cachedList.getActiveDevices());
    }

    public Set<Integer> getDeviceIds() {
        return this.deviceIds;
    }

    public Set<Integer> copyDeviceIds() {
        return new HashSet<Integer>(this.deviceIds);
    }

    public String getElementName() {
        return LIST;
    }

    public final XmlStringBuilder toXML(String enclosingNamespace) {
        XmlStringBuilder sb = new XmlStringBuilder((ExtensionElement)this).rightAngleBracket();
        for (Integer id : this.deviceIds) {
            sb.halfOpenElement(DEVICE).attribute(ID, id.intValue()).closeEmptyElement();
        }
        sb.closeElement((NamedElement)this);
        return sb;
    }

    public final String toString() {
        String out = "OmemoDeviceListElement[";
        for (int i : this.deviceIds) {
            out = out + i + ",";
        }
        return out.substring(0, out.length() - 1) + "]";
    }
}

