/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jivesoftware.smackx.omemo.OmemoRatchet;
import org.jivesoftware.smackx.omemo.OmemoService;
import org.jivesoftware.smackx.omemo.element.OmemoElement;
import org.jivesoftware.smackx.omemo.element.OmemoElement_VAxolotl;
import org.jivesoftware.smackx.omemo.element.OmemoHeaderElement_VAxolotl;
import org.jivesoftware.smackx.omemo.element.OmemoKeyElement;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.exceptions.NoIdentityKeyException;
import org.jivesoftware.smackx.omemo.exceptions.UndecidedOmemoIdentityException;
import org.jivesoftware.smackx.omemo.exceptions.UntrustedOmemoIdentityException;
import org.jivesoftware.smackx.omemo.internal.CiphertextTuple;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.trust.OmemoFingerprint;
import org.jivesoftware.smackx.omemo.trust.OmemoTrustCallback;

public class OmemoMessageBuilder<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> {
    private final OmemoDevice userDevice;
    private final OmemoRatchet<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> ratchet;
    private final OmemoTrustCallback trustCallback;
    private byte[] messageKey;
    private final byte[] initializationVector;
    private byte[] ciphertextMessage;
    private final ArrayList<OmemoKeyElement> keys = new ArrayList();

    public OmemoMessageBuilder(OmemoDevice userDevice, OmemoTrustCallback callback, OmemoRatchet<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> ratchet, byte[] aesKey, byte[] iv, String message) throws NoSuchPaddingException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, UnsupportedEncodingException, NoSuchProviderException, InvalidAlgorithmParameterException {
        this.userDevice = userDevice;
        this.trustCallback = callback;
        this.ratchet = ratchet;
        this.messageKey = aesKey;
        this.initializationVector = iv;
        this.setMessage(message);
    }

    public OmemoMessageBuilder(OmemoDevice userDevice, OmemoTrustCallback callback, OmemoRatchet<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> ratchet, String message) throws NoSuchPaddingException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, UnsupportedEncodingException, NoSuchProviderException, InvalidAlgorithmParameterException {
        this(userDevice, callback, ratchet, OmemoMessageBuilder.generateKey("AES", 128), OmemoMessageBuilder.generateIv(), message);
    }

    private void setMessage(String message) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException, UnsupportedEncodingException, BadPaddingException, IllegalBlockSizeException {
        if (message == null) {
            return;
        }
        SecretKeySpec secretKey = new SecretKeySpec(this.messageKey, "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(this.initializationVector);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
        cipher.init(1, (Key)secretKey, ivSpec);
        byte[] body = message.getBytes("UTF-8");
        byte[] ciphertext = cipher.doFinal(body);
        byte[] clearKeyWithAuthTag = new byte[this.messageKey.length + 16];
        byte[] cipherTextWithoutAuthTag = new byte[ciphertext.length - 16];
        OmemoMessageBuilder.moveAuthTag(this.messageKey, ciphertext, clearKeyWithAuthTag, cipherTextWithoutAuthTag);
        this.ciphertextMessage = cipherTextWithoutAuthTag;
        this.messageKey = clearKeyWithAuthTag;
    }

    static void moveAuthTag(byte[] messageKey, byte[] cipherText, byte[] messageKeyWithAuthTag, byte[] cipherTextWithoutAuthTag) {
        if (messageKeyWithAuthTag.length != messageKey.length + 16) {
            throw new IllegalArgumentException("Length of messageKeyWithAuthTag must be length of messageKey + length of AuthTag (16)");
        }
        if (cipherTextWithoutAuthTag.length != cipherText.length - 16) {
            throw new IllegalArgumentException("Length of cipherTextWithoutAuthTag must be length of cipherText - length of AuthTag (16)");
        }
        System.arraycopy(messageKey, 0, messageKeyWithAuthTag, 0, 16);
        System.arraycopy(cipherText, 0, cipherTextWithoutAuthTag, 0, cipherTextWithoutAuthTag.length);
        System.arraycopy(cipherText, cipherText.length - 16, messageKeyWithAuthTag, 16, 16);
    }

    public void addRecipient(OmemoDevice contactsDevice) throws NoIdentityKeyException, CorruptedOmemoKeyException, UndecidedOmemoIdentityException, UntrustedOmemoIdentityException {
        OmemoFingerprint fingerprint = OmemoService.getInstance().getOmemoStoreBackend().getFingerprint(this.userDevice, contactsDevice);
        switch (this.trustCallback.getTrust(contactsDevice, fingerprint)) {
            case undecided: {
                throw new UndecidedOmemoIdentityException(contactsDevice);
            }
            case trusted: {
                CiphertextTuple encryptedKey = this.ratchet.doubleRatchetEncrypt(contactsDevice, this.messageKey);
                this.keys.add(new OmemoKeyElement(encryptedKey.getCiphertext(), contactsDevice.getDeviceId(), encryptedKey.isPreKeyMessage()));
                break;
            }
            case untrusted: {
                throw new UntrustedOmemoIdentityException(contactsDevice, fingerprint);
            }
        }
    }

    public OmemoElement finish() {
        OmemoHeaderElement_VAxolotl header = new OmemoHeaderElement_VAxolotl(this.userDevice.getDeviceId(), this.keys, this.initializationVector);
        return new OmemoElement_VAxolotl(header, this.ciphertextMessage);
    }

    public static byte[] generateKey(String keyType, int keyLength) throws NoSuchAlgorithmException {
        KeyGenerator generator = KeyGenerator.getInstance(keyType);
        generator.init(keyLength);
        return generator.generateKey().getEncoded();
    }

    public static byte[] generateIv() {
        SecureRandom random = new SecureRandom();
        byte[] iv = new byte[16];
        random.nextBytes(iv);
        return iv;
    }
}

