/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.hashes;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.hashes.element.HashElement;

public final class HashManager
extends Manager {
    public static final String PROVIDER = "BC";
    public static final String PREFIX_NS_ALGO = "urn:xmpp:hash-function-text-names:";
    public static final List<ALGORITHM> RECOMMENDED;
    private static final WeakHashMap<XMPPConnection, HashManager> INSTANCES;

    private HashManager(XMPPConnection connection) {
        super(connection);
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection);
        sdm.addFeature(NAMESPACE.V2.toString());
        this.addAlgorithmsToFeatures(RECOMMENDED);
    }

    public static HashElement calculateHashElement(ALGORITHM algorithm, byte[] data) {
        return new HashElement(algorithm, HashManager.hash(algorithm, data));
    }

    public static HashElement assembleHashElement(ALGORITHM algorithm, byte[] hash) {
        return new HashElement(algorithm, hash);
    }

    public void addAlgorithmsToFeatures(List<ALGORITHM> algorithms) {
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection());
        for (ALGORITHM algo : algorithms) {
            sdm.addFeature(HashManager.asFeature(algo));
        }
    }

    public static synchronized HashManager getInstanceFor(XMPPConnection connection) {
        HashManager hashManager = INSTANCES.get(connection);
        if (hashManager == null) {
            hashManager = new HashManager(connection);
            INSTANCES.put(connection, hashManager);
        }
        return hashManager;
    }

    public static String asFeature(ALGORITHM algorithm) {
        return PREFIX_NS_ALGO + algorithm.toString();
    }

    public static byte[] hash(ALGORITHM algorithm, byte[] data) {
        return HashManager.getMessageDigest(algorithm).digest(data);
    }

    public static byte[] hash(ALGORITHM algorithm, String data) {
        return HashManager.hash(algorithm, StringUtils.toUtf8Bytes((String)data));
    }

    public static MessageDigest getMessageDigest(ALGORITHM algorithm) {
        try {
            MessageDigest md;
            switch (algorithm) {
                case MD5: {
                    md = MessageDigest.getInstance("MD5", PROVIDER);
                    break;
                }
                case SHA_1: {
                    md = MessageDigest.getInstance("SHA-1", PROVIDER);
                    break;
                }
                case SHA_224: {
                    md = MessageDigest.getInstance("SHA-224", PROVIDER);
                    break;
                }
                case SHA_256: {
                    md = MessageDigest.getInstance("SHA-256", PROVIDER);
                    break;
                }
                case SHA_384: {
                    md = MessageDigest.getInstance("SHA-384", PROVIDER);
                    break;
                }
                case SHA_512: {
                    md = MessageDigest.getInstance("SHA-512", PROVIDER);
                    break;
                }
                case SHA3_224: {
                    md = MessageDigest.getInstance("SHA3-224", PROVIDER);
                    break;
                }
                case SHA3_256: {
                    md = MessageDigest.getInstance("SHA3-256", PROVIDER);
                    break;
                }
                case SHA3_384: {
                    md = MessageDigest.getInstance("SHA3-384", PROVIDER);
                    break;
                }
                case SHA3_512: {
                    md = MessageDigest.getInstance("SHA3-512", PROVIDER);
                    break;
                }
                case BLAKE2B160: {
                    md = MessageDigest.getInstance("BLAKE2b-160", PROVIDER);
                    break;
                }
                case BLAKE2B256: {
                    md = MessageDigest.getInstance("BLAKE2b-256", PROVIDER);
                    break;
                }
                case BLAKE2B384: {
                    md = MessageDigest.getInstance("BLAKE2b-384", PROVIDER);
                    break;
                }
                case BLAKE2B512: {
                    md = MessageDigest.getInstance("BLAKE2b-512", PROVIDER);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Invalid enum value: " + (Object)((Object)algorithm)));
                }
            }
            return md;
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static byte[] md5(byte[] data) {
        return HashManager.getMessageDigest(ALGORITHM.MD5).digest(data);
    }

    public static byte[] md5(String data) {
        return HashManager.md5(StringUtils.toUtf8Bytes((String)data));
    }

    public static String md5HexString(byte[] data) {
        return StringUtils.encodeHex((byte[])HashManager.md5(data));
    }

    public static String md5HexString(String data) {
        return StringUtils.encodeHex((byte[])HashManager.md5(data));
    }

    public static byte[] sha_1(byte[] data) {
        return HashManager.getMessageDigest(ALGORITHM.SHA_1).digest(data);
    }

    public static byte[] sha_1(String data) {
        return HashManager.sha_1(StringUtils.toUtf8Bytes((String)data));
    }

    public static String sha_1HexString(byte[] data) {
        return StringUtils.encodeHex((byte[])HashManager.sha_1(data));
    }

    public static String sha_1HexString(String data) {
        return StringUtils.encodeHex((byte[])HashManager.sha_1(data));
    }

    public static byte[] sha_224(byte[] data) {
        return HashManager.getMessageDigest(ALGORITHM.SHA_224).digest(data);
    }

    public static byte[] sha_224(String data) {
        return HashManager.sha_224(StringUtils.toUtf8Bytes((String)data));
    }

    public static String sha_224HexString(byte[] data) {
        return StringUtils.encodeHex((byte[])HashManager.sha_224(data));
    }

    public static String sha_224HexString(String data) {
        return StringUtils.encodeHex((byte[])HashManager.sha_224(data));
    }

    public static byte[] sha_256(byte[] data) {
        return HashManager.getMessageDigest(ALGORITHM.SHA_256).digest(data);
    }

    public static byte[] sha_256(String data) {
        return HashManager.sha_256(StringUtils.toUtf8Bytes((String)data));
    }

    public static String sha_256HexString(byte[] data) {
        return StringUtils.encodeHex((byte[])HashManager.sha_256(data));
    }

    public static String sha_256HexString(String data) {
        return StringUtils.encodeHex((byte[])HashManager.sha_256(data));
    }

    public static byte[] sha_384(byte[] data) {
        return HashManager.getMessageDigest(ALGORITHM.SHA_384).digest(data);
    }

    public static byte[] sha_384(String data) {
        return HashManager.sha_384(StringUtils.toUtf8Bytes((String)data));
    }

    public static String sha_384HexString(byte[] data) {
        return StringUtils.encodeHex((byte[])HashManager.sha_384(data));
    }

    public static String sha_384HexString(String data) {
        return StringUtils.encodeHex((byte[])HashManager.sha_384(data));
    }

    public static byte[] sha_512(byte[] data) {
        return HashManager.getMessageDigest(ALGORITHM.SHA_512).digest(data);
    }

    public static byte[] sha_512(String data) {
        return HashManager.sha_512(StringUtils.toUtf8Bytes((String)data));
    }

    public static String sha_512HexString(byte[] data) {
        return StringUtils.encodeHex((byte[])HashManager.sha_512(data));
    }

    public static String sha_512HexString(String data) {
        return StringUtils.encodeHex((byte[])HashManager.sha_512(data));
    }

    public static byte[] sha3_224(byte[] data) {
        return HashManager.getMessageDigest(ALGORITHM.SHA3_224).digest(data);
    }

    public static byte[] sha3_224(String data) {
        return HashManager.sha3_224(StringUtils.toUtf8Bytes((String)data));
    }

    public static String sha3_224HexString(byte[] data) {
        return StringUtils.encodeHex((byte[])HashManager.sha3_224(data));
    }

    public static String sha3_224HexString(String data) {
        return StringUtils.encodeHex((byte[])HashManager.sha3_224(data));
    }

    public static byte[] sha3_256(byte[] data) {
        return HashManager.getMessageDigest(ALGORITHM.SHA3_256).digest(data);
    }

    public static byte[] sha3_256(String data) {
        return HashManager.sha3_256(StringUtils.toUtf8Bytes((String)data));
    }

    public static String sha3_256HexString(byte[] data) {
        return StringUtils.encodeHex((byte[])HashManager.sha3_256(data));
    }

    public static String sha3_256HexString(String data) {
        return StringUtils.encodeHex((byte[])HashManager.sha3_256(data));
    }

    public static byte[] sha3_384(byte[] data) {
        return HashManager.getMessageDigest(ALGORITHM.SHA3_384).digest(data);
    }

    public static byte[] sha3_384(String data) {
        return HashManager.sha3_384(StringUtils.toUtf8Bytes((String)data));
    }

    public static String sha3_384HexString(byte[] data) {
        return StringUtils.encodeHex((byte[])HashManager.sha3_384(data));
    }

    public static String sha3_384HexString(String data) {
        return StringUtils.encodeHex((byte[])HashManager.sha3_384(data));
    }

    public static byte[] sha3_512(byte[] data) {
        return HashManager.getMessageDigest(ALGORITHM.SHA3_512).digest(data);
    }

    public static byte[] sha3_512(String data) {
        return HashManager.sha3_512(StringUtils.toUtf8Bytes((String)data));
    }

    public static String sha3_512HexString(byte[] data) {
        return StringUtils.encodeHex((byte[])HashManager.sha3_512(data));
    }

    public static String sha3_512HexString(String data) {
        return StringUtils.encodeHex((byte[])HashManager.sha3_512(data));
    }

    public static byte[] blake2b160(byte[] data) {
        return HashManager.getMessageDigest(ALGORITHM.BLAKE2B160).digest(data);
    }

    public static byte[] blake2b160(String data) {
        return HashManager.blake2b160(StringUtils.toUtf8Bytes((String)data));
    }

    public static String blake2b160HexString(byte[] data) {
        return StringUtils.encodeHex((byte[])HashManager.blake2b160(data));
    }

    public static String blake2b160HexString(String data) {
        return StringUtils.encodeHex((byte[])HashManager.blake2b160(data));
    }

    public static byte[] blake2b256(byte[] data) {
        return HashManager.getMessageDigest(ALGORITHM.BLAKE2B256).digest(data);
    }

    public static byte[] blake2b256(String data) {
        return HashManager.blake2b256(StringUtils.toUtf8Bytes((String)data));
    }

    public static String blake2b256HexString(byte[] data) {
        return StringUtils.encodeHex((byte[])HashManager.blake2b256(data));
    }

    public static String blake2b256HexString(String data) {
        return StringUtils.encodeHex((byte[])HashManager.blake2b256(data));
    }

    public static byte[] blake2b384(byte[] data) {
        return HashManager.getMessageDigest(ALGORITHM.BLAKE2B384).digest(data);
    }

    public static byte[] blake2b384(String data) {
        return HashManager.blake2b384(StringUtils.toUtf8Bytes((String)data));
    }

    public static String blake2b384HexString(byte[] data) {
        return StringUtils.encodeHex((byte[])HashManager.blake2b384(data));
    }

    public static String blake2b384HexString(String data) {
        return StringUtils.encodeHex((byte[])HashManager.blake2b384(data));
    }

    public static byte[] blake2b512(byte[] data) {
        return HashManager.getMessageDigest(ALGORITHM.BLAKE2B512).digest(data);
    }

    public static byte[] blake2b512(String data) {
        return HashManager.blake2b512(StringUtils.toUtf8Bytes((String)data));
    }

    public static String blake2b512HexString(byte[] data) {
        return StringUtils.encodeHex((byte[])HashManager.blake2b512(data));
    }

    public static String blake2b512HexString(String data) {
        return StringUtils.encodeHex((byte[])HashManager.blake2b512(data));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        RECOMMENDED = Collections.unmodifiableList(Arrays.asList(ALGORITHM.SHA_256, ALGORITHM.SHA_384, ALGORITHM.SHA_512, ALGORITHM.SHA3_256, ALGORITHM.SHA3_384, ALGORITHM.SHA3_512, ALGORITHM.BLAKE2B256, ALGORITHM.BLAKE2B384, ALGORITHM.BLAKE2B512));
        INSTANCES = new WeakHashMap();
    }

    public static enum ALGORITHM {
        MD5("md5", AlgorithmRecommendation.must_not),
        SHA_1("sha-1", AlgorithmRecommendation.should_not),
        SHA_224("sha-224", AlgorithmRecommendation.unknown),
        SHA_256("sha-256", AlgorithmRecommendation.must),
        SHA_384("sha-384", AlgorithmRecommendation.unknown),
        SHA_512("sha-512", AlgorithmRecommendation.should),
        SHA3_224("sha3-224", AlgorithmRecommendation.unknown),
        SHA3_256("sha3-256", AlgorithmRecommendation.must),
        SHA3_384("sha3-384", AlgorithmRecommendation.unknown),
        SHA3_512("sha3-512", AlgorithmRecommendation.should),
        BLAKE2B160("id-blake2b160", AlgorithmRecommendation.unknown),
        BLAKE2B256("id-blake2b256", AlgorithmRecommendation.must),
        BLAKE2B384("id-blake2b384", AlgorithmRecommendation.unknown),
        BLAKE2B512("id-blake2b512", AlgorithmRecommendation.should);

        private final String name;
        private final AlgorithmRecommendation recommendation;

        private ALGORITHM(String name, AlgorithmRecommendation recommendation) {
            this.name = name;
            this.recommendation = recommendation;
        }

        public String toString() {
            return this.name;
        }

        public AlgorithmRecommendation getRecommendation() {
            return this.recommendation;
        }

        public static ALGORITHM valueOfName(String s) {
            for (ALGORITHM a : ALGORITHM.values()) {
                if (!a.toString().equals(s)) continue;
                return a;
            }
            throw new IllegalArgumentException("No ALGORITHM enum with this name (" + s + ") found.");
        }
    }

    static enum AlgorithmRecommendation {
        unknown,
        must_not,
        should_not,
        should,
        must;

    }

    public static enum NAMESPACE {
        V1("urn:xmpp:hashes:1"),
        V2("urn:xmpp:hashes:2");

        final String name;

        private NAMESPACE(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

