/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mam;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.IQReplyFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.forward.packet.Forwarded;
import org.jivesoftware.smackx.mam.element.MamElements;
import org.jivesoftware.smackx.mam.element.MamFinIQ;
import org.jivesoftware.smackx.mam.element.MamPrefsIQ;
import org.jivesoftware.smackx.mam.element.MamQueryIQ;
import org.jivesoftware.smackx.mam.filter.MamResultFilter;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.rsm.packet.RSMSet;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public final class MamManager
extends Manager {
    private static final String FORM_FIELD_WITH = "with";
    private static final String FORM_FIELD_START = "start";
    private static final String FORM_FIELD_END = "end";
    private static final Map<XMPPConnection, Map<Jid, MamManager>> INSTANCES;
    private final Jid archiveAddress;
    private final ServiceDiscoveryManager serviceDiscoveryManager;

    public static MamManager getInstanceFor(XMPPConnection connection) {
        return MamManager.getInstanceFor(connection, null);
    }

    public static MamManager getInstanceFor(MultiUserChat multiUserChat) {
        XMPPConnection connection = multiUserChat.getXmppConnection();
        EntityBareJid archiveAddress = multiUserChat.getRoom();
        return MamManager.getInstanceFor(connection, (Jid)archiveAddress);
    }

    public static synchronized MamManager getInstanceFor(XMPPConnection connection, Jid archiveAddress) {
        MamManager mamManager;
        Map<Jid, MamManager> managers = INSTANCES.get(connection);
        if (managers == null) {
            managers = new HashMap<Jid, MamManager>();
            INSTANCES.put(connection, managers);
        }
        if ((mamManager = managers.get(archiveAddress)) == null) {
            mamManager = new MamManager(connection, archiveAddress);
            managers.put(archiveAddress, mamManager);
        }
        return mamManager;
    }

    private MamManager(XMPPConnection connection, Jid archiveAddress) {
        super(connection);
        this.archiveAddress = archiveAddress;
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection);
    }

    public Jid getArchiveAddress() {
        if (this.archiveAddress == null) {
            EntityFullJid localJid = this.connection().getUser();
            if (localJid == null) {
                return null;
            }
            return localJid.asBareJid();
        }
        return this.archiveAddress;
    }

    public MamQuery queryArchive(MamQueryArgs mamQueryArgs) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NotLoggedInException, InterruptedException {
        String queryId = UUID.randomUUID().toString();
        String node = mamQueryArgs.node;
        DataForm dataForm = mamQueryArgs.getDataForm();
        MamQueryIQ mamQueryIQ = new MamQueryIQ(queryId, node, dataForm);
        mamQueryIQ.setType(IQ.Type.set);
        mamQueryIQ.setTo(this.archiveAddress);
        mamQueryArgs.maybeAddRsmSet(mamQueryIQ);
        return this.queryArchive(mamQueryIQ);
    }

    private static FormField getWithFormField(Jid withJid) {
        FormField formField = new FormField(FORM_FIELD_WITH);
        formField.addValue((CharSequence)withJid.toString());
        return formField;
    }

    private static void addWithJid(Jid withJid, DataForm dataForm) {
        if (withJid == null) {
            return;
        }
        FormField formField = MamManager.getWithFormField(withJid);
        dataForm.addField(formField);
    }

    public MamQuery queryMostRecentPage(Jid jid, int max) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NotLoggedInException, InterruptedException {
        MamQueryArgs mamQueryArgs = MamQueryArgs.builder().queryLastPage().limitResultsToJid(jid).setResultPageSize(max).build();
        return this.queryArchive(mamQueryArgs);
    }

    public List<FormField> retrieveFormFields() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        return this.retrieveFormFields(null);
    }

    public List<FormField> retrieveFormFields(String node) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        String queryId = UUID.randomUUID().toString();
        MamQueryIQ mamQueryIq = new MamQueryIQ(queryId, node, null);
        mamQueryIq.setTo(this.archiveAddress);
        MamQueryIQ mamResponseQueryIq = (MamQueryIQ)this.connection().createStanzaCollectorAndSend((IQ)mamQueryIq).nextResultOrThrow();
        return mamResponseQueryIq.getDataForm().getFields();
    }

    private MamQuery queryArchive(MamQueryIQ mamQueryIq) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        MamQueryPage mamQueryPage = this.queryArchivePage(mamQueryIq);
        return new MamQuery(mamQueryPage, mamQueryIq.getNode(), DataForm.from((Stanza)mamQueryIq));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MamQueryPage queryArchivePage(MamQueryIQ mamQueryIq) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        MamFinIQ mamFinIQ;
        XMPPConnection connection = this.getAuthenticatedConnectionOrThrow();
        StanzaCollector mamFinIQCollector = connection.createStanzaCollector((StanzaFilter)new IQReplyFilter((IQ)mamQueryIq, connection));
        StanzaCollector.Configuration resultCollectorConfiguration = StanzaCollector.newConfiguration().setStanzaFilter((StanzaFilter)new MamResultFilter(mamQueryIq)).setCollectorToReset(mamFinIQCollector);
        StanzaCollector resultCollector = connection.createStanzaCollector(resultCollectorConfiguration);
        try {
            connection.sendStanza((Stanza)mamQueryIq);
            mamFinIQ = (MamFinIQ)mamFinIQCollector.nextResultOrThrow();
        }
        finally {
            mamFinIQCollector.cancel();
            resultCollector.cancel();
        }
        return new MamQueryPage(resultCollector, mamFinIQ);
    }

    private void ensureMamQueryResultMatchesThisManager(MamQueryResult mamQueryResult) {
        EntityFullJid localAddress = this.connection().getUser();
        EntityBareJid localBareAddress = null;
        if (localAddress != null) {
            localBareAddress = localAddress.asEntityBareJid();
        }
        boolean isLocalUserArchive = this.archiveAddress == null || this.archiveAddress.equals((CharSequence)localBareAddress);
        Jid finIqFrom = mamQueryResult.mamFin.getFrom();
        if (finIqFrom != null) {
            if (finIqFrom.equals((CharSequence)this.archiveAddress) || isLocalUserArchive && finIqFrom.equals((CharSequence)localBareAddress)) {
                return;
            }
            throw new IllegalArgumentException("The given MamQueryResult is from the MAM archive '" + finIqFrom + "' whereas this MamManager is responsible for '" + this.archiveAddress + '\'');
        }
        if (!isLocalUserArchive) {
            throw new IllegalArgumentException("The given MamQueryResult is from the local entity (user) MAM archive, whereas this MamManager is responsible for '" + this.archiveAddress + '\'');
        }
    }

    public boolean isSupported() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Jid archiveAddress = this.getArchiveAddress();
        return this.serviceDiscoveryManager.supportsFeature(archiveAddress, (CharSequence)"urn:xmpp:mam:1");
    }

    private static DataForm getNewMamForm() {
        FormField field = new FormField("FORM_TYPE");
        field.setType(FormField.Type.hidden);
        field.addValue((CharSequence)"urn:xmpp:mam:1");
        DataForm form = new DataForm(DataForm.Type.submit);
        form.addField(field);
        return form;
    }

    public String getMessageUidOfLatestMessage() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NotLoggedInException, InterruptedException {
        MamQueryArgs mamQueryArgs = MamQueryArgs.builder().setResultPageSize(1).queryLastPage().build();
        MamQuery mamQuery = this.queryArchive(mamQueryArgs);
        if (mamQuery.getMessages().isEmpty()) {
            return null;
        }
        return mamQuery.getMamResultExtensions().get(0).getId();
    }

    public MamPrefsResult retrieveArchivingPreferences() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        MamPrefsIQ mamPrefIQ = new MamPrefsIQ();
        return this.queryMamPrefs(mamPrefIQ);
    }

    @Deprecated
    public MamPrefsResult updateArchivingPreferences(List<Jid> alwaysJids, List<Jid> neverJids, MamPrefsIQ.DefaultBehavior defaultBehavior) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        Objects.requireNonNull((Object)((Object)defaultBehavior), (String)"Default behavior must be set");
        MamPrefsIQ mamPrefIQ = new MamPrefsIQ(alwaysJids, neverJids, defaultBehavior);
        return this.queryMamPrefs(mamPrefIQ);
    }

    public MamPrefsResult updateArchivingPreferences(MamPrefs mamPrefs) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        MamPrefsIQ mamPrefIQ = mamPrefs.constructMamPrefsIq();
        return this.queryMamPrefs(mamPrefIQ);
    }

    public MamPrefsResult enableMamForAllMessages() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NotLoggedInException, InterruptedException {
        return this.setDefaultBehavior(MamPrefsIQ.DefaultBehavior.always);
    }

    public MamPrefsResult enableMamForRosterMessages() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NotLoggedInException, InterruptedException {
        return this.setDefaultBehavior(MamPrefsIQ.DefaultBehavior.roster);
    }

    public MamPrefsResult setDefaultBehavior(MamPrefsIQ.DefaultBehavior desiredDefaultBehavior) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NotLoggedInException, InterruptedException {
        MamPrefsResult mamPrefsResult = this.retrieveArchivingPreferences();
        if (mamPrefsResult.mamPrefs.getDefault() == desiredDefaultBehavior) {
            return mamPrefsResult;
        }
        MamPrefs mamPrefs = mamPrefsResult.asMamPrefs();
        mamPrefs.setDefaultBehavior(desiredDefaultBehavior);
        return this.updateArchivingPreferences(mamPrefs);
    }

    private MamPrefsResult queryMamPrefs(MamPrefsIQ mamPrefsIQ) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        XMPPConnection connection = this.getAuthenticatedConnectionOrThrow();
        MamPrefsIQ mamPrefsResultIQ = (MamPrefsIQ)connection.createStanzaCollectorAndSend((IQ)mamPrefsIQ).nextResultOrThrow();
        return new MamPrefsResult(mamPrefsResultIQ, DataForm.from((Stanza)mamPrefsIQ));
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                MamManager.getInstanceFor(connection);
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, Map<Jid, MamManager>>();
    }

    public static final class MamPrefs {
        private final List<Jid> alwaysJids;
        private final List<Jid> neverJids;
        private MamPrefsIQ.DefaultBehavior defaultBehavior;

        private MamPrefs(MamPrefsResult mamPrefsResult) {
            MamPrefsIQ mamPrefsIq = mamPrefsResult.mamPrefs;
            this.alwaysJids = new ArrayList<Jid>(mamPrefsIq.getAlwaysJids());
            this.neverJids = new ArrayList<Jid>(mamPrefsIq.getNeverJids());
            this.defaultBehavior = mamPrefsIq.getDefault();
        }

        public void setDefaultBehavior(MamPrefsIQ.DefaultBehavior defaultBehavior) {
            this.defaultBehavior = (MamPrefsIQ.DefaultBehavior)((Object)Objects.requireNonNull((Object)((Object)defaultBehavior), (String)"defaultBehavior must not be null"));
        }

        public MamPrefsIQ.DefaultBehavior getDefaultBehavior() {
            return this.defaultBehavior;
        }

        public List<Jid> getAlwaysJids() {
            return this.alwaysJids;
        }

        public List<Jid> getNeverJids() {
            return this.neverJids;
        }

        private MamPrefsIQ constructMamPrefsIq() {
            return new MamPrefsIQ(this.alwaysJids, this.neverJids, this.defaultBehavior);
        }
    }

    public static final class MamPrefsResult {
        public final MamPrefsIQ mamPrefs;
        public final DataForm form;

        private MamPrefsResult(MamPrefsIQ mamPrefs, DataForm form) {
            this.mamPrefs = mamPrefs;
            this.form = form;
        }

        public MamPrefs asMamPrefs() {
            return new MamPrefs(this);
        }
    }

    public static final class MamQueryPage {
        private final MamFinIQ mamFin;
        private final List<Message> mamResultCarrierMessages;
        private final List<MamElements.MamResultExtension> mamResultExtensions;
        private final List<Forwarded> forwardedMessages;
        private final List<Message> messages;

        private MamQueryPage(StanzaCollector stanzaCollector, MamFinIQ mamFin) {
            this.mamFin = mamFin;
            List mamResultCarrierStanzas = stanzaCollector.getCollectedStanzasAfterCancelled();
            ArrayList<Message> mamResultCarrierMessages = new ArrayList<Message>(mamResultCarrierStanzas.size());
            ArrayList<MamElements.MamResultExtension> mamResultExtensions = new ArrayList<MamElements.MamResultExtension>(mamResultCarrierStanzas.size());
            ArrayList<Forwarded> forwardedMessages = new ArrayList<Forwarded>(mamResultCarrierStanzas.size());
            for (Stanza mamResultStanza : mamResultCarrierStanzas) {
                Message resultMessage = (Message)mamResultStanza;
                mamResultCarrierMessages.add(resultMessage);
                MamElements.MamResultExtension mamResultExtension = MamElements.MamResultExtension.from(resultMessage);
                mamResultExtensions.add(mamResultExtension);
                forwardedMessages.add(mamResultExtension.getForwarded());
            }
            this.mamResultCarrierMessages = Collections.unmodifiableList(mamResultCarrierMessages);
            this.mamResultExtensions = Collections.unmodifiableList(mamResultExtensions);
            this.forwardedMessages = Collections.unmodifiableList(forwardedMessages);
            this.messages = Collections.unmodifiableList(Forwarded.extractMessagesFrom(forwardedMessages));
        }

        public List<Message> getMessages() {
            return this.messages;
        }

        public List<Forwarded> getForwarded() {
            return this.forwardedMessages;
        }

        public List<MamElements.MamResultExtension> getMamResultExtensions() {
            return this.mamResultExtensions;
        }

        public List<Message> getMamResultCarrierMessages() {
            return this.mamResultCarrierMessages;
        }

        public MamFinIQ getMamFinIq() {
            return this.mamFin;
        }
    }

    public final class MamQuery {
        private final String node;
        private final DataForm form;
        private MamQueryPage mamQueryPage;

        private MamQuery(MamQueryPage mamQueryPage, String node, DataForm form) {
            this.node = node;
            this.form = form;
            this.mamQueryPage = mamQueryPage;
        }

        public boolean isComplete() {
            return this.mamQueryPage.getMamFinIq().isComplete();
        }

        public List<Message> getMessages() {
            return this.mamQueryPage.messages;
        }

        public List<MamElements.MamResultExtension> getMamResultExtensions() {
            return this.mamQueryPage.mamResultExtensions;
        }

        private List<Message> page(RSMSet requestRsmSet) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NotLoggedInException, InterruptedException {
            MamQueryIQ mamQueryIQ = new MamQueryIQ(UUID.randomUUID().toString(), this.node, this.form);
            mamQueryIQ.setType(IQ.Type.set);
            mamQueryIQ.setTo(MamManager.this.archiveAddress);
            mamQueryIQ.addExtension((ExtensionElement)requestRsmSet);
            this.mamQueryPage = MamManager.this.queryArchivePage(mamQueryIQ);
            return this.mamQueryPage.messages;
        }

        private RSMSet getPreviousRsmSet() {
            return this.mamQueryPage.getMamFinIq().getRSMSet();
        }

        public List<Message> pageNext(int count) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NotLoggedInException, InterruptedException {
            RSMSet previousResultRsmSet = this.getPreviousRsmSet();
            RSMSet requestRsmSet = new RSMSet(count, previousResultRsmSet.getLast(), RSMSet.PageDirection.after);
            return this.page(requestRsmSet);
        }

        public List<Message> pagePrevious(int count) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NotLoggedInException, InterruptedException {
            RSMSet previousResultRsmSet = this.getPreviousRsmSet();
            RSMSet requestRsmSet = new RSMSet(count, previousResultRsmSet.getLast(), RSMSet.PageDirection.before);
            return this.page(requestRsmSet);
        }

        public int getMessageCount() {
            return this.getMessages().size();
        }

        public MamQueryPage getPage() {
            return this.mamQueryPage;
        }
    }

    @Deprecated
    public static final class MamQueryResult {
        public final List<Forwarded> forwardedMessages;
        public final MamFinIQ mamFin;
        private final String node;
        private final DataForm form;

        private MamQueryResult(MamQuery mamQuery) {
            this(mamQuery.mamQueryPage.forwardedMessages, mamQuery.mamQueryPage.mamFin, mamQuery.node, mamQuery.form);
        }

        private MamQueryResult(List<Forwarded> forwardedMessages, MamFinIQ mamFin, String node, DataForm form) {
            this.forwardedMessages = forwardedMessages;
            this.mamFin = mamFin;
            this.node = node;
            this.form = form;
        }
    }

    public static final class MamQueryArgs {
        private final String node;
        private final Map<String, FormField> formFields;
        private final Integer maxResults;
        private final String afterUid;
        private final String beforeUid;
        private DataForm dataForm;

        private MamQueryArgs(Builder builder) {
            this.node = builder.node;
            this.formFields = builder.formFields;
            this.maxResults = builder.maxResults > 0 ? Integer.valueOf(builder.maxResults) : null;
            this.afterUid = builder.afterUid;
            this.beforeUid = builder.beforeUid;
        }

        DataForm getDataForm() {
            if (this.dataForm != null) {
                return this.dataForm;
            }
            this.dataForm = MamManager.getNewMamForm();
            this.dataForm.addFields(this.formFields.values());
            return this.dataForm;
        }

        void maybeAddRsmSet(MamQueryIQ mamQueryIQ) {
            if (this.maxResults == null && this.afterUid == null && this.beforeUid == null) {
                return;
            }
            int max = this.maxResults != null ? this.maxResults : -1;
            RSMSet rsmSet = new RSMSet(this.afterUid, this.beforeUid, -1, -1, null, max, null, -1);
            mamQueryIQ.addExtension((ExtensionElement)rsmSet);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String node;
            private final Map<String, FormField> formFields = new HashMap<String, FormField>(8);
            private int maxResults = -1;
            private String afterUid;
            private String beforeUid;

            public Builder queryNode(String node) {
                if (node == null) {
                    return this;
                }
                this.node = node;
                return this;
            }

            public Builder limitResultsToJid(Jid withJid) {
                if (withJid == null) {
                    return this;
                }
                FormField formField = MamManager.getWithFormField(withJid);
                this.formFields.put(formField.getVariable(), formField);
                return this;
            }

            public Builder limitResultsSince(Date start) {
                if (start == null) {
                    return this;
                }
                FormField formField = new FormField(MamManager.FORM_FIELD_START);
                formField.addValue(start);
                this.formFields.put(formField.getVariable(), formField);
                FormField endFormField = this.formFields.get(MamManager.FORM_FIELD_END);
                if (endFormField != null) {
                    Date end;
                    try {
                        end = endFormField.getFirstValueAsDate();
                    }
                    catch (ParseException e) {
                        throw new IllegalStateException(e);
                    }
                    if (end.getTime() <= start.getTime()) {
                        throw new IllegalArgumentException("Given start date (" + start + ") is after the existing end date (" + end + ')');
                    }
                }
                return this;
            }

            public Builder limitResultsBefore(Date end) {
                if (end == null) {
                    return this;
                }
                FormField formField = new FormField(MamManager.FORM_FIELD_END);
                formField.addValue(end);
                this.formFields.put(formField.getVariable(), formField);
                FormField startFormField = this.formFields.get(MamManager.FORM_FIELD_START);
                if (startFormField != null) {
                    Date start;
                    try {
                        start = startFormField.getFirstValueAsDate();
                    }
                    catch (ParseException e) {
                        throw new IllegalStateException(e);
                    }
                    if (end.getTime() <= start.getTime()) {
                        throw new IllegalArgumentException("Given end date (" + end + ") is before the existing start date (" + start + ')');
                    }
                }
                return this;
            }

            public Builder setResultPageSize(Integer max) {
                if (max == null) {
                    this.maxResults = -1;
                    return this;
                }
                return this.setResultPageSizeTo(max);
            }

            public Builder setResultPageSizeTo(int max) {
                if (max < 0) {
                    throw new IllegalArgumentException();
                }
                this.maxResults = max;
                return this;
            }

            public Builder onlyReturnMessageCount() {
                return this.setResultPageSizeTo(0);
            }

            public Builder withAdditionalFormField(FormField formField) {
                this.formFields.put(formField.getVariable(), formField);
                return this;
            }

            public Builder withAdditionalFormFields(List<FormField> additionalFields) {
                for (FormField formField : additionalFields) {
                    this.withAdditionalFormField(formField);
                }
                return this;
            }

            public Builder afterUid(String afterUid) {
                this.afterUid = (String)StringUtils.requireNullOrNotEmpty((CharSequence)afterUid, (String)"afterUid must not be empty");
                return this;
            }

            public Builder beforeUid(String beforeUid) {
                this.beforeUid = beforeUid;
                return this;
            }

            public Builder queryLastPage() {
                return this.beforeUid("");
            }

            public MamQueryArgs build() {
                return new MamQueryArgs(this);
            }
        }
    }
}

