/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.rule;

import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.powermock.classloading.spi.DoNotClone;
import org.powermock.modules.junit4.rule.PowerMockRuleTestSuiteChunker;
import org.powermock.modules.junit4.rule.PowerMockStatement;
import org.powermock.tests.utils.MockPolicyInitializer;
import org.powermock.tests.utils.TestSuiteChunker;
import org.powermock.tests.utils.impl.MockPolicyInitializerImpl;

public class PowerMockRule
implements MethodRule {
    private static Class<?> previousTargetClass;
    private static MockPolicyInitializer mockPolicyInitializer;
    @DoNotClone
    private static TestSuiteChunker testSuiteChunker;

    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        if (this.isNotRuleInitialized(target)) {
            this.init(target);
        }
        return new PowerMockStatement(base, testSuiteChunker.getTestChunk(method.getMethod()), mockPolicyInitializer);
    }

    protected boolean isNotRuleInitialized(Object target) {
        return testSuiteChunker == null || previousTargetClass != target.getClass();
    }

    protected void init(Object target) {
        Class<?> testClass = target.getClass();
        try {
            mockPolicyInitializer = new MockPolicyInitializerImpl(testClass);
            testSuiteChunker = new PowerMockRuleTestSuiteChunker(testClass);
            previousTargetClass = target.getClass();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

