/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest;

import java.lang.reflect.Method;
import java.util.List;
import org.igniterealtime.smack.inttest.SmackIntegrationTestFramework;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.junit.Assert;
import org.junit.Test;

public class SmackIntegrationTestFrameWorkTest {
    private static Method getTestMethod(Class<?> testClass) {
        Method[] methods;
        for (Method method : methods = testClass.getDeclaredMethods()) {
            if (!method.getName().equals("test")) continue;
            return method;
        }
        throw new IllegalArgumentException("No test method found in " + testClass);
    }

    @Test
    public void testValidLowLevelList() {
        Method testMethod = SmackIntegrationTestFrameWorkTest.getTestMethod(ValidLowLevelList.class);
        Assert.assertTrue((boolean)SmackIntegrationTestFramework.testMethodParametersIsListOfConnections((Method)testMethod, AbstractXMPPConnection.class));
    }

    @Test
    public void testInvalidLowLevelList() {
        Method testMethod = SmackIntegrationTestFrameWorkTest.getTestMethod(InvalidLowLevelList.class);
        Assert.assertFalse((boolean)SmackIntegrationTestFramework.testMethodParametersIsListOfConnections((Method)testMethod, AbstractXMPPConnection.class));
    }

    @Test
    public void testValidLowLevelVarargs() {
        Method testMethod = SmackIntegrationTestFrameWorkTest.getTestMethod(ValidLowLevelVarargs.class);
        Assert.assertTrue((boolean)SmackIntegrationTestFramework.testMethodParametersVarargsConnections((Method)testMethod, AbstractXMPPConnection.class));
    }

    @Test
    public void testInvalidLowLevelVargs() {
        Method testMethod = SmackIntegrationTestFrameWorkTest.getTestMethod(InvalidLowLevelVarargs.class);
        Assert.assertFalse((boolean)SmackIntegrationTestFramework.testMethodParametersVarargsConnections((Method)testMethod, AbstractXMPPConnection.class));
    }

    private static class InvalidLowLevelVarargs {
        private InvalidLowLevelVarargs() {
        }

        public void test(AbstractXMPPConnection connectionOne, Integer invalid, AbstractXMPPConnection connectionTwo, AbstractXMPPConnection connectionThree) {
        }
    }

    private static class ValidLowLevelVarargs {
        private ValidLowLevelVarargs() {
        }

        public void test(AbstractXMPPConnection connectionOne, AbstractXMPPConnection connectionTwo, AbstractXMPPConnection connectionThree) {
        }
    }

    private static class InvalidLowLevelList {
        private InvalidLowLevelList() {
        }

        public void test(List<AbstractXMPPConnection> connections, boolean invalid) {
        }
    }

    private static class ValidLowLevelList {
        private ValidLowLevelList() {
        }

        public void test(List<AbstractXMPPConnection> connections) {
        }
    }
}

