/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.AbstractXmppNioConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SmackReactor;
import org.jivesoftware.smack.SynchronizationPoint;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.XmppInputOutputFilter;
import org.jivesoftware.smack.fsm.AbstractXmppStateMachineConnection;
import org.jivesoftware.smack.fsm.ConnectionStateEvent;
import org.jivesoftware.smack.fsm.StateDescriptor;
import org.jivesoftware.smack.fsm.StateDescriptorGraph;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StartTls;
import org.jivesoftware.smack.packet.StreamClose;
import org.jivesoftware.smack.packet.TlsFailure;
import org.jivesoftware.smack.packet.TlsProceed;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.sasl.SASLErrorException;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smack.util.ArrayBlockingQueueWithShutdown;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.UTF8;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.dns.HostAddress;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.util.JidUtil;
import org.jxmpp.stringprep.XmppStringprepException;
import org.jxmpp.xml.splitter.Utf8ByteXmppXmlSplitter;
import org.jxmpp.xml.splitter.XmlPrettyPrinter;
import org.jxmpp.xml.splitter.XmlPrinter;
import org.jxmpp.xml.splitter.XmppElementCallback;
import org.jxmpp.xml.splitter.XmppXmlSplitter;

public class XmppNioTcpConnection
extends AbstractXmppNioConnection {
    private static final Logger LOGGER = Logger.getLogger(XmppNioTcpConnection.class.getName());
    private static final Set<Class<? extends StateDescriptor>> BACKWARD_EDGES_STATE_DESCRIPTORS = new HashSet<Class<? extends StateDescriptor>>();
    static final StateDescriptorGraph.GraphVertex<StateDescriptor> INITIAL_STATE_DESCRIPTOR_VERTEX;
    private static final int CALLBACK_MAX_BYTES_READ = 0xA00000;
    private static final int CALLBACK_MAX_BYTES_WRITEN = 0xA00000;
    private static final int MAX_ELEMENT_SIZE = 65536;
    private SelectionKey selectionKey;
    private SmackReactor.SelectionKeyAttachment selectionKeyAttachment;
    private SocketChannel socketChannel;
    private InetSocketAddress remoteAddress;
    private TlsState tlsState;
    private Utf8ByteXmppXmlSplitter splitter;
    private XmppXmlSplitter outputDebugSplitter;
    private static final Level STREAM_OPEN_CLOSE_DEBUG_LOG_LEVEL;
    private final XmppElementCallback xmppElementCallback = new XmppElementCallback(){
        private String streamOpen;
        private String streamClose;

        public void onCompleteElement(String completeElement) {
            assert (this.streamOpen != null);
            assert (this.streamClose != null);
            if (XmppNioTcpConnection.this.debugger != null) {
                XmppNioTcpConnection.this.debugger.onIncomingElementCompleted();
            }
            String wrappedCompleteElement = this.streamOpen + completeElement + this.streamClose;
            try {
                XmppNioTcpConnection.this.parseAndProcessElement(wrappedCompleteElement);
            }
            catch (Exception e) {
                XmppNioTcpConnection.this.notifyConnectionError(e);
            }
        }

        public void streamOpened(String prefix, Map<String, String> attributes) {
            XmlPullParser streamOpenParser;
            if (LOGGER.isLoggable(STREAM_OPEN_CLOSE_DEBUG_LOG_LEVEL)) {
                LOGGER.log(STREAM_OPEN_CLOSE_DEBUG_LOG_LEVEL, "Stream of " + this + " opened. prefix=" + prefix + " attributes=" + attributes);
            }
            String prefixXmlns = "xmlns:" + prefix;
            StringBuilder streamClose = new StringBuilder(32);
            StringBuilder streamOpen = new StringBuilder(256);
            streamOpen.append('<');
            streamClose.append("</");
            if (StringUtils.isNotEmpty((CharSequence)prefix)) {
                streamOpen.append(prefix).append(':');
                streamClose.append(prefix).append(':');
            }
            streamOpen.append("stream");
            streamClose.append("stream>");
            block20: for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String attributeName = entry.getKey();
                String attributeValue = entry.getValue();
                switch (attributeName) {
                    case "id": {
                        XmppNioTcpConnection.this.streamId = attributeValue;
                        continue block20;
                    }
                    case "version": {
                        continue block20;
                    }
                    case "xml:lang": {
                        streamOpen.append(" xml:lang='").append(attributeValue).append('\'');
                        continue block20;
                    }
                    case "to": {
                        continue block20;
                    }
                    case "from": {
                        DomainBareJid reportedServerDomain;
                        try {
                            reportedServerDomain = JidCreate.domainBareFrom((String)attributeValue);
                        }
                        catch (XmppStringprepException e) {
                            IllegalStateException ise = new IllegalStateException("Reporting server domain '" + attributeValue + "' is not a valid JID", e);
                            XmppNioTcpConnection.this.notifyConnectionError(ise);
                            return;
                        }
                        assert (XmppNioTcpConnection.this.config.getXMPPServiceDomain().equals((CharSequence)reportedServerDomain));
                        continue block20;
                    }
                    case "xmlns": {
                        streamOpen.append(" xmlns='").append(attributeValue).append('\'');
                        continue block20;
                    }
                }
                if (attributeName.equals(prefixXmlns)) {
                    streamOpen.append(' ').append(prefixXmlns).append("='").append(attributeValue).append('\'');
                    continue;
                }
                LOGGER.info("Unknown <stream/> attribute: " + attributeName);
            }
            streamOpen.append('>');
            this.streamOpen = streamOpen.toString();
            this.streamClose = streamClose.toString();
            try {
                streamOpenParser = PacketParserUtils.getParserFor((String)this.streamOpen);
            }
            catch (IOException | XmlPullParserException e) {
                throw new AssertionError((Object)e);
            }
            XmppNioTcpConnection.this.onStreamOpen(streamOpenParser);
        }

        public void streamClosed() {
            if (LOGGER.isLoggable(STREAM_OPEN_CLOSE_DEBUG_LOG_LEVEL)) {
                LOGGER.log(STREAM_OPEN_CLOSE_DEBUG_LOG_LEVEL, "Stream of " + this + " closed");
            }
            XmppNioTcpConnection.this.closingStreamReceived.reportSuccess();
        }
    };
    private final ArrayBlockingQueueWithShutdown<TopLevelStreamElement> outgoingElementsQueue = new ArrayBlockingQueueWithShutdown(100, true);
    private Iterator<CharSequence> outgoingCharSequenceIterator;
    private final List<TopLevelStreamElement> currentlyOutgoingElements = new ArrayList<TopLevelStreamElement>();
    private final Map<ByteBuffer, List<TopLevelStreamElement>> bufferToElementMap = new IdentityHashMap<ByteBuffer, List<TopLevelStreamElement>>();
    private ByteBuffer outgoingBuffer;
    private ByteBuffer filteredOutgoingBuffer;
    private final List<ByteBuffer> networkOutgoingBuffers = new ArrayList<ByteBuffer>();
    private long networkOutgoingBuffersBytes;
    private final ByteBuffer incomingBuffer = ByteBuffer.allocateDirect(8192);
    private final ReentrantLock channelSelectedCallbackLock = new ReentrantLock();
    private long totalBytesRead;
    private long totalBytesWritten;
    private long totalBytesReadAfterFilter;
    private long totalBytesWrittenBeforeFilter;
    private long handledChannelSelectedCallbacks;
    private long callbackPreemtBecauseBytesWritten;
    private long callbackPreemtBecauseBytesRead;
    private int sslEngineDelegatedTasks;
    private int maxPendingSslEngineDelegatedTasks;
    private final AtomicLong setWriteInterestAfterChannelSelectedCallback = new AtomicLong();
    private final AtomicLong reactorThreadAlreadyRacing = new AtomicLong();
    private final AtomicLong afterOutgoingElementsQueueModifiedSetInterestOps = new AtomicLong();
    private final AtomicLong rejectedChannelSelectedCallbacks = new AtomicLong();
    private Jid lastDestinationAddress;
    private boolean pendingInputFilterData;
    private boolean pendingOutputFilterData;
    private boolean pendingWriteInterestAfterRead;
    private boolean useDirectTls = false;
    private boolean useSm = false;
    private boolean useSmResumption = false;
    private boolean useIsr = false;
    private boolean useBind2 = false;
    private final SmackReactor.ChannelSelectedCallback channelSelectedCallback = (selectedChannel, selectedSelectionKey) -> {
        int newInterestedOps;
        block55: {
            assert (this.selectionKey == null || this.selectionKey == selectedSelectionKey);
            SocketChannel selectedSocketChannel = (SocketChannel)selectedChannel;
            newInterestedOps = 1;
            boolean newPendingOutputFilterData = false;
            if (!this.channelSelectedCallbackLock.tryLock()) {
                this.rejectedChannelSelectedCallbacks.incrementAndGet();
                return;
            }
            ++this.handledChannelSelectedCallbacks;
            long callbackBytesRead = 0L;
            long callbackBytesWritten = 0L;
            try {
                block54: {
                    boolean destinationAddressChanged = false;
                    boolean isLastPartOfElement = false;
                    TopLevelStreamElement currentlyOutgonigTopLevelStreamElement = null;
                    StringBuilder outgoingStreamForDebugger = null;
                    while (true) {
                        CharSequence nextCharSequence;
                        boolean moreDataAvailable;
                        boolean bl = moreDataAvailable = !isLastPartOfElement || !this.outgoingElementsQueue.isEmpty();
                        if (this.filteredOutgoingBuffer != null || !this.networkOutgoingBuffers.isEmpty()) {
                            long bytesWritten;
                            if (this.filteredOutgoingBuffer != null) {
                                this.networkOutgoingBuffers.add(this.filteredOutgoingBuffer);
                                this.networkOutgoingBuffersBytes += (long)this.filteredOutgoingBuffer.remaining();
                                this.filteredOutgoingBuffer = null;
                                if (moreDataAvailable && this.networkOutgoingBuffersBytes < 8096L) continue;
                            }
                            ByteBuffer[] output = this.networkOutgoingBuffers.toArray(new ByteBuffer[this.networkOutgoingBuffers.size()]);
                            try {
                                bytesWritten = selectedSocketChannel.write(output);
                            }
                            catch (IOException e) {
                                this.handleReadWriteIoException(e);
                                break block54;
                            }
                            if (bytesWritten == 0L) {
                                newInterestedOps |= 4;
                            } else {
                                callbackBytesWritten += bytesWritten;
                                this.networkOutgoingBuffersBytes -= bytesWritten;
                                List<? extends Buffer> prunedBuffers = XmppNioTcpConnection.pruneBufferList(this.networkOutgoingBuffers);
                                for (Buffer buffer : prunedBuffers) {
                                    List<TopLevelStreamElement> sendElements = this.bufferToElementMap.remove(buffer);
                                    if (sendElements == null) continue;
                                    for (TopLevelStreamElement elementJustSend : sendElements) {
                                        this.firePacketSendingListeners(elementJustSend);
                                    }
                                }
                                if (callbackBytesWritten <= 0xA00000L) continue;
                                newInterestedOps |= 4;
                                ++this.callbackPreemtBecauseBytesWritten;
                            }
                            break block54;
                        }
                        if (this.outgoingBuffer != null || this.pendingOutputFilterData) {
                            this.pendingOutputFilterData = false;
                            if (this.outgoingBuffer != null) {
                                this.totalBytesWrittenBeforeFilter += (long)this.outgoingBuffer.remaining();
                                if (isLastPartOfElement) {
                                    assert (currentlyOutgonigTopLevelStreamElement != null);
                                    this.currentlyOutgoingElements.add(currentlyOutgonigTopLevelStreamElement);
                                }
                            }
                            ByteBuffer outputFilterInputData = this.outgoingBuffer;
                            this.outgoingBuffer = null;
                            ListIterator it = this.getXmppInputOutputFilterBeginIterator();
                            while (it.hasNext()) {
                                XmppInputOutputFilter.OutputResult outputResult;
                                XmppInputOutputFilter inputOutputFilter = (XmppInputOutputFilter)it.next();
                                try {
                                    outputResult = inputOutputFilter.output(outputFilterInputData, isLastPartOfElement, destinationAddressChanged, moreDataAvailable);
                                }
                                catch (IOException e) {
                                    this.notifyConnectionError(e);
                                    break block54;
                                }
                                newPendingOutputFilterData |= outputResult.pendingFilterData;
                                outputFilterInputData = outputResult.filteredOutputData;
                                if (outputFilterInputData == null) continue;
                                outputFilterInputData.flip();
                            }
                            this.filteredOutgoingBuffer = outputFilterInputData != null && outputFilterInputData.hasRemaining() ? outputFilterInputData : null;
                            if (this.filteredOutgoingBuffer == null && newPendingOutputFilterData) {
                                this.pendingWriteInterestAfterRead = true;
                            }
                            if (this.filteredOutgoingBuffer != null && isLastPartOfElement) {
                                this.bufferToElementMap.put(this.filteredOutgoingBuffer, new ArrayList<TopLevelStreamElement>(this.currentlyOutgoingElements));
                                this.currentlyOutgoingElements.clear();
                            }
                            if (!destinationAddressChanged) continue;
                            destinationAddressChanged = false;
                            continue;
                        }
                        if (this.outgoingCharSequenceIterator != null) {
                            nextCharSequence = this.outgoingCharSequenceIterator.next();
                            this.outgoingBuffer = UTF8.encode((CharSequence)nextCharSequence);
                            if (!this.outgoingCharSequenceIterator.hasNext()) {
                                this.outgoingCharSequenceIterator = null;
                                isLastPartOfElement = true;
                            } else {
                                isLastPartOfElement = false;
                            }
                            if (this.debugger == null) continue;
                            if (outgoingStreamForDebugger == null) {
                                outgoingStreamForDebugger = new StringBuilder();
                            }
                            outgoingStreamForDebugger.append(nextCharSequence);
                            if (!isLastPartOfElement) continue;
                            try {
                                this.outputDebugSplitter.append((CharSequence)outgoingStreamForDebugger);
                            }
                            catch (IOException e) {
                                throw new AssertionError((Object)e);
                            }
                            this.debugger.onOutgoingElementCompleted();
                            outgoingStreamForDebugger = null;
                            continue;
                        }
                        if (this.outgoingElementsQueue.isEmpty()) break block54;
                        currentlyOutgonigTopLevelStreamElement = (TopLevelStreamElement)this.outgoingElementsQueue.poll();
                        if (currentlyOutgonigTopLevelStreamElement instanceof Stanza) {
                            Stanza currentlyOutgoingStanza = (Stanza)currentlyOutgonigTopLevelStreamElement;
                            Jid currentDestinationAddress = currentlyOutgoingStanza.getTo();
                            destinationAddressChanged = !JidUtil.equals((Jid)this.lastDestinationAddress, (Jid)currentDestinationAddress);
                            this.lastDestinationAddress = currentDestinationAddress;
                        }
                        if ((nextCharSequence = currentlyOutgonigTopLevelStreamElement.toXML("jabber:client")) instanceof XmlStringBuilder) {
                            XmlStringBuilder xmlStringBuilder = (XmlStringBuilder)nextCharSequence;
                            this.outgoingCharSequenceIterator = xmlStringBuilder.getCharSequenceIterator();
                        } else {
                            this.outgoingCharSequenceIterator = Collections.singletonList(nextCharSequence).iterator();
                        }
                        if (!$assertionsDisabled && this.outgoingCharSequenceIterator == null) break;
                    }
                    throw new AssertionError();
                }
                this.pendingOutputFilterData = newPendingOutputFilterData;
                if (!this.pendingWriteInterestAfterRead && this.pendingOutputFilterData) {
                    newInterestedOps |= 4;
                }
                while (true) {
                    int bytesRead;
                    if (callbackBytesRead > 0xA00000L) {
                        ++this.callbackPreemtBecauseBytesRead;
                        break;
                    }
                    this.incomingBuffer.clear();
                    try {
                        bytesRead = selectedSocketChannel.read(this.incomingBuffer);
                    }
                    catch (IOException e) {
                        this.handleReadWriteIoException(e);
                        this.totalBytesWritten += callbackBytesWritten;
                        this.totalBytesRead += callbackBytesRead;
                        this.channelSelectedCallbackLock.unlock();
                        return;
                    }
                    if (bytesRead < 0) {
                        LOGGER.finer("NIO read() returned " + bytesRead + " for " + (Object)((Object)this) + ". This probably means that the TCP connection was terminated.");
                        return;
                    }
                    if (!this.pendingInputFilterData) {
                        if (bytesRead == 0) {
                            break;
                        }
                    } else {
                        this.pendingInputFilterData = false;
                    }
                    if (this.pendingWriteInterestAfterRead) {
                        this.pendingWriteInterestAfterRead = false;
                        newInterestedOps |= 4;
                    }
                    callbackBytesRead += (long)bytesRead;
                    ByteBuffer filteredIncomingBuffer = this.incomingBuffer;
                    ListIterator it = this.getXmppInputOutputFilterEndIterator();
                    while (it.hasPrevious()) {
                        ByteBuffer newFilteredIncomingBuffer;
                        filteredIncomingBuffer.flip();
                        try {
                            newFilteredIncomingBuffer = ((XmppInputOutputFilter)it.previous()).input(filteredIncomingBuffer);
                        }
                        catch (IOException e) {
                            this.notifyConnectionError(e);
                            this.totalBytesWritten += callbackBytesWritten;
                            this.totalBytesRead += callbackBytesRead;
                            this.channelSelectedCallbackLock.unlock();
                            return;
                        }
                        if (newFilteredIncomingBuffer == null) {
                            break block55;
                        }
                        filteredIncomingBuffer = newFilteredIncomingBuffer;
                    }
                    int bytesReadAfterFilter = filteredIncomingBuffer.flip().remaining();
                    this.totalBytesReadAfterFilter += (long)bytesReadAfterFilter;
                    try {
                        this.splitter.write(filteredIncomingBuffer);
                    }
                    catch (IOException e) {
                        this.notifyConnectionError(e);
                        this.totalBytesWritten += callbackBytesWritten;
                        this.totalBytesRead += callbackBytesRead;
                        this.channelSelectedCallbackLock.unlock();
                        return;
                    }
                }
            }
            finally {
                this.totalBytesWritten += callbackBytesWritten;
                this.totalBytesRead += callbackBytesRead;
                this.channelSelectedCallbackLock.unlock();
            }
        }
        SmackReactor.SelectionKeyAttachment selectionKeyAttachment = this.selectionKeyAttachment;
        if (selectionKeyAttachment != null) {
            selectionKeyAttachment.resetReactorThreadRacing();
        }
        if (!this.outgoingElementsQueue.isEmpty()) {
            this.setWriteInterestAfterChannelSelectedCallback.incrementAndGet();
            newInterestedOps |= 4;
        }
        this.setInterestOps(this.selectionKey, newInterestedOps);
    };
    private List<HostAddress> failedAddresses;
    private List<InetSocketAddress> inetSocketAddresses;
    private static final Level SSL_ENGINE_DEBUG_LOG_LEVEL;

    public XmppNioTcpConnection(XMPPTCPConnectionConfiguration configuration) {
        super((ConnectionConfiguration)configuration, INITIAL_STATE_DESCRIPTOR_VERTEX);
        XmlPrettyPrinter incomingDebugPrettyPrinter = null;
        if (this.debugger != null) {
            incomingDebugPrettyPrinter = XmlPrettyPrinter.builder().setPrettyWriter(sb -> this.debugger.incomingStreamSink((CharSequence)sb)).build();
            XmlPrettyPrinter outgoingDebugPrettyPrinter = XmlPrettyPrinter.builder().setPrettyWriter(sb -> this.debugger.outgoingStreamSink((CharSequence)sb)).build();
            this.outputDebugSplitter = new XmppXmlSplitter((XmlPrinter)outgoingDebugPrettyPrinter);
        }
        XmppXmlSplitter xmppXmlSplitter = new XmppXmlSplitter(65536, this.xmppElementCallback, (XmlPrinter)incomingDebugPrettyPrinter);
        this.splitter = new Utf8ByteXmppXmlSplitter(xmppXmlSplitter);
    }

    private void handleReadWriteIoException(IOException e) {
        if (e instanceof ClosedChannelException && !this.isConnected()) {
            return;
        }
        this.notifyConnectionError(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callChannelSelectedCallback(boolean setPendingInputFilterData, boolean setPendingOutputFilterData) {
        SocketChannel channel = this.socketChannel;
        SelectionKey key = this.selectionKey;
        if (channel == null || key == null) {
            LOGGER.info("Not calling channel selected callback because the connection was eventually disconnected");
            return;
        }
        this.channelSelectedCallbackLock.lock();
        try {
            if (setPendingInputFilterData) {
                this.pendingInputFilterData = true;
            }
            if (setPendingOutputFilterData) {
                this.pendingOutputFilterData = true;
            }
            this.channelSelectedCallback.onChannelSelected((SelectableChannel)channel, key);
        }
        finally {
            this.channelSelectedCallbackLock.unlock();
        }
    }

    protected void connectInternal() throws SmackException, IOException, XMPPException, InterruptedException {
        this.outgoingElementsQueue.start();
        this.closingStreamReceived.init();
        AbstractXmppStateMachineConnection.WalkStateGraphContext walkStateGraphContext = XmppNioTcpConnection.buildNewWalkTo(AbstractXmppStateMachineConnection.ConnectedButUnauthenticatedStateDescriptor.class).build();
        this.walkStateGraph(walkStateGraphContext);
    }

    private static void debugLogSslEngineResult(String operation, SSLEngineResult result) {
        if (!LOGGER.isLoggable(SSL_ENGINE_DEBUG_LOG_LEVEL)) {
            return;
        }
        LOGGER.log(SSL_ENGINE_DEBUG_LOG_LEVEL, "SSLEngineResult of " + operation + "(): " + result);
    }

    public boolean isSecureConnection() {
        TlsState tlsState = this.tlsState;
        return tlsState != null && tlsState.handshakeStatus == TlsHandshakeStatus.successful;
    }

    private void sendTopLevelStreamElement(TopLevelStreamElement topLevelStreamElement) throws InterruptedException {
        this.outgoingElementsQueue.put((Object)topLevelStreamElement);
        this.afterOutgoingElementsQueueModified();
    }

    private void afterOutgoingElementsQueueModified() {
        SmackReactor.SelectionKeyAttachment selectionKeyAttachment = this.selectionKeyAttachment;
        if (selectionKeyAttachment != null && selectionKeyAttachment.isReactorThreadRacing()) {
            this.reactorThreadAlreadyRacing.incrementAndGet();
            return;
        }
        this.afterOutgoingElementsQueueModifiedSetInterestOps.incrementAndGet();
        this.setInterestOps(this.selectionKey, 5);
    }

    protected void throwNotConnectedExceptionIfAppropriate() throws SmackException.NotConnectedException {
        if (!this.connected && !this.isSmResumptionPossible()) {
            throw new SmackException.NotConnectedException((XMPPConnection)this, "XMPP connection not connected");
        }
    }

    protected void sendStanzaInternal(Stanza stanza) throws SmackException.NotConnectedException, InterruptedException {
        this.sendTopLevelStreamElement((TopLevelStreamElement)stanza);
    }

    public void sendNonza(Nonza nonza) throws SmackException.NotConnectedException, InterruptedException {
        this.sendTopLevelStreamElement((TopLevelStreamElement)nonza);
    }

    protected void shutdown() {
        this.shutdown(false);
    }

    public synchronized void instantShutdown() {
        this.shutdown(true);
    }

    private void shutdown(boolean instant) {
        Class mandatoryIntermediateState = instant ? InstantShutdownStateDescriptor.class : ShutdownStateDescriptor.class;
        AbstractXmppStateMachineConnection.WalkStateGraphContext context = XmppNioTcpConnection.buildNewWalkTo(AbstractXmppStateMachineConnection.DisconnectedStateDescriptor.class).withMandatoryIntermediateState(mandatoryIntermediateState).build();
        try {
            this.walkStateGraph(context);
        }
        catch (IOException | InterruptedException | SmackException | XMPPException.FailedNonzaException | XMPPException.XMPPErrorException | SASLErrorException e) {
            throw new IllegalStateException("A walk to disconnected state should never throw", e);
        }
    }

    private void cleanUpSelectionKeyAndSocketChannel() {
        SocketChannel socketChannel;
        SelectionKey selectionKey = this.selectionKey;
        if (selectionKey != null) {
            selectionKey.cancel();
        }
        if ((socketChannel = this.socketChannel) != null) {
            try {
                socketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.selectionKey = null;
        this.socketChannel = null;
        this.selectionKeyAttachment = null;
        this.remoteAddress = null;
    }

    public boolean isSmResumptionPossible() {
        return false;
    }

    public Stats getStats() {
        return new Stats(this);
    }

    private static List<? extends Buffer> pruneBufferList(Collection<? extends Buffer> buffers) {
        return CollectionUtil.removeUntil(buffers, b -> b.hasRemaining());
    }

    protected SSLSession getSSLSession() {
        if (this.tlsState == null) {
            return null;
        }
        return this.tlsState.engine.getSession();
    }

    public static Set<Class<? extends StateDescriptor>> getBackwardEdgesStateDescriptors() {
        return Collections.unmodifiableSet(BACKWARD_EDGES_STATE_DESCRIPTORS);
    }

    static {
        BACKWARD_EDGES_STATE_DESCRIPTORS.add(LookupHostAddressesStateDescriptor.class);
        BACKWARD_EDGES_STATE_DESCRIPTORS.add(EnableStreamManagementStateDescriptor.class);
        BACKWARD_EDGES_STATE_DESCRIPTORS.add(ResumeStreamStateDescriptor.class);
        BACKWARD_EDGES_STATE_DESCRIPTORS.add(InstantStreamResumptionStateDescriptor.class);
        BACKWARD_EDGES_STATE_DESCRIPTORS.add(Bind2StateDescriptor.class);
        BACKWARD_EDGES_STATE_DESCRIPTORS.add(InstantShutdownStateDescriptor.class);
        BACKWARD_EDGES_STATE_DESCRIPTORS.add(ShutdownStateDescriptor.class);
        try {
            INITIAL_STATE_DESCRIPTOR_VERTEX = StateDescriptorGraph.constructStateDescriptorGraph(BACKWARD_EDGES_STATE_DESCRIPTORS);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        STREAM_OPEN_CLOSE_DEBUG_LOG_LEVEL = Level.FINER;
        SSL_ENGINE_DEBUG_LOG_LEVEL = Level.FINEST;
    }

    public static final class Stats {
        public final long totalBytesWritten;
        public final long totalBytesWrittenBeforeFilter;
        public final double writeRatio;
        public final long totalBytesRead;
        public final long totalBytesReadAfterFilter;
        public final double readRatio;
        public final long handledChannelSelectedCallbacks;
        public final long setWriteInterestAfterChannelSelectedCallback;
        public final long reactorThreadAlreadyRacing;
        public final long afterOutgoingElementsQueueModifiedSetInterestOps;
        public final long rejectedChannelSelectedCallbacks;
        public final long totalCallbackRequests;
        public final long callbackPreemtBecauseBytesWritten;
        public final long callbackPreemtBecauseBytesRead;
        public final int sslEngineDelegatedTasks;
        public final int maxPendingSslEngineDelegatedTasks;
        public final List<Object> filterStats;
        private transient String toStringCache;

        private Stats(XmppNioTcpConnection connection) {
            this.totalBytesWritten = connection.totalBytesWritten;
            this.totalBytesWrittenBeforeFilter = connection.totalBytesWrittenBeforeFilter;
            this.writeRatio = (double)this.totalBytesWritten / (double)this.totalBytesWrittenBeforeFilter;
            this.totalBytesReadAfterFilter = connection.totalBytesReadAfterFilter;
            this.totalBytesRead = connection.totalBytesRead;
            this.readRatio = (double)this.totalBytesRead / (double)this.totalBytesReadAfterFilter;
            this.handledChannelSelectedCallbacks = connection.handledChannelSelectedCallbacks;
            this.setWriteInterestAfterChannelSelectedCallback = connection.setWriteInterestAfterChannelSelectedCallback.get();
            this.reactorThreadAlreadyRacing = connection.reactorThreadAlreadyRacing.get();
            this.afterOutgoingElementsQueueModifiedSetInterestOps = connection.afterOutgoingElementsQueueModifiedSetInterestOps.get();
            this.rejectedChannelSelectedCallbacks = connection.rejectedChannelSelectedCallbacks.get();
            this.totalCallbackRequests = this.handledChannelSelectedCallbacks + this.rejectedChannelSelectedCallbacks;
            this.callbackPreemtBecauseBytesRead = connection.callbackPreemtBecauseBytesRead;
            this.callbackPreemtBecauseBytesWritten = connection.callbackPreemtBecauseBytesWritten;
            this.sslEngineDelegatedTasks = connection.sslEngineDelegatedTasks;
            this.maxPendingSslEngineDelegatedTasks = connection.maxPendingSslEngineDelegatedTasks;
            this.filterStats = connection.getFilterStats();
        }

        public String toString() {
            if (this.toStringCache != null) {
                return this.toStringCache;
            }
            StringBuilder sb = new StringBuilder("Total bytes\nrecv: " + this.totalBytesRead + '\n' + "send: " + this.totalBytesWritten + '\n' + "recv-aft-filter: " + this.totalBytesReadAfterFilter + '\n' + "send-bef-filter: " + this.totalBytesWrittenBeforeFilter + '\n' + "read-ratio: " + this.readRatio + '\n' + "write-ratio: " + this.writeRatio + '\n' + "Events\ntotal-callback-requests: " + this.totalCallbackRequests + '\n' + "handled-channel-selected-callbacks: " + this.handledChannelSelectedCallbacks + '\n' + "rejected-channel-selected-callbacks: " + this.rejectedChannelSelectedCallbacks + '\n' + "set-write-interest-after-callback: " + this.setWriteInterestAfterChannelSelectedCallback + '\n' + "reactor-thread-already-racing: " + this.reactorThreadAlreadyRacing + '\n' + "after-queue-modified-set-interest-ops: " + this.afterOutgoingElementsQueueModifiedSetInterestOps + '\n' + "callback-preemt-because-bytes-read: " + this.callbackPreemtBecauseBytesRead + '\n' + "callback-preemt-because-bytes-written: " + this.callbackPreemtBecauseBytesWritten + '\n' + "ssl-engine-delegated-tasks: " + this.sslEngineDelegatedTasks + '\n' + "max-pending-ssl-engine-delegated-tasks: " + this.maxPendingSslEngineDelegatedTasks + '\n');
            if (!this.filterStats.isEmpty()) {
                sb.append("Filter Stats\n");
                for (Object filterStat : this.filterStats) {
                    sb.append(filterStat);
                }
            }
            this.toStringCache = sb.toString();
            return this.toStringCache;
        }
    }

    private final class CloseConnectionState
    extends AbstractXmppStateMachineConnection.State {
        private CloseConnectionState(StateDescriptor stateDescriptor) {
            super((AbstractXmppStateMachineConnection)XmppNioTcpConnection.this, stateDescriptor);
        }

        protected AbstractXmppStateMachineConnection.TransitionIntoResult transitionInto(AbstractXmppStateMachineConnection.WalkStateGraphContext walkStateGraphContext) {
            XmppNioTcpConnection.this.cleanUpSelectionKeyAndSocketChannel();
            return AbstractXmppStateMachineConnection.TransitionSuccessResult.EMPTY_INSTANCE;
        }
    }

    private static final class CloseConnectionStateDescriptor
    extends StateDescriptor {
        private CloseConnectionStateDescriptor() {
            super(CloseConnectionState.class);
            this.addSuccessor(AbstractXmppStateMachineConnection.DisconnectedStateDescriptor.class);
        }
    }

    private final class ShutdownState
    extends AbstractXmppStateMachineConnection.State {
        private ShutdownState(StateDescriptor stateDescriptor) {
            super((AbstractXmppStateMachineConnection)XmppNioTcpConnection.this, stateDescriptor);
        }

        protected AbstractXmppStateMachineConnection.TransitionImpossibleReason isTransitionToPossible(AbstractXmppStateMachineConnection.WalkStateGraphContext walkStateGraphContext) {
            this.ensureNotOnOurWayToAuthenticatedAndResourceBound(walkStateGraphContext);
            return null;
        }

        protected AbstractXmppStateMachineConnection.TransitionIntoResult transitionInto(AbstractXmppStateMachineConnection.WalkStateGraphContext walkStateGraphContext) {
            boolean successfullyReceivedStreamClose;
            XmppNioTcpConnection.this.closingStreamReceived.init();
            boolean streamCloseIssued = XmppNioTcpConnection.this.outgoingElementsQueue.offerAndShutdown((Object)StreamClose.INSTANCE);
            XmppNioTcpConnection.this.afterOutgoingElementsQueueModified();
            if (streamCloseIssued && (successfullyReceivedStreamClose = XmppNioTcpConnection.this.waitForClosingStreamTagFromServer())) {
                XmppInputOutputFilter filter;
                ListIterator it = XmppNioTcpConnection.this.getXmppInputOutputFilterBeginIterator();
                while (it.hasNext()) {
                    filter = (XmppInputOutputFilter)it.next();
                    filter.closeInputOutput();
                }
                XmppNioTcpConnection.this.pendingInputFilterData = (XmppNioTcpConnection.this.pendingOutputFilterData = true);
                XmppNioTcpConnection.this.afterOutgoingElementsQueueModified();
                it = XmppNioTcpConnection.this.getXmppInputOutputFilterBeginIterator();
                while (it.hasNext()) {
                    filter = (XmppInputOutputFilter)it.next();
                    try {
                        filter.waitUntilInputOutputClosed();
                    }
                    catch (IOException | InterruptedException | CertificateException | SmackException e) {
                        LOGGER.log(Level.WARNING, "waitUntilInputOutputClosed() threw", e);
                    }
                }
            }
            return AbstractXmppStateMachineConnection.TransitionSuccessResult.EMPTY_INSTANCE;
        }
    }

    private static final class ShutdownStateDescriptor
    extends StateDescriptor {
        private ShutdownStateDescriptor() {
            super(ShutdownState.class);
            this.addSuccessor(CloseConnectionStateDescriptor.class);
            this.addPredeccessor(AbstractXmppStateMachineConnection.AuthenticatedAndResourceBoundStateDescriptor.class);
            this.addPredeccessor(AbstractXmppStateMachineConnection.ConnectedButUnauthenticatedStateDescriptor.class);
        }
    }

    private final class InstantShutdownState
    extends AbstractXmppStateMachineConnection.State {
        private InstantShutdownState(StateDescriptor stateDescriptor) {
            super((AbstractXmppStateMachineConnection)XmppNioTcpConnection.this, stateDescriptor);
        }

        protected AbstractXmppStateMachineConnection.TransitionImpossibleReason isTransitionToPossible(AbstractXmppStateMachineConnection.WalkStateGraphContext walkStateGraphContext) {
            this.ensureNotOnOurWayToAuthenticatedAndResourceBound(walkStateGraphContext);
            return null;
        }

        protected AbstractXmppStateMachineConnection.TransitionIntoResult transitionInto(AbstractXmppStateMachineConnection.WalkStateGraphContext walkStateGraphContext) {
            XmppNioTcpConnection.this.outgoingElementsQueue.shutdown();
            XmppNioTcpConnection.this.afterOutgoingElementsQueueModified();
            return AbstractXmppStateMachineConnection.TransitionSuccessResult.EMPTY_INSTANCE;
        }
    }

    static final class InstantShutdownStateDescriptor
    extends StateDescriptor {
        private InstantShutdownStateDescriptor() {
            super(InstantShutdownState.class);
            this.addSuccessor(CloseConnectionStateDescriptor.class);
            this.addPredeccessor(AbstractXmppStateMachineConnection.AuthenticatedAndResourceBoundStateDescriptor.class);
            this.addPredeccessor(AbstractXmppStateMachineConnection.ConnectedButUnauthenticatedStateDescriptor.class);
        }
    }

    private final class Bind2State
    extends AbstractXmppStateMachineConnection.State {
        private Bind2State(StateDescriptor stateDescriptor) {
            super((AbstractXmppStateMachineConnection)XmppNioTcpConnection.this, stateDescriptor);
        }

        protected AbstractXmppStateMachineConnection.TransitionImpossibleReason isTransitionToPossible(AbstractXmppStateMachineConnection.WalkStateGraphContext walkStateGraphContext) {
            if (!XmppNioTcpConnection.this.useBind2) {
                return new AbstractXmppStateMachineConnection.TransitionImpossibleReason("Bind2 not enabled nor implemented");
            }
            throw new IllegalStateException("Bind2 not implemented");
        }

        protected AbstractXmppStateMachineConnection.TransitionIntoResult transitionInto(AbstractXmppStateMachineConnection.WalkStateGraphContext walkStateGraphContext) {
            throw new IllegalStateException("Bind2 not implemented");
        }
    }

    private static final class Bind2StateDescriptor
    extends StateDescriptor {
        private Bind2StateDescriptor() {
            super(Bind2State.class, 386, new StateDescriptor.Property[]{StateDescriptor.Property.notImplemented});
            this.addPredeccessor(AbstractXmppStateMachineConnection.ConnectedButUnauthenticatedStateDescriptor.class);
            this.addSuccessor(AbstractXmppStateMachineConnection.AuthenticatedAndResourceBoundStateDescriptor.class);
            this.declarePrecedenceOver(AbstractXmppStateMachineConnection.SaslAuthenticationStateDescriptor.class);
        }
    }

    private final class InstantStreamResumptionState
    extends AbstractXmppStateMachineConnection.State {
        private InstantStreamResumptionState(StateDescriptor stateDescriptor) {
            super((AbstractXmppStateMachineConnection)XmppNioTcpConnection.this, stateDescriptor);
        }

        protected AbstractXmppStateMachineConnection.TransitionImpossibleReason isTransitionToPossible(AbstractXmppStateMachineConnection.WalkStateGraphContext walkStateGraphContext) {
            if (!XmppNioTcpConnection.this.useIsr) {
                return new AbstractXmppStateMachineConnection.TransitionImpossibleReason("Instant stream resumption not enabled nor implemented");
            }
            throw new IllegalStateException("Instant stream resumption not implemented");
        }

        protected AbstractXmppStateMachineConnection.TransitionIntoResult transitionInto(AbstractXmppStateMachineConnection.WalkStateGraphContext walkStateGraphContext) {
            throw new IllegalStateException("Instant stream resumption not implemented");
        }
    }

    private static final class InstantStreamResumptionStateDescriptor
    extends StateDescriptor {
        private InstantStreamResumptionStateDescriptor() {
            super(InstantStreamResumptionState.class, 397, new StateDescriptor.Property[]{StateDescriptor.Property.notImplemented});
            this.addSuccessor(AbstractXmppStateMachineConnection.AuthenticatedAndResourceBoundStateDescriptor.class);
            this.addPredeccessor(AbstractXmppStateMachineConnection.ConnectedButUnauthenticatedStateDescriptor.class);
            this.declarePrecedenceOver(AbstractXmppStateMachineConnection.SaslAuthenticationStateDescriptor.class);
        }
    }

    private final class ResumeStreamState
    extends AbstractXmppStateMachineConnection.State {
        private ResumeStreamState(StateDescriptor stateDescriptor) {
            super((AbstractXmppStateMachineConnection)XmppNioTcpConnection.this, stateDescriptor);
        }

        protected AbstractXmppStateMachineConnection.TransitionImpossibleReason isTransitionToPossible(AbstractXmppStateMachineConnection.WalkStateGraphContext walkStateGraphContext) {
            if (!XmppNioTcpConnection.this.useSmResumption) {
                return new AbstractXmppStateMachineConnection.TransitionImpossibleReason("Stream resumption not enabled");
            }
            throw new IllegalStateException("Stream resumptionimplemented");
        }

        protected AbstractXmppStateMachineConnection.TransitionIntoResult transitionInto(AbstractXmppStateMachineConnection.WalkStateGraphContext walkStateGraphContext) throws XMPPException.XMPPErrorException, SASLErrorException, IOException, SmackException, InterruptedException, XMPPException.FailedNonzaException {
            throw new IllegalStateException("Stream resumptionimplemented");
        }
    }

    private static final class ResumeStreamStateDescriptor
    extends StateDescriptor {
        private ResumeStreamStateDescriptor() {
            super(ResumeStreamState.class, 198, new StateDescriptor.Property[]{StateDescriptor.Property.notImplemented});
            this.addPredeccessor(AbstractXmppStateMachineConnection.AuthenticatedButUnboundStateDescriptor.class);
            this.addSuccessor(AbstractXmppStateMachineConnection.AuthenticatedAndResourceBoundStateDescriptor.class);
            this.declarePrecedenceOver(AbstractXmppStateMachineConnection.ResourceBindingStateDescriptor.class);
            this.declareInferiortyTo(AbstractXmppStateMachineConnection.CompressionStateDescriptor.class);
        }
    }

    private final class EnableStreamManagementState
    extends AbstractXmppStateMachineConnection.State {
        private EnableStreamManagementState(StateDescriptor stateDescriptor) {
            super((AbstractXmppStateMachineConnection)XmppNioTcpConnection.this, stateDescriptor);
        }

        protected AbstractXmppStateMachineConnection.TransitionImpossibleReason isTransitionToPossible(AbstractXmppStateMachineConnection.WalkStateGraphContext walkStateGraphContext) {
            if (!XmppNioTcpConnection.this.useSm) {
                return new AbstractXmppStateMachineConnection.TransitionImpossibleReason("Stream management not enabled");
            }
            throw new IllegalStateException("SM not implemented");
        }

        protected AbstractXmppStateMachineConnection.TransitionIntoResult transitionInto(AbstractXmppStateMachineConnection.WalkStateGraphContext walkStateGraphContext) {
            throw new IllegalStateException("SM not implemented");
        }
    }

    protected static final class EnableStreamManagementStateDescriptor
    extends StateDescriptor {
        private EnableStreamManagementStateDescriptor() {
            super(EnableStreamManagementState.class, 198, new StateDescriptor.Property[]{StateDescriptor.Property.notImplemented});
            this.addPredeccessor(AbstractXmppStateMachineConnection.ResourceBindingStateDescriptor.class);
            this.addSuccessor(AbstractXmppStateMachineConnection.AuthenticatedAndResourceBoundStateDescriptor.class);
            this.declarePrecedenceOver(AbstractXmppStateMachineConnection.AuthenticatedAndResourceBoundStateDescriptor.class);
        }
    }

    public static final class TlsStateStats {
        public final long wrapInBytes;
        public final long wrapOutBytes;
        public final double wrapRatio;
        public final long unwrapInBytes;
        public final long unwrapOutBytes;
        public final double unwrapRatio;
        private transient String toStringCache;

        private TlsStateStats(TlsState tlsState) {
            this.wrapOutBytes = tlsState.wrapOutBytes;
            this.wrapInBytes = tlsState.wrapInBytes;
            this.wrapRatio = (double)this.wrapOutBytes / (double)this.wrapInBytes;
            this.unwrapOutBytes = tlsState.unwrapOutBytes;
            this.unwrapInBytes = tlsState.unwrapInBytes;
            this.unwrapRatio = (double)this.unwrapInBytes / (double)this.unwrapOutBytes;
        }

        public String toString() {
            if (this.toStringCache != null) {
                return this.toStringCache;
            }
            this.toStringCache = "wrap-in-bytes: " + this.wrapInBytes + '\n' + "wrap-out-bytes: " + this.wrapOutBytes + '\n' + "wrap-ratio: " + this.wrapRatio + '\n' + "unwrap-in-bytes: " + this.unwrapInBytes + '\n' + "unwrap-out-bytes: " + this.unwrapOutBytes + '\n' + "unwrap-ratio: " + this.unwrapRatio;
            return this.toStringCache;
        }
    }

    private final class TlsState
    implements XmppInputOutputFilter {
        private static final int MAX_PENDING_OUTPUT_BYTES = 8096;
        private final AbstractXMPPConnection.SmackTlsContext smackTlsContext;
        private final SSLEngine engine;
        private TlsHandshakeStatus handshakeStatus = TlsHandshakeStatus.initial;
        private SSLException handshakeException;
        private ByteBuffer myNetData;
        private ByteBuffer peerAppData;
        private final List<ByteBuffer> pendingOutputData = new ArrayList<ByteBuffer>();
        private int pendingOutputBytes;
        private ByteBuffer pendingInputData;
        private final AtomicInteger pendingDelegatedTasks = new AtomicInteger();
        private long wrapInBytes;
        private long wrapOutBytes;
        private long unwrapInBytes;
        private long unwrapOutBytes;

        private TlsState(AbstractXMPPConnection.SmackTlsContext smackTlsContext) throws IOException {
            this.smackTlsContext = smackTlsContext;
            this.engine = smackTlsContext.sslContext.createSSLEngine(XmppNioTcpConnection.this.config.getXMPPServiceDomain().toString(), XmppNioTcpConnection.this.remoteAddress.getPort());
            this.engine.setUseClientMode(true);
            SSLSession session = this.engine.getSession();
            int applicationBufferSize = session.getApplicationBufferSize();
            int packetBufferSize = session.getPacketBufferSize();
            this.myNetData = ByteBuffer.allocateDirect(packetBufferSize);
            this.peerAppData = ByteBuffer.allocate(applicationBufferSize);
        }

        public XmppInputOutputFilter.OutputResult output(ByteBuffer outputData, boolean isFinalDataOfElement, boolean destinationAddressChanged, boolean moreDataAvailable) throws SSLException {
            if (outputData != null) {
                this.pendingOutputData.add(outputData);
                this.pendingOutputBytes += outputData.remaining();
                if (moreDataAvailable && this.pendingOutputBytes < 8096) {
                    return XmppInputOutputFilter.OutputResult.NO_OUTPUT;
                }
            }
            ByteBuffer[] outputDataArray = this.pendingOutputData.toArray(new ByteBuffer[this.pendingOutputData.size()]);
            this.myNetData.clear();
            block12: while (true) {
                SSLEngineResult result;
                try {
                    result = this.engine.wrap(outputDataArray, this.myNetData);
                }
                catch (SSLException e) {
                    this.handleSslException(e);
                    throw e;
                }
                XmppNioTcpConnection.debugLogSslEngineResult("wrap", result);
                SSLEngineResult.Status engineResultStatus = result.getStatus();
                this.pendingOutputBytes -= result.bytesConsumed();
                if (engineResultStatus == SSLEngineResult.Status.OK) {
                    this.wrapInBytes += (long)result.bytesConsumed();
                    this.wrapOutBytes += (long)result.bytesProduced();
                    SSLEngineResult.HandshakeStatus handshakeStatus = this.handleHandshakeStatus(result);
                    switch (handshakeStatus) {
                        case NEED_UNWRAP: {
                            break;
                        }
                        case NEED_WRAP: 
                        case NEED_TASK: {
                            return new XmppInputOutputFilter.OutputResult(true, this.myNetData);
                        }
                    }
                }
                switch (engineResultStatus) {
                    case OK: {
                        XmppNioTcpConnection.pruneBufferList(this.pendingOutputData);
                        return new XmppInputOutputFilter.OutputResult(!this.pendingOutputData.isEmpty(), this.myNetData);
                    }
                    case CLOSED: {
                        this.pendingOutputData.clear();
                        return XmppInputOutputFilter.OutputResult.NO_OUTPUT;
                    }
                    case BUFFER_OVERFLOW: {
                        LOGGER.warning("SSLEngine status BUFFER_OVERFLOW, this is hopefully uncommon");
                        int outputDataRemaining = outputData != null ? outputData.remaining() : 0;
                        int newCapacity = (int)(1.3 * (double)outputDataRemaining);
                        if (newCapacity <= this.myNetData.capacity()) {
                            newCapacity = 2 * this.myNetData.capacity();
                        }
                        ByteBuffer newMyNetData = ByteBuffer.allocateDirect(newCapacity);
                        this.myNetData.flip();
                        newMyNetData.put(this.myNetData);
                        this.myNetData = newMyNetData;
                        continue block12;
                    }
                    case BUFFER_UNDERFLOW: {
                        throw new IllegalStateException("Buffer underflow as result of SSLEngine.wrap() should never happen");
                    }
                }
            }
        }

        public ByteBuffer input(ByteBuffer inputData) throws SSLException {
            ByteBuffer accumulatedData;
            if (this.pendingInputData == null) {
                accumulatedData = inputData;
            } else {
                int accumulatedDataBytes = this.pendingInputData.remaining() + inputData.remaining();
                accumulatedData = ByteBuffer.allocate(accumulatedDataBytes);
                accumulatedData.put(this.pendingInputData).put(inputData).flip();
                this.pendingInputData = null;
            }
            this.peerAppData.clear();
            block13: while (true) {
                SSLEngineResult result;
                try {
                    result = this.engine.unwrap(accumulatedData, this.peerAppData);
                }
                catch (SSLException e) {
                    this.handleSslException(e);
                    throw e;
                }
                XmppNioTcpConnection.debugLogSslEngineResult("unwrap", result);
                SSLEngineResult.Status engineResultStatus = result.getStatus();
                if (engineResultStatus == SSLEngineResult.Status.OK) {
                    this.unwrapInBytes += (long)result.bytesConsumed();
                    this.unwrapOutBytes += (long)result.bytesProduced();
                    SSLEngineResult.HandshakeStatus handshakeStatus = this.handleHandshakeStatus(result);
                    switch (handshakeStatus) {
                        case NEED_TASK: {
                            this.addAsPendingInputData(accumulatedData);
                            break;
                        }
                        case NEED_UNWRAP: {
                            continue block13;
                        }
                        case NEED_WRAP: {
                            XmppNioTcpConnection.asyncGo((Runnable)() -> XmppNioTcpConnection.this.callChannelSelectedCallback(false, true));
                            break;
                        }
                    }
                }
                switch (engineResultStatus) {
                    case OK: {
                        if (accumulatedData.hasRemaining()) continue block13;
                        return this.peerAppData;
                    }
                    case CLOSED: {
                        return null;
                    }
                    case BUFFER_UNDERFLOW: {
                        this.addAsPendingInputData(accumulatedData);
                        return null;
                    }
                    case BUFFER_OVERFLOW: {
                        int applicationBufferSize = this.engine.getSession().getApplicationBufferSize();
                        assert (this.peerAppData.remaining() < applicationBufferSize);
                        this.peerAppData = ByteBuffer.allocate(applicationBufferSize);
                        continue block13;
                    }
                }
            }
        }

        private void addAsPendingInputData(ByteBuffer byteBuffer) {
            this.pendingInputData = ByteBuffer.allocate(byteBuffer.remaining());
            this.pendingInputData.put(byteBuffer).flip();
        }

        private SSLEngineResult.HandshakeStatus handleHandshakeStatus(SSLEngineResult sslEngineResult) {
            SSLEngineResult.HandshakeStatus handshakeStatus = sslEngineResult.getHandshakeStatus();
            switch (handshakeStatus) {
                case NEED_TASK: {
                    Runnable delegatedTask;
                    while ((delegatedTask = this.engine.getDelegatedTask()) != null) {
                        XmppNioTcpConnection.this.sslEngineDelegatedTasks++;
                        int currentPendingDelegatedTasks = this.pendingDelegatedTasks.incrementAndGet();
                        if (currentPendingDelegatedTasks > XmppNioTcpConnection.this.maxPendingSslEngineDelegatedTasks) {
                            XmppNioTcpConnection.this.maxPendingSslEngineDelegatedTasks = currentPendingDelegatedTasks;
                        }
                        Runnable wrappedDelegatedTask = () -> {
                            delegatedTask.run();
                            int wrappedCurrentPendingDelegatedTasks = this.pendingDelegatedTasks.decrementAndGet();
                            if (wrappedCurrentPendingDelegatedTasks == 0) {
                                XmppNioTcpConnection.this.callChannelSelectedCallback(true, true);
                            }
                        };
                        XmppNioTcpConnection.asyncGo((Runnable)wrappedDelegatedTask);
                    }
                    break;
                }
                case FINISHED: {
                    this.onHandshakeFinished();
                    break;
                }
            }
            SSLEngineResult.HandshakeStatus afterHandshakeStatus = this.engine.getHandshakeStatus();
            return afterHandshakeStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleSslException(SSLException e) {
            this.handshakeException = e;
            this.handshakeStatus = TlsHandshakeStatus.failed;
            TlsState tlsState = this;
            synchronized (tlsState) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onHandshakeFinished() {
            this.handshakeStatus = TlsHandshakeStatus.successful;
            TlsState tlsState = this;
            synchronized (tlsState) {
                this.notifyAll();
            }
        }

        private boolean isHandshakeFinished() {
            return this.handshakeStatus == TlsHandshakeStatus.successful || this.handshakeStatus == TlsHandshakeStatus.failed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForHandshakeFinished() throws InterruptedException, CertificateException, SSLException, SmackException.ConnectionUnexpectedTerminatedException, SmackException.NoResponseException {
            long deadline = System.currentTimeMillis() + XmppNioTcpConnection.this.getReplyTimeout();
            TlsState tlsState = this;
            synchronized (tlsState) {
                long now;
                while (!this.isHandshakeFinished() && XmppNioTcpConnection.this.currentConnectionException == null && (now = System.currentTimeMillis()) < deadline) {
                    this.wait(deadline - now);
                }
            }
            if (XmppNioTcpConnection.this.currentConnectionException != null) {
                throw new SmackException.ConnectionUnexpectedTerminatedException((Throwable)XmppNioTcpConnection.this.currentConnectionException);
            }
            if (!this.isHandshakeFinished()) {
                throw SmackException.NoResponseException.newWith((XMPPConnection)XmppNioTcpConnection.this, (String)"TLS Handshake finsih");
            }
            if (this.handshakeStatus == TlsHandshakeStatus.failed) {
                throw this.handshakeException;
            }
            assert (this.handshakeStatus == TlsHandshakeStatus.successful);
            if (this.smackTlsContext.daneVerifier != null) {
                this.smackTlsContext.daneVerifier.finish(this.engine.getSession());
            }
        }

        public Object getStats() {
            return new TlsStateStats(this);
        }

        public void closeInputOutput() {
            this.engine.closeOutbound();
            try {
                this.engine.closeInbound();
            }
            catch (SSLException e) {
                LOGGER.log(Level.FINEST, "SSLException when closing inbound TLS session. This can likely be ignored if a possible truncation attack is suggested. You may want to ask your XMPP server vendor to implement a clean TLS session shutdown sending close_notify after </stream>", e);
            }
        }

        public void waitUntilInputOutputClosed() throws IOException, CertificateException, InterruptedException, SmackException.ConnectionUnexpectedTerminatedException, SmackException.NoResponseException {
            this.waitForHandshakeFinished();
        }
    }

    private static enum TlsHandshakeStatus {
        initial,
        initiated,
        successful,
        failed;

    }

    public static final class TlsEstablishedResult
    extends AbstractXmppStateMachineConnection.TransitionSuccessResult {
        private TlsEstablishedResult(SSLEngine sslEngine) {
            super("TLS established: " + sslEngine.getSession());
        }
    }

    private final class EstablishTlsState
    extends AbstractXmppStateMachineConnection.State {
        private EstablishTlsState(StateDescriptor stateDescriptor) {
            super((AbstractXmppStateMachineConnection)XmppNioTcpConnection.this, stateDescriptor);
        }

        protected AbstractXmppStateMachineConnection.TransitionImpossibleReason isTransitionToPossible(AbstractXmppStateMachineConnection.WalkStateGraphContext walkStateGraphContext) throws SmackException.SecurityRequiredByClientException, SmackException.SecurityRequiredByServerException {
            StartTls startTlsFeature = (StartTls)XmppNioTcpConnection.this.getFeature("starttls", "urn:ietf:params:xml:ns:xmpp-tls");
            ConnectionConfiguration.SecurityMode securityMode = XmppNioTcpConnection.this.config.getSecurityMode();
            switch (securityMode) {
                case required: 
                case ifpossible: {
                    if (startTlsFeature == null) {
                        if (securityMode == ConnectionConfiguration.SecurityMode.ifpossible) {
                            return new AbstractXmppStateMachineConnection.TransitionImpossibleReason("Server does not announce support for TLS and we do not required it");
                        }
                        throw new SmackException.SecurityRequiredByClientException();
                    }
                    return null;
                }
                case disabled: {
                    if (startTlsFeature != null && startTlsFeature.required()) {
                        throw new SmackException.SecurityRequiredByServerException();
                    }
                    return new AbstractXmppStateMachineConnection.TransitionImpossibleReason("TLS disabled in client settings and server does not require it");
                }
            }
            throw new AssertionError((Object)("Unknown security mode: " + securityMode));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected AbstractXmppStateMachineConnection.TransitionIntoResult transitionInto(AbstractXmppStateMachineConnection.WalkStateGraphContext walkStateGraphContext) throws SmackException.SmackWrappedException, XMPPException.FailedNonzaException, IOException, InterruptedException, SmackException.ConnectionUnexpectedTerminatedException, SmackException.NoResponseException, SmackException.NotConnectedException {
            AbstractXMPPConnection.SmackTlsContext smackTlsContext;
            XmppNioTcpConnection.this.sendAndWaitForResponse((Nonza)StartTls.INSTANCE, TlsProceed.class, TlsFailure.class);
            try {
                smackTlsContext = XmppNioTcpConnection.this.getSmackTlsContext();
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException | CertificateException e) {
                throw new SmackException.SmackWrappedException((Exception)e);
            }
            XmppNioTcpConnection.this.tlsState = new TlsState(smackTlsContext);
            XmppNioTcpConnection.this.addXmppInputOutputFilter(XmppNioTcpConnection.this.tlsState);
            XmppNioTcpConnection.this.channelSelectedCallbackLock.lock();
            try {
                XmppNioTcpConnection.this.pendingOutputFilterData = true;
                XmppNioTcpConnection.this.tlsState.engine.beginHandshake();
                XmppNioTcpConnection.this.tlsState.handshakeStatus = TlsHandshakeStatus.initiated;
            }
            finally {
                XmppNioTcpConnection.this.channelSelectedCallbackLock.unlock();
            }
            XmppNioTcpConnection.this.setInterestOps(XmppNioTcpConnection.this.selectionKey, 5);
            try {
                XmppNioTcpConnection.this.tlsState.waitForHandshakeFinished();
            }
            catch (CertificateException e) {
                throw new SmackException.SmackWrappedException((Exception)e);
            }
            XmppNioTcpConnection.this.newStreamOpenWaitForFeaturesSequence("stream features after TLS established");
            return new TlsEstablishedResult(XmppNioTcpConnection.this.tlsState.engine);
        }

        protected void resetState() {
            XmppNioTcpConnection.this.tlsState = null;
        }
    }

    private static final class EstablishTlsStateDescriptor
    extends StateDescriptor {
        private EstablishTlsStateDescriptor() {
            super(EstablishTlsState.class, "RFC 6120 \u00a7 5");
            this.addSuccessor(AbstractXmppStateMachineConnection.ConnectedButUnauthenticatedStateDescriptor.class);
            this.declarePrecedenceOver(AbstractXmppStateMachineConnection.ConnectedButUnauthenticatedStateDescriptor.class);
        }
    }

    public static final class TcpSocketConnectedResult
    extends AbstractXmppStateMachineConnection.TransitionSuccessResult {
        private final InetSocketAddress remoteAddress;

        private TcpSocketConnectedResult(InetSocketAddress remoteAddress) {
            super("TCP connection established to " + remoteAddress);
            this.remoteAddress = remoteAddress;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.remoteAddress;
        }
    }

    private final class ConnectingToHostState
    extends AbstractXmppStateMachineConnection.State {
        private ConnectingToHostState(StateDescriptor stateDescriptor) {
            super((AbstractXmppStateMachineConnection)XmppNioTcpConnection.this, stateDescriptor);
        }

        protected AbstractXmppStateMachineConnection.TransitionIntoResult transitionInto(AbstractXmppStateMachineConnection.WalkStateGraphContext walkStateGraphContext) throws IOException, InterruptedException, SmackException.NoResponseException, SmackException.ConnectionException, SmackException.ConnectionUnexpectedTerminatedException, SmackException.NotConnectedException {
            ConnectionAttemptState connectionAttemptState = new ConnectionAttemptState(XmppNioTcpConnection.this.inetSocketAddresses, XmppNioTcpConnection.this.failedAddresses, this);
            connectionAttemptState.establishTcpConnection();
            try {
                connectionAttemptState.tcpConnectionEstablishedSyncPoint.checkIfSuccessOrWaitOrThrow();
            }
            catch (SmackException.SmackWrappedException e) {
                throw new AssertionError((Object)e);
            }
            XmppNioTcpConnection.this.socketChannel = connectionAttemptState.socketChannel;
            XmppNioTcpConnection.this.remoteAddress = (InetSocketAddress)XmppNioTcpConnection.this.socketChannel.socket().getRemoteSocketAddress();
            XmppNioTcpConnection.this.selectionKey = XmppNioTcpConnection.this.registerWithSelector(XmppNioTcpConnection.this.socketChannel, 1, XmppNioTcpConnection.this.channelSelectedCallback);
            XmppNioTcpConnection.this.selectionKeyAttachment = (SmackReactor.SelectionKeyAttachment)XmppNioTcpConnection.this.selectionKey.attachment();
            XmppNioTcpConnection.this.newStreamOpenWaitForFeaturesSequence("stream features after initial connection");
            return new TcpSocketConnectedResult(XmppNioTcpConnection.this.remoteAddress);
        }

        protected void resetState() {
            XmppNioTcpConnection.this.cleanUpSelectionKeyAndSocketChannel();
        }
    }

    private static final class ConnectingToHostStateDescriptor
    extends StateDescriptor {
        private ConnectingToHostStateDescriptor() {
            super(ConnectingToHostState.class);
            this.addSuccessor(EstablishTlsStateDescriptor.class);
            this.addSuccessor(AbstractXmppStateMachineConnection.ConnectedButUnauthenticatedStateDescriptor.class);
        }
    }

    private final class DirectTlsConnectionToHostState
    extends AbstractXmppStateMachineConnection.State {
        private DirectTlsConnectionToHostState(StateDescriptor stateDescriptor) {
            super((AbstractXmppStateMachineConnection)XmppNioTcpConnection.this, stateDescriptor);
        }

        protected AbstractXmppStateMachineConnection.TransitionImpossibleReason isTransitionToPossible(AbstractXmppStateMachineConnection.WalkStateGraphContext walkStateGraphContext) {
            if (!XmppNioTcpConnection.this.useDirectTls) {
                return new AbstractXmppStateMachineConnection.TransitionImpossibleReason("Direct TLS not enabled");
            }
            throw new IllegalStateException("Direct TLS not implemented");
        }

        protected AbstractXmppStateMachineConnection.TransitionIntoResult transitionInto(AbstractXmppStateMachineConnection.WalkStateGraphContext walkStateGraphContext) {
            throw new IllegalStateException("Direct TLS not implemented");
        }
    }

    private static final class DirectTlsConnectionToHostStateDescriptor
    extends StateDescriptor {
        private DirectTlsConnectionToHostStateDescriptor() {
            super(DirectTlsConnectionToHostState.class, 368, new StateDescriptor.Property[]{StateDescriptor.Property.notImplemented});
            this.addPredeccessor(LookupHostAddressesStateDescriptor.class);
            this.addSuccessor(AbstractXmppStateMachineConnection.ConnectedButUnauthenticatedStateDescriptor.class);
            this.declarePrecedenceOver(ConnectingToHostStateDescriptor.class);
        }
    }

    public static final class HostLookupResult
    extends AbstractXmppStateMachineConnection.TransitionSuccessResult {
        private final List<InetSocketAddress> remoteAddresses;

        private HostLookupResult(List<InetSocketAddress> remoteAddresses) {
            super("Host lookup yielded the following addressess: " + remoteAddresses);
            ArrayList<InetSocketAddress> remoteAddressesLocal = new ArrayList<InetSocketAddress>(remoteAddresses.size());
            remoteAddressesLocal.addAll(remoteAddresses);
            this.remoteAddresses = Collections.unmodifiableList(remoteAddressesLocal);
        }

        public List<InetSocketAddress> getRemoteAddresses() {
            return this.remoteAddresses;
        }
    }

    private final class LookupHostAddressesState
    extends AbstractXmppStateMachineConnection.State {
        private LookupHostAddressesState(StateDescriptor stateDescriptor) {
            super((AbstractXmppStateMachineConnection)XmppNioTcpConnection.this, stateDescriptor);
        }

        protected AbstractXmppStateMachineConnection.TransitionIntoResult transitionInto(AbstractXmppStateMachineConnection.WalkStateGraphContext walkStateGraphContext) throws SmackException.ConnectionException {
            XmppNioTcpConnection.this.failedAddresses = XmppNioTcpConnection.this.populateHostAddresses();
            if (XmppNioTcpConnection.this.hostAddresses.isEmpty()) {
                throw SmackException.ConnectionException.from((List)XmppNioTcpConnection.this.failedAddresses);
            }
            XmppNioTcpConnection.this.inetSocketAddresses = new ArrayList(2 * XmppNioTcpConnection.this.hostAddresses.size());
            for (HostAddress hostAddress : XmppNioTcpConnection.this.hostAddresses) {
                List inetAddresses = hostAddress.getInetAddresses();
                for (InetAddress inetAddress : inetAddresses) {
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, hostAddress.getPort());
                    XmppNioTcpConnection.this.inetSocketAddresses.add(inetSocketAddress);
                }
            }
            return new HostLookupResult(XmppNioTcpConnection.this.inetSocketAddresses);
        }

        protected void resetState() {
            XmppNioTcpConnection.this.failedAddresses = null;
            XmppNioTcpConnection.this.inetSocketAddresses = null;
        }
    }

    private static final class LookupHostAddressesStateDescriptor
    extends StateDescriptor {
        private LookupHostAddressesStateDescriptor() {
            super(LookupHostAddressesState.class);
            this.addPredeccessor(AbstractXmppStateMachineConnection.DisconnectedStateDescriptor.class);
            this.addSuccessor(ConnectingToHostStateDescriptor.class);
            this.addSuccessor(DirectTlsConnectionToHostStateDescriptor.class);
        }
    }

    private final class ConnectionAttemptState {
        private final ConnectingToHostState connectingToHostState;
        InetSocketAddress inetSocketAddress;
        final SocketChannel socketChannel = SocketChannel.open();
        final Iterator<InetSocketAddress> remainingAddresses;
        final List<HostAddress> failedAddresses;
        final SynchronizationPoint<SmackException.ConnectionException> tcpConnectionEstablishedSyncPoint;

        private ConnectionAttemptState(List<InetSocketAddress> inetSocketAddresses, List<HostAddress> failedAddresses, ConnectingToHostState connectingToHostState) throws IOException {
            this.socketChannel.configureBlocking(false);
            this.remainingAddresses = inetSocketAddresses.iterator();
            this.inetSocketAddress = this.remainingAddresses.next();
            this.failedAddresses = failedAddresses;
            this.connectingToHostState = connectingToHostState;
            this.tcpConnectionEstablishedSyncPoint = new SynchronizationPoint((AbstractXMPPConnection)XmppNioTcpConnection.this, "TCP connection establishment");
        }

        private void establishTcpConnection() {
            boolean connected;
            ConnectingToHostEvent connectingToHostEvent = new ConnectingToHostEvent(this.connectingToHostState, this.inetSocketAddress);
            XmppNioTcpConnection.this.invokeConnectionStateMachineListener((ConnectionStateEvent)connectingToHostEvent);
            try {
                connected = this.socketChannel.connect(this.inetSocketAddress);
            }
            catch (IOException e) {
                this.onIOExceptionWhenEstablishingTcpConnection(e);
                return;
            }
            if (connected) {
                ConnectedToHostEvent connectedToHostEvent = new ConnectedToHostEvent(this.connectingToHostState, this.inetSocketAddress, true);
                XmppNioTcpConnection.this.invokeConnectionStateMachineListener((ConnectionStateEvent)connectedToHostEvent);
                this.tcpConnectionEstablishedSyncPoint.reportSuccess();
                return;
            }
            try {
                XmppNioTcpConnection.this.registerWithSelector(this.socketChannel, 8, (selectedChannel, selectedSelectionKey) -> {
                    boolean finishConnected;
                    SocketChannel selectedSocketChannel = (SocketChannel)selectedChannel;
                    try {
                        finishConnected = selectedSocketChannel.finishConnect();
                    }
                    catch (IOException e) {
                        Async.go(() -> this.onIOExceptionWhenEstablishingTcpConnection(e));
                        return;
                    }
                    if (!finishConnected) {
                        Async.go(() -> this.onIOExceptionWhenEstablishingTcpConnection(new IOException("finishConnect() failed")));
                        return;
                    }
                    ConnectedToHostEvent connectedToHostEvent = new ConnectedToHostEvent(this.connectingToHostState, this.inetSocketAddress, false);
                    XmppNioTcpConnection.this.invokeConnectionStateMachineListener((ConnectionStateEvent)connectedToHostEvent);
                    this.tcpConnectionEstablishedSyncPoint.reportSuccess();
                });
            }
            catch (ClosedChannelException e) {
                this.onIOExceptionWhenEstablishingTcpConnection(e);
            }
        }

        private void onIOExceptionWhenEstablishingTcpConnection(IOException exception) {
            if (!this.remainingAddresses.hasNext()) {
                SmackException.ConnectionException connectionException = SmackException.ConnectionException.from(this.failedAddresses);
                this.tcpConnectionEstablishedSyncPoint.reportFailure((Exception)connectionException);
                return;
            }
            this.tcpConnectionEstablishedSyncPoint.resetTimeout();
            HostAddress failedHostAddress = new HostAddress(this.inetSocketAddress, (Exception)exception);
            this.failedAddresses.add(failedHostAddress);
            ConnectionToHostFailedEvent connectionToHostFailedEvent = new ConnectionToHostFailedEvent(this.connectingToHostState, this.inetSocketAddress, exception);
            XmppNioTcpConnection.this.invokeConnectionStateMachineListener((ConnectionStateEvent)connectionToHostFailedEvent);
            this.inetSocketAddress = this.remainingAddresses.next();
            this.establishTcpConnection();
        }
    }

    public static final class ConnectionToHostFailedEvent
    extends TcpHostEvent {
        private final IOException ioException;

        private ConnectionToHostFailedEvent(AbstractXmppStateMachineConnection.State state, InetSocketAddress inetSocketAddress, IOException ioException) {
            super(state, inetSocketAddress);
            this.ioException = ioException;
        }

        @Override
        public String toString() {
            return super.toString() + this.ioException;
        }
    }

    public static final class ConnectedToHostEvent
    extends TcpHostEvent {
        private final boolean connectionEstablishedImmediately;

        private ConnectedToHostEvent(AbstractXmppStateMachineConnection.State state, InetSocketAddress inetSocketAddress, boolean immediately) {
            super(state, inetSocketAddress);
            this.connectionEstablishedImmediately = immediately;
        }

        @Override
        public String toString() {
            return super.toString() + (this.connectionEstablishedImmediately ? "" : " not") + " connected immediately";
        }
    }

    public static final class ConnectingToHostEvent
    extends TcpHostEvent {
        private ConnectingToHostEvent(AbstractXmppStateMachineConnection.State state, InetSocketAddress inetSocketAddress) {
            super(state, inetSocketAddress);
        }
    }

    private static abstract class TcpHostEvent
    extends ConnectionStateEvent.DetailedTransitionIntoInformation {
        protected final InetSocketAddress inetSocketAddress;

        protected TcpHostEvent(AbstractXmppStateMachineConnection.State state, InetSocketAddress inetSocketAddress) {
            super(state);
            this.inetSocketAddress = inetSocketAddress;
        }

        public InetSocketAddress getInetSocketAddress() {
            return this.inetSocketAddress;
        }

        public String toString() {
            return super.toString() + ": " + this.inetSocketAddress;
        }
    }
}

