/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.xml.splitter;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import org.jxmpp.xml.splitter.XmppElementCallback;
import org.jxmpp.xml.splitter.XmppXmlSplitter;

public class Utf8ByteXmppXmlSplitter
extends OutputStream {
    private final XmppXmlSplitter xmppXmlSplitter;
    private final byte[] buffer = new byte[6];
    private char[] writeBuffer = new char[1024];
    private int writeBufferPos;
    private byte count;
    private byte expectedLength;

    public Utf8ByteXmppXmlSplitter(XmppElementCallback xmppElementCallback) {
        this(new XmppXmlSplitter(xmppElementCallback));
    }

    public Utf8ByteXmppXmlSplitter(XmppXmlSplitter xmppXmlSplitter) {
        this.xmppXmlSplitter = xmppXmlSplitter;
    }

    @Override
    public void write(int b) throws IOException {
        this.write((byte)(b & 0xFF));
    }

    public void write(byte b) throws IOException {
        this.process(b);
        this.afterInputProcessed();
    }

    public void write(ByteBuffer[] byteBuffers) throws IOException {
        this.write(Arrays.asList(byteBuffers));
    }

    public void write(Collection<? extends ByteBuffer> byteBuffers) throws IOException {
        int requiredNewCapacity = 0;
        for (ByteBuffer byteBuffer : byteBuffers) {
            requiredNewCapacity += byteBuffer.remaining();
        }
        this.ensureWriteBufferHasCapacityFor(requiredNewCapacity);
        for (ByteBuffer byteBuffer : byteBuffers) {
            int remaining = byteBuffer.remaining();
            if (byteBuffer.isDirect()) {
                int initialPosition = byteBuffer.position();
                for (int i = 0; i < remaining; ++i) {
                    this.process(byteBuffer.get(initialPosition + i));
                }
            } else {
                this.writeInternal(byteBuffer.array(), byteBuffer.position(), remaining);
            }
            byteBuffer.flip();
        }
        this.afterInputProcessed();
    }

    public void write(ByteBuffer byteBuffer) throws IOException {
        int remaining = byteBuffer.remaining();
        this.ensureWriteBufferHasCapacityFor(remaining);
        if (byteBuffer.isDirect()) {
            int initialPosition = byteBuffer.position();
            for (int i = 0; i < remaining; ++i) {
                this.process(byteBuffer.get(initialPosition + i));
            }
        } else {
            this.writeInternal(byteBuffer.array(), byteBuffer.position(), remaining);
        }
        this.afterInputProcessed();
        byteBuffer.flip();
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        this.ensureWriteBufferHasCapacityFor(length);
        this.writeInternal(b, offset, length);
        this.afterInputProcessed();
    }

    private void writeInternal(byte[] b, int offset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            this.process(b[offset + i]);
        }
    }

    public void resetWriteBuffer(int size) {
        this.writeBuffer = new char[size];
        this.writeBufferPos = 0;
    }

    private void process(byte b) throws IOException {
        this.buffer[this.count] = b;
        if (this.count == 0) {
            int firstByte = this.buffer[0] & 0xFF;
            if (firstByte < 128) {
                this.expectedLength = 1;
            } else if (firstByte < 224) {
                this.expectedLength = (byte)2;
            } else if (firstByte < 240) {
                this.expectedLength = (byte)3;
            } else if (firstByte < 248) {
                this.expectedLength = (byte)4;
            } else {
                throw new IOException("Invalid first UTF-8 byte: " + firstByte);
            }
        }
        if ((this.count = (byte)(this.count + 1)) == this.expectedLength) {
            int codepoint;
            if (this.expectedLength == 1) {
                codepoint = this.buffer[0] & 0x7F;
            } else {
                switch (this.expectedLength) {
                    case 2: {
                        codepoint = this.buffer[0] & 0x1F;
                        codepoint <<= 6;
                        break;
                    }
                    case 3: {
                        codepoint = this.buffer[0] & 0xF;
                        codepoint <<= 12;
                        break;
                    }
                    case 4: {
                        codepoint = this.buffer[0] & 6;
                        codepoint <<= 18;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                for (int i = 1; i < this.expectedLength; ++i) {
                    int bits = this.buffer[i] & 0x3F;
                    codepoint |= (bits <<= 6 * (this.expectedLength - 1 - i));
                }
            }
            this.ensureWriteBufferHasCapacityFor(2);
            if (codepoint < 65536) {
                this.appendToWriteBuffer((char)codepoint);
            } else {
                this.appendToWriteBuffer((char)(55296 + (codepoint & 0xFFA00000)));
                this.appendToWriteBuffer((char)(56320 + (codepoint & 0x3FF)));
            }
            this.count = 0;
        }
    }

    private void afterInputProcessed() throws IOException {
        this.xmppXmlSplitter.write(this.writeBuffer, 0, this.writeBufferPos);
        this.writeBufferPos = 0;
    }

    private void appendToWriteBuffer(char c) {
        this.writeBuffer[this.writeBufferPos++] = c;
    }

    private void ensureWriteBufferHasCapacityFor(int additionalCapacity) {
        int requiredCapacity = this.writeBufferPos + additionalCapacity;
        if (requiredCapacity <= this.writeBuffer.length) {
            return;
        }
        char[] newWriteBuffer = new char[requiredCapacity];
        System.arraycopy(this.writeBuffer, 0, newWriteBuffer, 0, this.writeBufferPos);
        this.writeBuffer = newWriteBuffer;
    }
}

