/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.GenericElementListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.util.XmppElementUtil;

public class NonzaCallback {
    protected final AbstractXMPPConnection connection;
    protected final Map<QName, GenericElementListener<? extends Nonza>> filterAndListeners;

    private NonzaCallback(Builder builder) {
        this.connection = builder.connection;
        this.filterAndListeners = builder.filterAndListeners;
        this.install();
    }

    void onNonzaReceived(Nonza nonza) {
        QName key = nonza.getQName();
        GenericElementListener<? extends Nonza> nonzaListener = this.filterAndListeners.get(key);
        nonzaListener.processElement(nonza);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Map<QName, NonzaCallback> map = this.connection.nonzaCallbacks;
        synchronized (map) {
            for (Map.Entry<QName, GenericElementListener<? extends Nonza>> entry : this.filterAndListeners.entrySet()) {
                QName filterKey = entry.getKey();
                NonzaCallback installedCallback = this.connection.nonzaCallbacks.get(filterKey);
                if (!this.equals(installedCallback)) continue;
                this.connection.nonzaCallbacks.remove(filterKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void install() {
        if (this.filterAndListeners.isEmpty()) {
            return;
        }
        Map<QName, NonzaCallback> map = this.connection.nonzaCallbacks;
        synchronized (map) {
            for (QName key : this.filterAndListeners.keySet()) {
                this.connection.nonzaCallbacks.put(key, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <SN extends Nonza, FN extends Nonza> SN sendAndWaitForResponse(Builder builder, Nonza nonza, Class<SN> successNonzaClass, Class<FN> failedNonzaClass) throws SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, XMPPException.FailedNonzaException {
        Nonza successNonza;
        NonzaResponseCallback nonzaCallback = new NonzaResponseCallback(successNonzaClass, failedNonzaClass, builder);
        try {
            nonzaCallback.connection.sendNonza(nonza);
            successNonza = nonzaCallback.waitForResponse();
        }
        finally {
            nonzaCallback.cancel();
        }
        return (SN)successNonza;
    }

    public static final class Builder {
        private final AbstractXMPPConnection connection;
        private Map<QName, GenericElementListener<? extends Nonza>> filterAndListeners = new HashMap<QName, GenericElementListener<? extends Nonza>>();

        Builder(AbstractXMPPConnection connection) {
            this.connection = connection;
        }

        public <N extends Nonza> Builder listenFor(Class<? extends N> nonza, GenericElementListener<? extends N> nonzaListener) {
            QName key = XmppElementUtil.getQNameFor(nonza);
            this.filterAndListeners.put(key, nonzaListener);
            return this;
        }

        public NonzaCallback install() {
            return new NonzaCallback(this);
        }
    }

    private static final class NonzaResponseCallback<SN extends Nonza, FN extends Nonza>
    extends NonzaCallback {
        private SN successNonza;
        private FN failedNonza;

        private NonzaResponseCallback(Class<? extends SN> successNonzaClass, Class<? extends FN> failedNonzaClass, Builder builder) {
            super(builder);
            QName successNonzaKey = XmppElementUtil.getQNameFor(successNonzaClass);
            QName failedNonzaKey = XmppElementUtil.getQNameFor(failedNonzaClass);
            GenericElementListener successListener = new GenericElementListener<SN>(successNonzaClass){

                @Override
                public void process(SN successNonza) {
                    successNonza = successNonza;
                    this.notifyResponse();
                }
            };
            GenericElementListener failedListener = new GenericElementListener<FN>(failedNonzaClass){

                @Override
                public void process(FN failedNonza) {
                    failedNonza = failedNonza;
                    this.notifyResponse();
                }
            };
            this.filterAndListeners.put(successNonzaKey, successListener);
            this.filterAndListeners.put(failedNonzaKey, failedListener);
            this.install();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyResponse() {
            NonzaResponseCallback nonzaResponseCallback = this;
            synchronized (nonzaResponseCallback) {
                this.notifyAll();
            }
        }

        private boolean hasReceivedSuccessOrFailedNonza() {
            return this.successNonza != null || this.failedNonza != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SN waitForResponse() throws SmackException.NoResponseException, InterruptedException, XMPPException.FailedNonzaException {
            long deadline = System.currentTimeMillis() + this.connection.getReplyTimeout();
            NonzaResponseCallback nonzaResponseCallback = this;
            synchronized (nonzaResponseCallback) {
                long now;
                while (!this.hasReceivedSuccessOrFailedNonza() && (now = System.currentTimeMillis()) < deadline) {
                    this.wait(deadline - now);
                }
            }
            if (!this.hasReceivedSuccessOrFailedNonza()) {
                throw SmackException.NoResponseException.newWith((XMPPConnection)this.connection, "Nonza Listener");
            }
            if (this.failedNonza != null) {
                throw new XMPPException.FailedNonzaException((Nonza)this.failedNonza);
            }
            assert (this.successNonza != null);
            return this.successNonza;
        }
    }
}

