/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.fsm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.net.ssl.SSLSession;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.XmppInputOutputFilter;
import org.jivesoftware.smack.compress.packet.Compress;
import org.jivesoftware.smack.compress.packet.Compressed;
import org.jivesoftware.smack.compress.packet.Failure;
import org.jivesoftware.smack.compression.XmppCompressionFactory;
import org.jivesoftware.smack.compression.XmppCompressionManager;
import org.jivesoftware.smack.fsm.ConnectionStateEvent;
import org.jivesoftware.smack.fsm.ConnectionStateMachineListener;
import org.jivesoftware.smack.fsm.LoginContext;
import org.jivesoftware.smack.fsm.StateDescriptor;
import org.jivesoftware.smack.fsm.StateDescriptorGraph;
import org.jivesoftware.smack.fsm.StateMachineException;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.sasl.SASLErrorException;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.sasl.packet.SaslStreamElements;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.parts.Resourcepart;

public abstract class AbstractXmppStateMachineConnection
extends AbstractXMPPConnection {
    private final List<ConnectionStateMachineListener> connectionStateMachineListeners = new CopyOnWriteArrayList<ConnectionStateMachineListener>();
    private boolean featuresReceived;
    protected boolean streamResumed;
    private StateDescriptorGraph.GraphVertex<State> currentStateVertex;
    private List<State> walkFromDisconnectToAuthenticated;
    private final List<XmppInputOutputFilter> inputOutputFilters = new CopyOnWriteArrayList<XmppInputOutputFilter>();
    private List<XmppInputOutputFilter> previousInputOutputFilters;
    private boolean compressionEnabled;

    protected AbstractXmppStateMachineConnection(ConnectionConfiguration configuration, StateDescriptorGraph.GraphVertex<StateDescriptor> initialStateDescriptorVertex) {
        super(configuration);
        this.currentStateVertex = StateDescriptorGraph.convertToStateGraph(initialStateDescriptorVertex, this);
    }

    @Override
    protected void loginInternal(String username, String password, Resourcepart resource) throws XMPPException, SmackException, IOException, InterruptedException {
        WalkStateGraphContext walkStateGraphContext = AbstractXmppStateMachineConnection.buildNewWalkTo(AuthenticatedAndResourceBoundStateDescriptor.class).withLoginContext(username, password, resource).build();
        this.walkStateGraph(walkStateGraphContext);
    }

    protected static WalkStateGraphContextBuilder buildNewWalkTo(Class<? extends StateDescriptor> finalStateClass) {
        return new WalkStateGraphContextBuilder(finalStateClass);
    }

    protected final void walkStateGraph(WalkStateGraphContext walkStateGraphContext) throws XMPPException.XMPPErrorException, SASLErrorException, XMPPException.FailedNonzaException, IOException, SmackException, InterruptedException {
        StateDescriptorGraph.GraphVertex<State> previousStateVertex = this.currentStateVertex;
        try {
            this.walkStateGraphInternal(walkStateGraphContext);
        }
        catch (IOException | InterruptedException | SmackException | XMPPException.FailedNonzaException | XMPPException.XMPPErrorException | SASLErrorException e) {
            this.currentStateVertex = previousStateVertex;
            State revertedState = this.currentStateVertex.getElement();
            this.invokeConnectionStateMachineListener(new ConnectionStateEvent.StateRevertBackwardsWalk(revertedState));
            revertedState.resetState();
            throw e;
        }
    }

    private void walkStateGraphInternal(WalkStateGraphContext walkStateGraphContext) throws XMPPException.XMPPErrorException, SASLErrorException, IOException, SmackException, InterruptedException, XMPPException.FailedNonzaException {
        StateDescriptorGraph.GraphVertex<State> initialStateVertex = this.currentStateVertex;
        State initialState = initialStateVertex.getElement();
        StateDescriptor initialStateDescriptor = initialState.getStateDescriptor();
        walkStateGraphContext.walkedStateGraphPath.add(initialState);
        if (initialStateDescriptor.getClass() == walkStateGraphContext.finalStateClass) {
            assert (initialStateDescriptor.isFinalState());
            this.invokeConnectionStateMachineListener(new ConnectionStateEvent.FinalStateReached(initialState));
            return;
        }
        List<StateDescriptorGraph.GraphVertex<State>> outgoingStateEdges = this.currentStateVertex.getOutgoingEdges();
        if (walkStateGraphContext.mandatoryIntermediateState != null && !walkStateGraphContext.mandatoryIntermediateStateHandled) {
            StateDescriptorGraph.GraphVertex<State> mandatoryIntermediateStateVertex = null;
            for (StateDescriptorGraph.GraphVertex<State> outgoingStateVertex : outgoingStateEdges) {
                if (outgoingStateVertex.getElement().getStateDescriptor().getClass() != walkStateGraphContext.mandatoryIntermediateState) continue;
                mandatoryIntermediateStateVertex = outgoingStateVertex;
                break;
            }
            if (mandatoryIntermediateStateVertex != null) {
                walkStateGraphContext.mandatoryIntermediateStateHandled = true;
                TransitionReason reason = this.attemptEnterState(mandatoryIntermediateStateVertex, walkStateGraphContext);
                if (reason instanceof TransitionSuccessResult) {
                    this.walkStateGraph(walkStateGraphContext);
                    return;
                }
                throw new StateMachineException.SmackMandatoryStateFailedException(mandatoryIntermediateStateVertex.getElement(), reason);
            }
        }
        Iterator<StateDescriptorGraph.GraphVertex<State>> it = outgoingStateEdges.iterator();
        while (it.hasNext()) {
            StateDescriptorGraph.GraphVertex<State> successorStateVertex = it.next();
            State successorState = successorStateVertex.getElement();
            TransitionReason reason = this.attemptEnterState(successorStateVertex, walkStateGraphContext);
            if (reason instanceof TransitionSuccessResult) break;
            if (reason != null) {
                walkStateGraphContext.failedStates.put(successorState, reason);
            }
            if (it.hasNext()) continue;
            throw new StateMachineException.SmackStateGraphDeadEndException(walkStateGraphContext.walkedStateGraphPath, walkStateGraphContext.failedStates);
        }
        this.walkStateGraph(walkStateGraphContext);
    }

    private TransitionReason attemptEnterState(StateDescriptorGraph.GraphVertex<State> successorStateVertex, WalkStateGraphContext walkStateGraphContext) throws SmackException, XMPPException.XMPPErrorException, SASLErrorException, IOException, InterruptedException, XMPPException.FailedNonzaException {
        TransitionIntoResult transitionIntoResult;
        State successorState = successorStateVertex.getElement();
        StateDescriptor successorStateDescriptor = successorState.getStateDescriptor();
        if (!successorStateDescriptor.isMultiVisitState() && walkStateGraphContext.walkedStateGraphPath.contains(successorState)) {
            return null;
        }
        if (successorStateDescriptor.isNotImplemented()) {
            TransitionImpossibleBecauseNotImplemented transtionImpossibleBecauseNotImplemented = new TransitionImpossibleBecauseNotImplemented(successorStateDescriptor);
            this.invokeConnectionStateMachineListener(new ConnectionStateEvent.TransitionNotPossible(successorState, transtionImpossibleBecauseNotImplemented));
            return transtionImpossibleBecauseNotImplemented;
        }
        try {
            TransitionImpossibleReason transitionImpossibleReason = successorState.isTransitionToPossible(walkStateGraphContext);
            if (transitionImpossibleReason != null) {
                this.invokeConnectionStateMachineListener(new ConnectionStateEvent.TransitionNotPossible(successorState, transitionImpossibleReason));
                return transitionImpossibleReason;
            }
            this.invokeConnectionStateMachineListener(new ConnectionStateEvent.AboutToTransitionInto(successorState));
            transitionIntoResult = successorState.transitionInto(walkStateGraphContext);
        }
        catch (IOException | InterruptedException | SmackException | XMPPException.FailedNonzaException | XMPPException.XMPPErrorException | SASLErrorException e) {
            this.invokeConnectionStateMachineListener(new ConnectionStateEvent.StateRevertBackwardsWalk(successorState));
            successorState.resetState();
            throw e;
        }
        if (transitionIntoResult instanceof TransitionFailureResult) {
            TransitionFailureResult transitionFailureResult = (TransitionFailureResult)transitionIntoResult;
            this.invokeConnectionStateMachineListener(new ConnectionStateEvent.TransitionFailed(successorState, transitionFailureResult));
            return transitionIntoResult;
        }
        TransitionSuccessResult transitionSuccessResult = (TransitionSuccessResult)transitionIntoResult;
        this.currentStateVertex = successorStateVertex;
        this.invokeConnectionStateMachineListener(new ConnectionStateEvent.SuccessfullyTransitionedInto(successorState, transitionSuccessResult));
        return transitionSuccessResult;
    }

    protected abstract SSLSession getSSLSession();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterFeaturesReceived() {
        this.featuresReceived = true;
        AbstractXmppStateMachineConnection abstractXmppStateMachineConnection = this;
        synchronized (abstractXmppStateMachineConnection) {
            this.notifyAll();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void parseAndProcessElement(String element) throws XmlPullParserException, IOException, InterruptedException, XMPPException.StreamErrorException, SmackException, SmackParsingException {
        XmlPullParser parser = PacketParserUtils.getParserFor(element);
        parser.next();
        XmlPullParser.Event event = parser.getEventType();
        while (true) {
            block0 : switch (event) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "message": 
                        case "iq": 
                        case "presence": {
                            this.parseAndProcessStanza(parser);
                            break block0;
                        }
                        case "error": {
                            StreamError streamError = PacketParserUtils.parseStreamError(parser, null);
                            this.saslFeatureReceived.reportFailure(new XMPPException.StreamErrorException(streamError));
                            throw new XMPPException.StreamErrorException(streamError);
                        }
                        case "features": {
                            this.parseFeatures(parser);
                            this.afterFeaturesReceived();
                            break block0;
                        }
                        case "challenge": {
                            String challengeData = parser.nextText();
                            this.getSASLAuthentication().challengeReceived(challengeData);
                            break block0;
                        }
                        case "success": {
                            SaslStreamElements.Success success = new SaslStreamElements.Success(parser.nextText());
                            this.getSASLAuthentication().authenticated(success);
                            this.sendStreamOpen();
                            break block0;
                        }
                    }
                    this.parseAndProcessNonza(parser);
                    break;
                }
                case END_DOCUMENT: {
                    return;
                }
            }
            event = parser.next();
        }
    }

    protected synchronized void prepareToWaitForFeaturesReceived() {
        this.featuresReceived = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForFeaturesReceived(String waitFor) throws InterruptedException, SmackException.ConnectionUnexpectedTerminatedException, SmackException.NoResponseException {
        long waitStartMs = System.currentTimeMillis();
        long timeoutMs = this.getReplyTimeout();
        AbstractXmppStateMachineConnection abstractXmppStateMachineConnection = this;
        synchronized (abstractXmppStateMachineConnection) {
            while (!this.featuresReceived && this.currentConnectionException == null) {
                long remainingWaitMs = timeoutMs - (System.currentTimeMillis() - waitStartMs);
                if (remainingWaitMs <= 0L) {
                    throw SmackException.NoResponseException.newWith((XMPPConnection)this, waitFor);
                }
                this.wait(remainingWaitMs);
            }
            if (this.currentConnectionException != null) {
                throw new SmackException.ConnectionUnexpectedTerminatedException(this.currentConnectionException);
            }
        }
    }

    protected void newStreamOpenWaitForFeaturesSequence(String waitFor) throws InterruptedException, SmackException.ConnectionUnexpectedTerminatedException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.prepareToWaitForFeaturesReceived();
        this.sendStreamOpen();
        this.waitForFeaturesReceived(waitFor);
    }

    protected final void addXmppInputOutputFilter(XmppInputOutputFilter xmppInputOutputFilter) {
        this.inputOutputFilters.add(0, xmppInputOutputFilter);
    }

    protected final ListIterator<XmppInputOutputFilter> getXmppInputOutputFilterBeginIterator() {
        return this.inputOutputFilters.listIterator();
    }

    protected final ListIterator<XmppInputOutputFilter> getXmppInputOutputFilterEndIterator() {
        return this.inputOutputFilters.listIterator(this.inputOutputFilters.size());
    }

    protected final synchronized List<Object> getFilterStats() {
        List<XmppInputOutputFilter> filters = this.inputOutputFilters.isEmpty() && this.previousInputOutputFilters != null ? this.previousInputOutputFilters : this.inputOutputFilters;
        ArrayList<Object> filterStats = new ArrayList<Object>(filters.size());
        for (XmppInputOutputFilter xmppInputOutputFilter : filters) {
            Object stats = xmppInputOutputFilter.getStats();
            if (stats == null) continue;
            filterStats.add(stats);
        }
        return Collections.unmodifiableList(filterStats);
    }

    @Override
    public final boolean isUsingCompression() {
        return this.compressionEnabled;
    }

    public void addConnectionStateMachineListener(ConnectionStateMachineListener connectionStateMachineListener) {
        this.connectionStateMachineListeners.add(connectionStateMachineListener);
    }

    public boolean removeConnectionStateMachineListener(ConnectionStateMachineListener connectionStateMachineListener) {
        return this.connectionStateMachineListeners.remove(connectionStateMachineListener);
    }

    protected void invokeConnectionStateMachineListener(ConnectionStateEvent connectionStateEvent) {
        if (this.connectionStateMachineListeners.isEmpty()) {
            return;
        }
        ASYNC_BUT_ORDERED.performAsyncButOrdered(this, () -> {
            for (ConnectionStateMachineListener connectionStateMachineListener : this.connectionStateMachineListeners) {
                connectionStateMachineListener.onConnectionStateEvent(connectionStateEvent, this);
            }
        });
    }

    private final class AuthenticatedAndResourceBoundState
    extends State {
        private AuthenticatedAndResourceBoundState(StateDescriptor stateDescriptor) {
            super(stateDescriptor);
        }

        @Override
        protected TransitionIntoResult transitionInto(WalkStateGraphContext walkStateGraphContext) throws SmackException.NotConnectedException, InterruptedException {
            if (AbstractXmppStateMachineConnection.this.walkFromDisconnectToAuthenticated != null) {
                assert (((State)walkStateGraphContext.walkedStateGraphPath.get(0)).stateDescriptor.getClass() != DisconnectedStateDescriptor.class);
                AbstractXmppStateMachineConnection.this.walkFromDisconnectToAuthenticated.addAll(walkStateGraphContext.walkedStateGraphPath);
            } else {
                AbstractXmppStateMachineConnection.this.walkFromDisconnectToAuthenticated = new ArrayList(walkStateGraphContext.walkedStateGraphPath.size() + 1);
                AbstractXmppStateMachineConnection.this.walkFromDisconnectToAuthenticated.addAll(walkStateGraphContext.walkedStateGraphPath);
            }
            AbstractXmppStateMachineConnection.this.walkFromDisconnectToAuthenticated.add(this);
            AbstractXmppStateMachineConnection.this.afterSuccessfulLogin(AbstractXmppStateMachineConnection.this.streamResumed);
            return TransitionSuccessResult.EMPTY_INSTANCE;
        }

        @Override
        protected void resetState() {
            AbstractXmppStateMachineConnection.this.authenticated = false;
        }
    }

    protected static final class AuthenticatedAndResourceBoundStateDescriptor
    extends StateDescriptor {
        private AuthenticatedAndResourceBoundStateDescriptor() {
            super(AuthenticatedAndResourceBoundState.class, StateDescriptor.Property.finalState);
        }
    }

    public static final class CompressionTransitionSuccessResult
    extends TransitionSuccessResult {
        private final String compressionMethod;

        private CompressionTransitionSuccessResult(String compressionMethod) {
            super(compressionMethod + " compression enabled");
            this.compressionMethod = compressionMethod;
        }

        public String getCompressionMethod() {
            return this.compressionMethod;
        }
    }

    private class CompressionState
    extends State {
        private XmppCompressionFactory selectedCompressionFactory;
        private XmppInputOutputFilter usedXmppInputOutputCompressionFitler;

        protected CompressionState(StateDescriptor stateDescriptor) {
            super(stateDescriptor);
        }

        @Override
        protected TransitionImpossibleReason isTransitionToPossible(WalkStateGraphContext walkStateGraphContext) {
            if (!AbstractXmppStateMachineConnection.this.config.isCompressionEnabled()) {
                return new TransitionImpossibleReason("Stream compression disabled");
            }
            Compress.Feature compressFeature = (Compress.Feature)AbstractXmppStateMachineConnection.this.getFeature("compression", "http://jabber.org/protocol/compress");
            if (compressFeature == null) {
                return new TransitionImpossibleReason("Stream compression not supported");
            }
            this.selectedCompressionFactory = XmppCompressionManager.getBestFactory(compressFeature);
            if (this.selectedCompressionFactory == null) {
                return new TransitionImpossibleReason("No matching compression factory");
            }
            this.usedXmppInputOutputCompressionFitler = this.selectedCompressionFactory.fabricate(AbstractXmppStateMachineConnection.this.config);
            return null;
        }

        @Override
        protected TransitionIntoResult transitionInto(WalkStateGraphContext walkStateGraphContext) throws SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.FailedNonzaException, InterruptedException, SmackException.ConnectionUnexpectedTerminatedException {
            String compressionMethod = this.selectedCompressionFactory.getCompressionMethod();
            AbstractXmppStateMachineConnection.this.sendAndWaitForResponse(new Compress(compressionMethod), Compressed.class, Failure.class);
            AbstractXmppStateMachineConnection.this.addXmppInputOutputFilter(this.usedXmppInputOutputCompressionFitler);
            AbstractXmppStateMachineConnection.this.newStreamOpenWaitForFeaturesSequence("server stream features after compression enabled");
            AbstractXmppStateMachineConnection.this.compressionEnabled = true;
            return new CompressionTransitionSuccessResult(compressionMethod);
        }

        @Override
        protected void resetState() {
            this.selectedCompressionFactory = null;
            this.usedXmppInputOutputCompressionFitler = null;
            AbstractXmppStateMachineConnection.this.compressionEnabled = false;
        }
    }

    protected static final class CompressionStateDescriptor
    extends StateDescriptor {
        private CompressionStateDescriptor() {
            super(CompressionState.class, 138);
            this.addSuccessor(AuthenticatedButUnboundStateDescriptor.class);
            this.declarePrecedenceOver(ResourceBindingStateDescriptor.class);
        }
    }

    public static final class ResourceBoundResult
    extends TransitionSuccessResult {
        private final Resourcepart resource;

        private ResourceBoundResult(Resourcepart boundResource, Resourcepart requestedResource) {
            super("Resource '" + boundResource + "' bound (requested: '" + requestedResource + "'");
            this.resource = boundResource;
        }

        public Resourcepart getResource() {
            return this.resource;
        }
    }

    private final class ResourceBindingState
    extends State {
        private ResourceBindingState(StateDescriptor stateDescriptor) {
            super(stateDescriptor);
        }

        @Override
        protected TransitionIntoResult transitionInto(WalkStateGraphContext walkStateGraphContext) throws XMPPException.XMPPErrorException, SASLErrorException, IOException, SmackException, InterruptedException {
            AbstractXmppStateMachineConnection.this.lastFeaturesReceived.reportSuccess();
            LoginContext loginContext = walkStateGraphContext.loginContext;
            Resourcepart resource = AbstractXmppStateMachineConnection.this.bindResourceAndEstablishSession(loginContext.resource);
            AbstractXmppStateMachineConnection.this.streamResumed = false;
            return new ResourceBoundResult(resource, loginContext.resource);
        }
    }

    protected static final class ResourceBindingStateDescriptor
    extends StateDescriptor {
        private ResourceBindingStateDescriptor() {
            super(ResourceBindingState.class, "RFC 6120 \u00a7 7");
            this.addSuccessor(AuthenticatedAndResourceBoundStateDescriptor.class);
        }
    }

    protected static final class AuthenticatedButUnboundStateDescriptor
    extends StateDescriptor {
        private AuthenticatedButUnboundStateDescriptor() {
            super(StateDescriptor.Property.multiVisitState);
            this.addSuccessor(ResourceBindingStateDescriptor.class);
            this.addSuccessor(CompressionStateDescriptor.class);
        }
    }

    public static final class SaslAuthenticationSuccessResult
    extends TransitionSuccessResult {
        private final String saslMechanismName;

        private SaslAuthenticationSuccessResult(SASLMechanism usedSaslMechanism) {
            super("SASL authentication successfull using " + usedSaslMechanism.getName());
            this.saslMechanismName = usedSaslMechanism.getName();
        }

        public String getSaslMechanismName() {
            return this.saslMechanismName;
        }
    }

    private final class SaslAuthenticationState
    extends State {
        private SaslAuthenticationState(StateDescriptor stateDescriptor) {
            super(stateDescriptor);
        }

        @Override
        protected TransitionIntoResult transitionInto(WalkStateGraphContext walkStateGraphContext) throws XMPPException.XMPPErrorException, SASLErrorException, IOException, SmackException, InterruptedException {
            AbstractXmppStateMachineConnection.this.prepareToWaitForFeaturesReceived();
            LoginContext loginContext = walkStateGraphContext.loginContext;
            SASLMechanism usedSaslMechanism = AbstractXmppStateMachineConnection.this.saslAuthentication.authenticate(loginContext.username, loginContext.password, AbstractXmppStateMachineConnection.this.config.getAuthzid(), AbstractXmppStateMachineConnection.this.getSSLSession());
            AbstractXmppStateMachineConnection.this.waitForFeaturesReceived("server stream features after SASL authentication");
            return new SaslAuthenticationSuccessResult(usedSaslMechanism);
        }
    }

    protected static final class SaslAuthenticationStateDescriptor
    extends StateDescriptor {
        private SaslAuthenticationStateDescriptor() {
            super(SaslAuthenticationState.class, "RFC 6120 \u00a7 6");
            this.addSuccessor(AuthenticatedButUnboundStateDescriptor.class);
        }
    }

    private final class ConnectedButUnauthenticatedState
    extends State {
        private ConnectedButUnauthenticatedState(StateDescriptor stateDescriptor) {
            super(stateDescriptor);
        }

        @Override
        protected TransitionIntoResult transitionInto(WalkStateGraphContext walkStateGraphContext) {
            assert (AbstractXmppStateMachineConnection.this.walkFromDisconnectToAuthenticated == null);
            if (this.getStateDescriptor().getClass() == walkStateGraphContext.finalStateClass) {
                AbstractXmppStateMachineConnection.this.walkFromDisconnectToAuthenticated = new ArrayList(walkStateGraphContext.walkedStateGraphPath);
            }
            AbstractXmppStateMachineConnection.this.connected = true;
            return TransitionSuccessResult.EMPTY_INSTANCE;
        }

        @Override
        protected void resetState() {
            AbstractXmppStateMachineConnection.this.connected = false;
        }
    }

    protected static final class ConnectedButUnauthenticatedStateDescriptor
    extends StateDescriptor {
        private ConnectedButUnauthenticatedStateDescriptor() {
            super(ConnectedButUnauthenticatedState.class, StateDescriptor.Property.finalState);
            this.addSuccessor(SaslAuthenticationStateDescriptor.class);
        }
    }

    private final class DisconnectedState
    extends State {
        private DisconnectedState(StateDescriptor stateDescriptor) {
            super(stateDescriptor);
        }

        @Override
        protected TransitionIntoResult transitionInto(WalkStateGraphContext walkStateGraphContext) {
            if (AbstractXmppStateMachineConnection.this.inputOutputFilters.isEmpty()) {
                AbstractXmppStateMachineConnection.this.previousInputOutputFilters = null;
            } else {
                AbstractXmppStateMachineConnection.this.previousInputOutputFilters = new ArrayList(AbstractXmppStateMachineConnection.this.inputOutputFilters.size());
                AbstractXmppStateMachineConnection.this.previousInputOutputFilters.addAll(AbstractXmppStateMachineConnection.this.inputOutputFilters);
                AbstractXmppStateMachineConnection.this.inputOutputFilters.clear();
            }
            ListIterator it = AbstractXmppStateMachineConnection.this.walkFromDisconnectToAuthenticated.listIterator(AbstractXmppStateMachineConnection.this.walkFromDisconnectToAuthenticated.size());
            while (it.hasPrevious()) {
                State stateToReset = (State)it.previous();
                stateToReset.resetState();
            }
            AbstractXmppStateMachineConnection.this.walkFromDisconnectToAuthenticated = null;
            return TransitionSuccessResult.EMPTY_INSTANCE;
        }
    }

    protected static class DisconnectedStateDescriptor
    extends StateDescriptor {
        protected DisconnectedStateDescriptor() {
            super(DisconnectedState.class, StateDescriptor.Property.finalState);
        }
    }

    protected final class NoOpState
    extends State {
        private NoOpState(StateDescriptor stateDescriptor) {
            super(stateDescriptor);
        }

        @Override
        protected TransitionImpossibleReason isTransitionToPossible(WalkStateGraphContext walkStateGraphContext) {
            return null;
        }

        @Override
        protected TransitionIntoResult transitionInto(WalkStateGraphContext walkStateGraphContext) {
            return TransitionSuccessResult.EMPTY_INSTANCE;
        }
    }

    public static final class TransitionFailureResult
    extends TransitionIntoResult {
        private TransitionFailureResult(String reason) {
            super(reason);
        }
    }

    public static class TransitionSuccessResult
    extends TransitionIntoResult {
        public static final TransitionSuccessResult EMPTY_INSTANCE = new TransitionSuccessResult();

        private TransitionSuccessResult() {
            super("");
        }

        public TransitionSuccessResult(String reason) {
            super(reason);
        }
    }

    protected static abstract class TransitionIntoResult
    extends TransitionReason {
        public TransitionIntoResult(String reason) {
            super(reason);
        }
    }

    protected static class TransitionImpossibleBecauseNotImplemented
    extends TransitionImpossibleReason {
        public TransitionImpossibleBecauseNotImplemented(StateDescriptor stateDescriptor) {
            super(stateDescriptor.getFullStateName(false) + " is not implemented (yet)");
        }
    }

    protected static class TransitionImpossibleReason
    extends TransitionReason {
        public TransitionImpossibleReason(String reason) {
            super(reason);
        }
    }

    static abstract class TransitionReason {
        public final String reason;

        private TransitionReason(String reason) {
            this.reason = reason;
        }

        public final String toString() {
            return this.reason;
        }
    }

    protected abstract class State {
        private final StateDescriptor stateDescriptor;

        protected State(StateDescriptor stateDescriptor) {
            this.stateDescriptor = stateDescriptor;
        }

        protected TransitionImpossibleReason isTransitionToPossible(WalkStateGraphContext walkStateGraphContext) throws SmackException {
            return null;
        }

        protected abstract TransitionIntoResult transitionInto(WalkStateGraphContext var1) throws XMPPException.XMPPErrorException, SASLErrorException, IOException, SmackException, InterruptedException, XMPPException.FailedNonzaException;

        StateDescriptor getStateDescriptor() {
            return this.stateDescriptor;
        }

        protected void resetState() {
        }

        public String toString() {
            return "State " + this.stateDescriptor + ' ' + AbstractXmppStateMachineConnection.this;
        }

        protected final void ensureNotOnOurWayToAuthenticatedAndResourceBound(WalkStateGraphContext walkStateGraphContext) {
            if (walkStateGraphContext.isFinalStateAuthenticatedAndResourceBound()) {
                throw new IllegalStateException("Smack should never attempt to reach the authenticated and resource bound state over " + this + ". This is probably a programming error within Smack, please report it to the develoeprs.");
            }
        }
    }

    protected static final class WalkStateGraphContextBuilder {
        private final Class<? extends StateDescriptor> finalStateClass;
        private Class<? extends StateDescriptor> mandatoryIntermedidateState;
        private LoginContext loginContext;

        private WalkStateGraphContextBuilder(Class<? extends StateDescriptor> finalStateClass) {
            this.finalStateClass = finalStateClass;
        }

        public WalkStateGraphContextBuilder withMandatoryIntermediateState(Class<? extends StateDescriptor> mandatoryIntermedidateState) {
            this.mandatoryIntermedidateState = mandatoryIntermedidateState;
            return this;
        }

        public WalkStateGraphContextBuilder withLoginContext(String username, String password, Resourcepart resource) {
            LoginContext loginContext = new LoginContext(username, password, resource);
            return this.withLoginContext(loginContext);
        }

        public WalkStateGraphContextBuilder withLoginContext(LoginContext loginContext) {
            this.loginContext = loginContext;
            return this;
        }

        public WalkStateGraphContext build() {
            return new WalkStateGraphContext(this.finalStateClass, this.mandatoryIntermedidateState, this.loginContext);
        }
    }

    protected static final class WalkStateGraphContext {
        private final Class<? extends StateDescriptor> finalStateClass;
        private final Class<? extends StateDescriptor> mandatoryIntermediateState;
        private final LoginContext loginContext;
        private final List<State> walkedStateGraphPath = new ArrayList<State>();
        private final Map<State, TransitionReason> failedStates = new LinkedHashMap<State, TransitionReason>();
        private boolean mandatoryIntermediateStateHandled;

        private WalkStateGraphContext(Class<? extends StateDescriptor> finalStateClass, Class<? extends StateDescriptor> mandatoryIntermedidateState, LoginContext loginContext) {
            this.finalStateClass = Objects.requireNonNull(finalStateClass);
            this.mandatoryIntermediateState = mandatoryIntermedidateState;
            this.loginContext = loginContext;
        }

        public boolean isFinalStateAuthenticatedAndResourceBound() {
            return this.finalStateClass == AuthenticatedAndResourceBoundStateDescriptor.class;
        }
    }
}

