/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.util.dns.HostAddress;
import org.jivesoftware.smack.util.dns.SRVRecord;
import org.minidns.dnsname.DnsName;

public abstract class DNSResolver {
    protected static final Logger LOGGER = Logger.getLogger(DNSResolver.class.getName());
    private final boolean supportsDnssec;

    protected DNSResolver(boolean supportsDnssec) {
        this.supportsDnssec = supportsDnssec;
    }

    public final List<SRVRecord> lookupSRVRecords(DnsName name, List<HostAddress> failedAddresses, ConnectionConfiguration.DnssecMode dnssecMode) {
        this.checkIfDnssecRequestedAndSupported(dnssecMode);
        return this.lookupSRVRecords0(name, failedAddresses, dnssecMode);
    }

    protected abstract List<SRVRecord> lookupSRVRecords0(DnsName var1, List<HostAddress> var2, ConnectionConfiguration.DnssecMode var3);

    public final HostAddress lookupHostAddress(DnsName name, int port, List<HostAddress> failedAddresses, ConnectionConfiguration.DnssecMode dnssecMode) {
        this.checkIfDnssecRequestedAndSupported(dnssecMode);
        List<InetAddress> inetAddresses = this.lookupHostAddress0(name, failedAddresses, dnssecMode);
        if (inetAddresses == null || inetAddresses.isEmpty()) {
            return null;
        }
        return new HostAddress(name, port, inetAddresses);
    }

    protected List<InetAddress> lookupHostAddress0(DnsName name, List<HostAddress> failedAddresses, ConnectionConfiguration.DnssecMode dnssecMode) {
        InetAddress[] inetAddressArray;
        if (dnssecMode != ConnectionConfiguration.DnssecMode.disabled) {
            throw new UnsupportedOperationException("This resolver does not support DNSSEC");
        }
        try {
            inetAddressArray = InetAddress.getAllByName(name.toString());
        }
        catch (UnknownHostException e) {
            failedAddresses.add(new HostAddress(name, (Exception)e));
            return null;
        }
        return Arrays.asList(inetAddressArray);
    }

    protected final boolean shouldContinue(CharSequence name, CharSequence hostname, List<InetAddress> hostAddresses) {
        if (hostAddresses == null) {
            return true;
        }
        if (hostAddresses.isEmpty()) {
            LOGGER.log(Level.INFO, "The DNS name " + name + ", points to a hostname (" + hostname + ") which has neither A or AAAA resource records. This is an indication of a broken DNS setup.");
            return true;
        }
        return false;
    }

    private void checkIfDnssecRequestedAndSupported(ConnectionConfiguration.DnssecMode dnssecMode) {
        if (dnssecMode != ConnectionConfiguration.DnssecMode.disabled && !this.supportsDnssec) {
            throw new UnsupportedOperationException("This resolver does not support DNSSEC");
        }
    }
}

