/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.description.Description;
import org.assertj.core.util.CheckReturnValue;

public class ThrowableAssertAlternative<T extends Throwable>
extends AbstractAssert<ThrowableAssertAlternative<T>, T> {
    private ThrowableAssert delegate;

    public ThrowableAssertAlternative(T actual) {
        super(actual, ThrowableAssertAlternative.class);
        this.delegate = new ThrowableAssert((Throwable)actual);
    }

    public ThrowableAssertAlternative<T> withMessage(String message) {
        this.delegate.hasMessage(message);
        return this;
    }

    public ThrowableAssertAlternative<T> withMessage(String message, Object ... parameters) {
        this.delegate.hasMessage(message, parameters);
        return this;
    }

    public ThrowableAssertAlternative<T> withCause(Throwable cause) {
        this.delegate.hasCause(cause);
        return this;
    }

    public ThrowableAssertAlternative<T> withNoCause() {
        this.delegate.hasNoCause();
        return this;
    }

    public ThrowableAssertAlternative<T> withMessageStartingWith(String description) {
        this.delegate.hasMessageStartingWith(description);
        return this;
    }

    public ThrowableAssertAlternative<T> withMessageContaining(String description) {
        this.delegate.hasMessageContaining(description);
        return this;
    }

    public ThrowableAssertAlternative<T> withStackTraceContaining(String description) {
        this.delegate.hasStackTraceContaining(description);
        return this;
    }

    public ThrowableAssertAlternative<T> withMessageMatching(String regex) {
        this.delegate.hasMessageMatching(regex);
        return this;
    }

    public ThrowableAssertAlternative<T> withMessageEndingWith(String description) {
        this.delegate.hasMessageEndingWith(description);
        return this;
    }

    public ThrowableAssertAlternative<T> withCauseInstanceOf(Class<? extends Throwable> type) {
        this.delegate.hasCauseInstanceOf(type);
        return this;
    }

    public ThrowableAssertAlternative<T> withCauseExactlyInstanceOf(Class<? extends Throwable> type) {
        this.delegate.hasCauseExactlyInstanceOf(type);
        return this;
    }

    public ThrowableAssertAlternative<T> withRootCauseInstanceOf(Class<? extends Throwable> type) {
        this.delegate.hasRootCauseInstanceOf(type);
        return this;
    }

    public ThrowableAssertAlternative<T> withRootCauseExactlyInstanceOf(Class<? extends Throwable> type) {
        this.delegate.hasRootCauseExactlyInstanceOf(type);
        return this;
    }

    @Override
    @CheckReturnValue
    public ThrowableAssertAlternative<T> describedAs(String description, Object ... args) {
        this.delegate.describedAs(description, args);
        return (ThrowableAssertAlternative)super.describedAs(description, args);
    }

    @Override
    @CheckReturnValue
    public ThrowableAssertAlternative<T> describedAs(Description description) {
        this.delegate.describedAs(description);
        return (ThrowableAssertAlternative)super.describedAs(description);
    }
}

