/*
 * Decompiled with CFR 0.152.
 */
package eu.geekplace.javapinning.pin;

import eu.geekplace.javapinning.pin.CertPlainPin;
import eu.geekplace.javapinning.pin.CertSha256Pin;
import eu.geekplace.javapinning.pin.PlainPin;
import eu.geekplace.javapinning.pin.Sha256Pin;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Pin {
    private static final Logger LOGGER = Logger.getLogger(Sha256Pin.class.getName());
    protected static final MessageDigest sha256md;
    protected final byte[] pinBytes;

    protected Pin(String pinHexString) {
        char[] pinHexChars;
        pinHexString = pinHexString.toLowerCase();
        pinHexString = pinHexString.replaceAll("[:\\s]", "");
        for (char c : pinHexChars = pinHexString.toCharArray()) {
            if (c >= 'a' && c <= 'f' || c >= '0' && c <= '9') continue;
            throw new IllegalArgumentException("Pin String must only contain whitespaces, semicolons (':'), and ASCII letters [a-fA-F] and numbers [0-9], found offending char: '" + c + "'");
        }
        int len = pinHexChars.length;
        this.pinBytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            this.pinBytes[i / 2] = (byte)((Character.digit(pinHexString.charAt(i), 16) << 4) + Character.digit(pinHexString.charAt(i + 1), 16));
        }
    }

    public abstract boolean pinsCertificate(X509Certificate var1) throws CertificateEncodingException;

    protected abstract boolean pinsCertificate(byte[] var1);

    public static Pin fromString(String string) {
        String[] pin = string.split(":", 2);
        if (pin.length != 2) {
            throw new IllegalArgumentException();
        }
        String type = pin[0];
        String pinHex = pin[1];
        switch (type) {
            case "SHA256": {
                return new Sha256Pin(pinHex);
            }
            case "PLAIN": {
                return new PlainPin(pinHex);
            }
            case "CERTSHA256": {
                return new CertSha256Pin(pinHex);
            }
            case "CERTPLAIN": {
                return new CertPlainPin(pinHex);
            }
        }
        throw new IllegalArgumentException();
    }

    byte[] getPinBytes() {
        return (byte[])this.pinBytes.clone();
    }

    static {
        MessageDigest sha256mdtemp = null;
        try {
            sha256mdtemp = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.log(Level.WARNING, "SHA-256 MessageDigest not available", e);
        }
        sha256md = sha256mdtemp;
    }
}

