/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smackx.omemo.OmemoConfiguration;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoService;
import org.jivesoftware.smackx.omemo.element.OmemoBundleElement_VAxolotl;
import org.jivesoftware.smackx.omemo.element.OmemoDeviceListElement;
import org.jivesoftware.smackx.omemo.exceptions.CannotEstablishOmemoSessionException;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.exceptions.NoIdentityKeyException;
import org.jivesoftware.smackx.omemo.internal.OmemoCachedDeviceList;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.trust.OmemoFingerprint;
import org.jivesoftware.smackx.omemo.util.OmemoKeyUtil;
import org.jxmpp.jid.BareJid;

public abstract class OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> {
    private static final Logger LOGGER = Logger.getLogger(OmemoStore.class.getName());

    public abstract SortedSet<Integer> localDeviceIdsOf(BareJid var1);

    boolean isAvailableDeviceId(OmemoDevice userDevice, int id) {
        LOGGER.log(Level.INFO, "Check if id " + id + " is available...");
        BareJid ownJid = userDevice.getJid();
        OmemoCachedDeviceList cachedDeviceList = this.loadCachedDeviceList(userDevice, ownJid);
        if (cachedDeviceList == null) {
            cachedDeviceList = new OmemoCachedDeviceList();
        }
        return !cachedDeviceList.contains(id);
    }

    OmemoCachedDeviceList mergeCachedDeviceList(OmemoDevice userDevice, BareJid contact, OmemoDeviceListElement list) {
        OmemoCachedDeviceList cached = this.loadCachedDeviceList(userDevice, contact);
        if (cached == null) {
            cached = new OmemoCachedDeviceList();
        }
        if (list == null) {
            return cached;
        }
        for (int devId : list.getDeviceIds()) {
            if (cached.contains(devId)) continue;
            this.setDateOfLastDeviceIdPublication(userDevice, new OmemoDevice(contact, devId), new Date());
        }
        cached.merge(list.getDeviceIds());
        this.storeCachedDeviceList(userDevice, contact, cached);
        return cached;
    }

    void changeSignedPreKey(OmemoDevice userDevice) throws CorruptedOmemoKeyException {
        T_IdKeyPair idKeyPair = this.loadOmemoIdentityKeyPair(userDevice);
        if (idKeyPair == null) {
            throw new IllegalStateException("Our IdentityKeyPair is null.");
        }
        TreeMap<Integer, T_SigPreKey> signedPreKeys = this.loadOmemoSignedPreKeys(userDevice);
        if (signedPreKeys.size() == 0) {
            T_SigPreKey newKey = this.generateOmemoSignedPreKey(idKeyPair, 1);
            this.storeOmemoSignedPreKey(userDevice, 1, newKey);
        } else {
            int lastId = signedPreKeys.lastKey();
            T_SigPreKey newKey = this.generateOmemoSignedPreKey(idKeyPair, lastId + 1);
            this.storeOmemoSignedPreKey(userDevice, lastId + 1, newKey);
        }
        this.setDateOfLastSignedPreKeyRenewal(userDevice, new Date());
        this.removeOldSignedPreKeys(userDevice);
    }

    private void removeOldSignedPreKeys(OmemoDevice userDevice) {
        if (OmemoConfiguration.getMaxNumberOfStoredSignedPreKeys() <= 0) {
            return;
        }
        TreeMap<Integer, T_SigPreKey> signedPreKeys = this.loadOmemoSignedPreKeys(userDevice);
        for (int i = 0; i < signedPreKeys.keySet().size() - OmemoConfiguration.getMaxNumberOfStoredSignedPreKeys(); ++i) {
            int keyId = signedPreKeys.firstKey();
            LOGGER.log(Level.INFO, "Remove signedPreKey " + keyId + ".");
            this.removeOmemoSignedPreKey(userDevice, i);
            signedPreKeys = this.loadOmemoSignedPreKeys(userDevice);
        }
    }

    OmemoBundleElement_VAxolotl packOmemoBundle(OmemoDevice userDevice) throws CorruptedOmemoKeyException {
        int currentSignedPreKeyId = this.loadCurrentOmemoSignedPreKeyId(userDevice);
        T_SigPreKey currentSignedPreKey = this.loadOmemoSignedPreKeys(userDevice).get(currentSignedPreKeyId);
        return new OmemoBundleElement_VAxolotl(currentSignedPreKeyId, this.keyUtil().signedPreKeyPublicForBundle(currentSignedPreKey), this.keyUtil().signedPreKeySignatureFromKey(currentSignedPreKey), this.keyUtil().identityKeyForBundle(this.keyUtil().identityKeyFromPair(this.loadOmemoIdentityKeyPair(userDevice))), this.keyUtil().preKeyPublicKeysForBundle(this.loadOmemoPreKeys(userDevice)));
    }

    public void replenishKeys(OmemoDevice userDevice) throws CorruptedOmemoKeyException {
        int startId;
        TreeMap<Integer, T_SigPreKey> signedPreKeys;
        T_IdKeyPair identityKeyPair = this.loadOmemoIdentityKeyPair(userDevice);
        if (identityKeyPair == null) {
            identityKeyPair = this.generateOmemoIdentityKeyPair();
            this.storeOmemoIdentityKeyPair(userDevice, identityKeyPair);
        }
        if ((signedPreKeys = this.loadOmemoSignedPreKeys(userDevice)).size() == 0) {
            this.changeSignedPreKey(userDevice);
        }
        TreeMap<Integer, T_PreKey> preKeys = this.loadOmemoPreKeys(userDevice);
        int newKeysCount = 100 - preKeys.size();
        int n = startId = preKeys.size() == 0 ? 0 : preKeys.lastKey();
        if (newKeysCount > 0) {
            TreeMap<Integer, T_PreKey> newKeys = this.generateOmemoPreKeys(startId + 1, newKeysCount);
            this.storeOmemoPreKeys(userDevice, newKeys);
        }
    }

    public T_IdKeyPair generateOmemoIdentityKeyPair() {
        return this.keyUtil().generateOmemoIdentityKeyPair();
    }

    public abstract T_IdKeyPair loadOmemoIdentityKeyPair(OmemoDevice var1) throws CorruptedOmemoKeyException;

    public abstract void storeOmemoIdentityKeyPair(OmemoDevice var1, T_IdKeyPair var2);

    public abstract void removeOmemoIdentityKeyPair(OmemoDevice var1);

    public abstract T_IdKey loadOmemoIdentityKey(OmemoDevice var1, OmemoDevice var2) throws CorruptedOmemoKeyException;

    public abstract void storeOmemoIdentityKey(OmemoDevice var1, OmemoDevice var2, T_IdKey var3);

    public abstract void removeOmemoIdentityKey(OmemoDevice var1, OmemoDevice var2);

    public abstract void storeOmemoMessageCounter(OmemoDevice var1, OmemoDevice var2, int var3);

    public abstract int loadOmemoMessageCounter(OmemoDevice var1, OmemoDevice var2);

    public abstract void setDateOfLastReceivedMessage(OmemoDevice var1, OmemoDevice var2, Date var3);

    public abstract Date getDateOfLastReceivedMessage(OmemoDevice var1, OmemoDevice var2);

    public abstract void setDateOfLastDeviceIdPublication(OmemoDevice var1, OmemoDevice var2, Date var3);

    public abstract Date getDateOfLastDeviceIdPublication(OmemoDevice var1, OmemoDevice var2);

    public abstract void setDateOfLastSignedPreKeyRenewal(OmemoDevice var1, Date var2);

    public abstract Date getDateOfLastSignedPreKeyRenewal(OmemoDevice var1);

    public TreeMap<Integer, T_PreKey> generateOmemoPreKeys(int startId, int count) {
        return this.keyUtil().generateOmemoPreKeys(startId, count);
    }

    public abstract T_PreKey loadOmemoPreKey(OmemoDevice var1, int var2);

    public abstract void storeOmemoPreKey(OmemoDevice var1, int var2, T_PreKey var3);

    public void storeOmemoPreKeys(OmemoDevice userDevice, TreeMap<Integer, T_PreKey> preKeyHashMap) {
        for (Map.Entry<Integer, T_PreKey> entry : preKeyHashMap.entrySet()) {
            this.storeOmemoPreKey(userDevice, entry.getKey(), entry.getValue());
        }
    }

    public abstract void removeOmemoPreKey(OmemoDevice var1, int var2);

    public abstract TreeMap<Integer, T_PreKey> loadOmemoPreKeys(OmemoDevice var1);

    public abstract T_SigPreKey loadOmemoSignedPreKey(OmemoDevice var1, int var2);

    public int loadCurrentOmemoSignedPreKeyId(OmemoDevice userDevice) {
        return this.loadOmemoSignedPreKeys(userDevice).lastKey();
    }

    public abstract TreeMap<Integer, T_SigPreKey> loadOmemoSignedPreKeys(OmemoDevice var1);

    public T_SigPreKey generateOmemoSignedPreKey(T_IdKeyPair identityKeyPair, int signedPreKeyId) throws CorruptedOmemoKeyException {
        return this.keyUtil().generateOmemoSignedPreKey(identityKeyPair, signedPreKeyId);
    }

    public abstract void storeOmemoSignedPreKey(OmemoDevice var1, int var2, T_SigPreKey var3);

    public abstract void removeOmemoSignedPreKey(OmemoDevice var1, int var2);

    public abstract T_Sess loadRawSession(OmemoDevice var1, OmemoDevice var2);

    public abstract HashMap<Integer, T_Sess> loadAllRawSessionsOf(OmemoDevice var1, BareJid var2);

    public abstract void storeRawSession(OmemoDevice var1, OmemoDevice var2, T_Sess var3);

    public abstract void removeRawSession(OmemoDevice var1, OmemoDevice var2);

    public abstract void removeAllRawSessionsOf(OmemoDevice var1, BareJid var2);

    public abstract boolean containsRawSession(OmemoDevice var1, OmemoDevice var2);

    public abstract OmemoCachedDeviceList loadCachedDeviceList(OmemoDevice var1, BareJid var2);

    public OmemoCachedDeviceList loadCachedDeviceList(OmemoDevice userDevice) {
        return this.loadCachedDeviceList(userDevice, userDevice.getJid());
    }

    public abstract void storeCachedDeviceList(OmemoDevice var1, BareJid var2, OmemoCachedDeviceList var3);

    public abstract void purgeOwnDeviceKeys(OmemoDevice var1);

    public abstract OmemoKeyUtil<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_ECPub, T_Bundle> keyUtil();

    public OmemoFingerprint getFingerprint(OmemoDevice userDevice) throws CorruptedOmemoKeyException {
        T_IdKeyPair keyPair = this.loadOmemoIdentityKeyPair(userDevice);
        if (keyPair == null) {
            return null;
        }
        return this.keyUtil().getFingerprintOfIdentityKey(this.keyUtil().identityKeyFromPair(keyPair));
    }

    public OmemoFingerprint getFingerprint(OmemoDevice userDevice, OmemoDevice contactsDevice) throws CorruptedOmemoKeyException, NoIdentityKeyException {
        T_IdKey identityKey = this.loadOmemoIdentityKey(userDevice, contactsDevice);
        if (identityKey == null) {
            throw new NoIdentityKeyException(contactsDevice);
        }
        return this.keyUtil().getFingerprintOfIdentityKey(identityKey);
    }

    public OmemoFingerprint getFingerprintAndMaybeBuildSession(OmemoManager.LoggedInOmemoManager managerGuard, OmemoDevice contactsDevice) throws CannotEstablishOmemoSessionException, CorruptedOmemoKeyException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        OmemoManager omemoManager = managerGuard.get();
        T_IdKey identityKey = this.loadOmemoIdentityKey(omemoManager.getOwnDevice(), contactsDevice);
        if (identityKey == null) {
            OmemoService.getInstance().buildFreshSessionWithDevice(omemoManager.getConnection(), omemoManager.getOwnDevice(), contactsDevice);
        }
        if ((identityKey = this.loadOmemoIdentityKey(omemoManager.getOwnDevice(), contactsDevice)) == null) {
            return null;
        }
        return this.keyUtil().getFingerprintOfIdentityKey(identityKey);
    }
}

