/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.parsing;

import java.io.IOException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.test.util.CharSequenceEquals;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ParsingExceptionTest {
    private static final String EXTENSION2 = "<extension2 xmlns='namespace'><bar node='testNode'><i id='testid1'>text content</i></bar></extension2>";

    @Before
    public void init() {
        ProviderManager.addExtensionProvider((String)"exception", (String)"http://smack.jivesoftware.org/exception", (Object)((Object)new ThrowException()));
    }

    @After
    public void tini() {
        ProviderManager.removeExtensionProvider((String)"exception", (String)"http://smack.jivesoftware.org/exception");
    }

    @Test
    public void consumeUnparsedInput() throws Exception {
        String MESSAGE_EXCEPTION_ELEMENT = "<exception xmlns='http://smack.jivesoftware.org/exception'><nothingInHere/></exception>";
        XmlPullParser parser = TestUtils.getMessageParser("<message from='user@server.example' to='francisco@denmark.lit' id='foo'><exception xmlns='http://smack.jivesoftware.org/exception'><nothingInHere/></exception><extension2 xmlns='namespace'><bar node='testNode'><i id='testid1'>text content</i></bar></extension2></message>");
        int parserDepth = parser.getDepth();
        CharSequence content = null;
        try {
            PacketParserUtils.parseMessage((XmlPullParser)parser);
        }
        catch (Exception e) {
            content = PacketParserUtils.parseContentDepth((XmlPullParser)parser, (int)parserDepth, (boolean)false);
        }
        Assert.assertThat((Object)"<exception xmlns='http://smack.jivesoftware.org/exception'><nothingInHere/></exception><extension2 xmlns='namespace'><bar node='testNode'><i id='testid1'>text content</i></bar></extension2></message>", CharSequenceEquals.equalsCharSequence(content));
    }

    static class ThrowException
    extends ExtensionElementProvider<ExtensionElement> {
        public static final String ELEMENT = "exception";
        public static final String NAMESPACE = "http://smack.jivesoftware.org/exception";

        ThrowException() {
        }

        public ExtensionElement parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws IOException {
            throw new IOException("Test Exception");
        }
    }
}

