/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iot.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.iot.IoTManager;
import org.jivesoftware.smackx.iot.Thing;
import org.jivesoftware.smackx.iot.data.ThingMomentaryReadOutRequest;
import org.jivesoftware.smackx.iot.data.ThingMomentaryReadOutResult;
import org.jivesoftware.smackx.iot.data.element.IoTDataField;
import org.jivesoftware.smackx.iot.data.element.IoTDataReadOutAccepted;
import org.jivesoftware.smackx.iot.data.element.IoTDataRequest;
import org.jivesoftware.smackx.iot.data.element.IoTFieldsExtension;
import org.jivesoftware.smackx.iot.data.filter.IoTFieldsExtensionFilter;
import org.jivesoftware.smackx.iot.element.NodeInfo;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public final class IoTDataManager
extends IoTManager {
    private static final Logger LOGGER = Logger.getLogger(IoTDataManager.class.getName());
    private static final Map<XMPPConnection, IoTDataManager> INSTANCES = new WeakHashMap<XMPPConnection, IoTDataManager>();
    private final AtomicInteger nextSeqNr = new AtomicInteger();
    private final Map<NodeInfo, Thing> things = new ConcurrentHashMap<NodeInfo, Thing>();

    public static synchronized IoTDataManager getInstanceFor(XMPPConnection connection) {
        IoTDataManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new IoTDataManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    private IoTDataManager(XMPPConnection connection) {
        super(connection);
        connection.registerIQRequestHandler((IQRequestHandler)new IoTManager.IoTIqRequestHandler("req", "urn:xmpp:iot:sensordata", IQ.Type.get, IQRequestHandler.Mode.async){

            @Override
            public IQ handleIoTIqRequest(IQ iqRequest) {
                final IoTDataRequest dataRequest = (IoTDataRequest)iqRequest;
                if (!dataRequest.isMomentary()) {
                    return null;
                }
                final Thing thing = (Thing)IoTDataManager.this.things.get(NodeInfo.EMPTY);
                if (thing == null) {
                    return null;
                }
                ThingMomentaryReadOutRequest readOutRequest = thing.getMomentaryReadOutRequestHandler();
                if (readOutRequest == null) {
                    return null;
                }
                readOutRequest.momentaryReadOutRequest(new ThingMomentaryReadOutResult(){

                    @Override
                    public void momentaryReadOut(List<? extends IoTDataField> results) {
                        IoTFieldsExtension iotFieldsExtension = IoTFieldsExtension.buildFor(dataRequest.getSequenceNr(), true, thing.getNodeInfo(), results);
                        Message message = new Message(dataRequest.getFrom());
                        message.addExtension((ExtensionElement)iotFieldsExtension);
                        try {
                            IoTDataManager.this.connection().sendStanza((Stanza)message);
                        }
                        catch (InterruptedException | SmackException.NotConnectedException e) {
                            LOGGER.log(Level.SEVERE, "Could not send read-out response " + message, e);
                        }
                    }
                });
                return new IoTDataReadOutAccepted(dataRequest);
            }
        });
    }

    public void installThing(Thing thing) {
        this.things.put(thing.getNodeInfo(), thing);
    }

    public Thing uninstallThing(Thing thing) {
        return this.uninstallThing(thing.getNodeInfo());
    }

    public Thing uninstallThing(NodeInfo nodeInfo) {
        return this.things.remove(nodeInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IoTFieldsExtension> requestMomentaryValuesReadOut(EntityFullJid jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        XMPPConnection connection = this.connection();
        int seqNr = this.nextSeqNr.incrementAndGet();
        IoTDataRequest iotDataRequest = new IoTDataRequest(seqNr, true);
        iotDataRequest.setTo((Jid)jid);
        IoTFieldsExtensionFilter doneFilter = new IoTFieldsExtensionFilter(seqNr, true);
        IoTFieldsExtensionFilter dataFilter = new IoTFieldsExtensionFilter(seqNr, false);
        StanzaCollector doneCollector = connection.createStanzaCollector((StanzaFilter)doneFilter);
        StanzaCollector.Configuration dataCollectorConfiguration = StanzaCollector.newConfiguration().setStanzaFilter((StanzaFilter)dataFilter).setCollectorToReset(doneCollector);
        StanzaCollector dataCollector = connection.createStanzaCollector(dataCollectorConfiguration);
        try {
            connection.createStanzaCollectorAndSend((IQ)iotDataRequest).nextResultOrThrow();
            doneCollector.nextResult();
        }
        finally {
            dataCollector.cancel();
        }
        int collectedCount = dataCollector.getCollectedCount();
        ArrayList<IoTFieldsExtension> res = new ArrayList<IoTFieldsExtension>(collectedCount);
        for (int i = 0; i < collectedCount; ++i) {
            Message message = (Message)dataCollector.pollResult();
            IoTFieldsExtension iotFieldsExtension = IoTFieldsExtension.from(message);
            res.add(iotFieldsExtension);
        }
        return res;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                if (!IoTManager.isAutoEnableActive()) {
                    return;
                }
                IoTDataManager.getInstanceFor(connection);
            }
        });
    }
}

