/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muclight.provider;

import java.io.IOException;
import java.util.HashMap;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.muclight.element.MUCLightBlockingIQ;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class MUCLightBlockingIQProvider
extends IQProvider<MUCLightBlockingIQ> {
    public MUCLightBlockingIQ parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
        HashMap<Jid, Boolean> rooms = null;
        HashMap<Jid, Boolean> users = null;
        while (true) {
            XmlPullParser.Event eventType;
            if ((eventType = parser.next()) == XmlPullParser.Event.START_ELEMENT) {
                if (parser.getName().equals("room")) {
                    rooms = MUCLightBlockingIQProvider.parseBlocking(parser, rooms);
                }
                if (!parser.getName().equals("user")) continue;
                users = MUCLightBlockingIQProvider.parseBlocking(parser, users);
                continue;
            }
            if (eventType == XmlPullParser.Event.END_ELEMENT && parser.getDepth() == initialDepth) break;
        }
        MUCLightBlockingIQ mucLightBlockingIQ = new MUCLightBlockingIQ(rooms, users);
        mucLightBlockingIQ.setType(IQ.Type.result);
        return mucLightBlockingIQ;
    }

    private static HashMap<Jid, Boolean> parseBlocking(XmlPullParser parser, HashMap<Jid, Boolean> map) throws XmppStringprepException, XmlPullParserException, IOException {
        String action;
        if (map == null) {
            map = new HashMap();
        }
        if ((action = parser.getAttributeValue("", "action")).equals("deny")) {
            map.put(JidCreate.from((String)parser.nextText()), false);
        } else if (action.equals("allow")) {
            map.put(JidCreate.from((String)parser.nextText()), true);
        }
        return map;
    }
}

