/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.OpenPgpMetadata;

public final class EncryptionStream
extends OutputStream {
    private static final Logger LOGGER = Logger.getLogger(EncryptionStream.class.getName());
    private static final Level LEVEL = Level.FINE;
    private static final int BUFFER_SIZE = 256;
    private final OpenPgpMetadata result;
    private List<PGPSignatureGenerator> signatureGenerators = new ArrayList<PGPSignatureGenerator>();
    private boolean closed = false;
    private ArmoredOutputStream armorOutputStream = null;
    private OutputStream publicKeyEncryptedStream = null;
    private PGPCompressedDataGenerator compressedDataGenerator;
    private BCPGOutputStream basicCompressionStream;
    private PGPLiteralDataGenerator literalDataGenerator;
    private OutputStream literalDataStream;

    EncryptionStream(@Nonnull OutputStream targetOutputStream, @Nonnull Set<PGPPublicKey> encryptionKeys, @Nonnull Set<PGPPrivateKey> signingKeys, @Nonnull SymmetricKeyAlgorithm symmetricKeyAlgorithm, @Nonnull HashAlgorithm hashAlgorithm, @Nonnull CompressionAlgorithm compressionAlgorithm, boolean asciiArmor) throws IOException, PGPException {
        OutputStream outerMostStream;
        if (asciiArmor) {
            LOGGER.log(LEVEL, "Wrap encryption output in ASCII armor");
            this.armorOutputStream = new ArmoredOutputStream(targetOutputStream);
            outerMostStream = this.armorOutputStream;
        } else {
            LOGGER.log(LEVEL, "Encryption output will be binary");
            outerMostStream = targetOutputStream;
        }
        if (!encryptionKeys.isEmpty()) {
            LOGGER.log(LEVEL, "At least one encryption key is available -> encrypt using " + (Object)((Object)symmetricKeyAlgorithm));
            BcPGPDataEncryptorBuilder dataEncryptorBuilder = new BcPGPDataEncryptorBuilder(symmetricKeyAlgorithm.getAlgorithmId());
            LOGGER.log(LEVEL, "Integrity protection enabled");
            dataEncryptorBuilder.setWithIntegrityPacket(true);
            PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)dataEncryptorBuilder);
            for (PGPPublicKey key : encryptionKeys) {
                LOGGER.log(LEVEL, "Encrypt for key " + Long.toHexString(key.getKeyID()));
                pGPEncryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)new BcPublicKeyKeyEncryptionMethodGenerator(key));
            }
            outerMostStream = this.publicKeyEncryptedStream = pGPEncryptedDataGenerator.open(outerMostStream, new byte[256]);
        }
        if (!signingKeys.isEmpty()) {
            LOGGER.log(LEVEL, "At least one signing key is available -> sign " + (Object)((Object)hashAlgorithm) + " hash of message");
            for (PGPPrivateKey pGPPrivateKey : signingKeys) {
                LOGGER.log(LEVEL, "Sign using key " + Long.toHexString(pGPPrivateKey.getKeyID()));
                BcPGPContentSignerBuilder contentSignerBuilder = new BcPGPContentSignerBuilder(pGPPrivateKey.getPublicKeyPacket().getAlgorithm(), hashAlgorithm.getAlgorithmId());
                PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)contentSignerBuilder);
                signatureGenerator.init(0, pGPPrivateKey);
                this.signatureGenerators.add(signatureGenerator);
            }
        }
        LOGGER.log(LEVEL, "Compress using " + (Object)((Object)compressionAlgorithm));
        this.compressedDataGenerator = new PGPCompressedDataGenerator(compressionAlgorithm.getAlgorithmId());
        this.basicCompressionStream = new BCPGOutputStream(this.compressedDataGenerator.open(outerMostStream));
        for (PGPSignatureGenerator pGPSignatureGenerator : this.signatureGenerators) {
            pGPSignatureGenerator.generateOnePassVersion(false).encode((OutputStream)this.basicCompressionStream);
        }
        this.literalDataGenerator = new PGPLiteralDataGenerator();
        this.literalDataStream = this.literalDataGenerator.open((OutputStream)this.basicCompressionStream, 'b', "_CONSOLE", new Date(), new byte[256]);
        HashSet<Long> recipientKeyIds = new HashSet<Long>();
        for (PGPPublicKey recipient : encryptionKeys) {
            recipientKeyIds.add(recipient.getKeyID());
        }
        HashSet<Long> hashSet = new HashSet<Long>();
        for (PGPPrivateKey signer : signingKeys) {
            hashSet.add(signer.getKeyID());
        }
        this.result = new OpenPgpMetadata(recipientKeyIds, null, symmetricKeyAlgorithm, compressionAlgorithm, true, hashSet, Collections.emptySet());
    }

    @Override
    public void write(int data) throws IOException {
        this.literalDataStream.write(data);
        for (PGPSignatureGenerator signatureGenerator : this.signatureGenerators) {
            byte asByte = (byte)(data & 0xFF);
            signatureGenerator.update(asByte);
        }
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int off, int len) throws IOException {
        this.literalDataStream.write(buffer, 0, len);
        for (PGPSignatureGenerator signatureGenerator : this.signatureGenerators) {
            signatureGenerator.update(buffer, 0, len);
        }
    }

    @Override
    public void flush() throws IOException {
        this.literalDataStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.literalDataStream.flush();
            this.literalDataStream.close();
            this.literalDataGenerator.close();
            for (PGPSignatureGenerator signatureGenerator : this.signatureGenerators) {
                try {
                    signatureGenerator.generate().encode((OutputStream)this.basicCompressionStream);
                }
                catch (PGPException e) {
                    throw new IOException(e);
                }
            }
            this.compressedDataGenerator.close();
            if (this.publicKeyEncryptedStream != null) {
                this.publicKeyEncryptedStream.flush();
                this.publicKeyEncryptedStream.close();
            }
            if (this.armorOutputStream != null) {
                this.armorOutputStream.flush();
                this.armorOutputStream.close();
            }
            this.closed = true;
        }
    }

    public OpenPgpMetadata getResult() {
        return this.result;
    }
}

