/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.collection;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.pgpainless.key.OpenPgpV4Fingerprint;

public class PGPKeyRing {
    private PGPPublicKeyRing publicKeys;
    private PGPSecretKeyRing secretKeys;

    public PGPKeyRing(@Nonnull PGPPublicKeyRing publicKeys, @Nonnull PGPSecretKeyRing secretKeys) {
        if (publicKeys.getPublicKey().getKeyID() != secretKeys.getPublicKey().getKeyID()) {
            throw new IllegalArgumentException("publicKeys and secretKeys must have the same master key.");
        }
        this.publicKeys = publicKeys;
        this.secretKeys = secretKeys;
    }

    public PGPKeyRing(@Nonnull PGPPublicKeyRing publicKeys) {
        this.publicKeys = publicKeys;
    }

    public PGPKeyRing(@Nonnull PGPSecretKeyRing secretKeys) {
        this.secretKeys = secretKeys;
    }

    public long getKeyId() {
        return this.getMasterKey().getKeyID();
    }

    @Nonnull
    public PGPPublicKey getMasterKey() {
        PGPPublicKey publicKey;
        PGPPublicKey pGPPublicKey = publicKey = this.hasSecretKeys() ? this.secretKeys.getPublicKey() : this.publicKeys.getPublicKey();
        if (!publicKey.isMasterKey()) {
            throw new IllegalStateException("Expected master key is not a master key");
        }
        return publicKey;
    }

    @Nonnull
    public OpenPgpV4Fingerprint getV4Fingerprint() {
        return new OpenPgpV4Fingerprint(this.getMasterKey());
    }

    public boolean hasSecretKeys() {
        return this.secretKeys != null;
    }

    @Nullable
    public PGPPublicKeyRing getPublicKeys() {
        return this.publicKeys;
    }

    @Nullable
    public PGPSecretKeyRing getSecretKeys() {
        return this.secretKeys;
    }
}

