/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyPassphraseProvider;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.util.Passphrase;

public class PassphraseMapKeyRingProtector
implements SecretKeyRingProtector,
SecretKeyPassphraseProvider {
    private final Map<Long, Passphrase> cache = new HashMap<Long, Passphrase>();
    private final SecretKeyRingProtector protector;
    private final SecretKeyPassphraseProvider provider;

    public PassphraseMapKeyRingProtector(@Nonnull Map<Long, Passphrase> passphrases, @Nonnull KeyRingProtectionSettings protectionSettings, @Nullable SecretKeyPassphraseProvider missingPassphraseCallback) {
        this.cache.putAll(passphrases);
        this.protector = new PasswordBasedSecretKeyRingProtector(protectionSettings, this);
        this.provider = missingPassphraseCallback;
    }

    public void addPassphrase(@Nonnull Long keyId, @Nullable Passphrase passphrase) {
        this.cache.put(keyId, passphrase);
    }

    public void forgetPassphrase(@Nonnull Long keyId) {
        Passphrase passphrase = this.cache.get(keyId);
        passphrase.clear();
        this.cache.remove(keyId);
    }

    @Override
    @Nullable
    public Passphrase getPassphraseFor(@Nonnull Long keyId) {
        Passphrase passphrase = this.cache.get(keyId);
        if (!(passphrase != null && passphrase.isValid() || (passphrase = this.provider.getPassphraseFor(keyId)) == null)) {
            this.cache.put(keyId, passphrase);
        }
        return passphrase;
    }

    @Override
    @Nullable
    public PBESecretKeyDecryptor getDecryptor(@Nonnull Long keyId) {
        return this.protector.getDecryptor(keyId);
    }

    @Override
    @Nullable
    public PBESecretKeyEncryptor getEncryptor(@Nonnull Long keyId) throws PGPException {
        return this.protector.getEncryptor(keyId);
    }
}

