/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mood;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jivesoftware.smack.AsyncButOrdered;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.mood.Mood;
import org.jivesoftware.smackx.mood.MoodListener;
import org.jivesoftware.smackx.mood.element.MoodConcretisation;
import org.jivesoftware.smackx.mood.element.MoodElement;
import org.jivesoftware.smackx.pep.PepListener;
import org.jivesoftware.smackx.pep.PepManager;
import org.jivesoftware.smackx.pubsub.EventElement;
import org.jivesoftware.smackx.pubsub.ItemsExtension;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.EntityBareJid;

public final class MoodManager
extends Manager {
    public static final String MOOD_NODE = "http://jabber.org/protocol/mood";
    public static final String MOOD_NOTIFY = "http://jabber.org/protocol/mood+notify";
    private static final Map<XMPPConnection, MoodManager> INSTANCES = new WeakHashMap<XMPPConnection, MoodManager>();
    private final Set<MoodListener> moodListeners = new HashSet<MoodListener>();
    private final AsyncButOrdered<BareJid> asyncButOrdered = new AsyncButOrdered();
    private PubSubManager pubSubManager;

    private MoodManager(XMPPConnection connection) {
        super(connection);
        ServiceDiscoveryManager.getInstanceFor(connection).addFeature(MOOD_NOTIFY);
        PepManager.getInstanceFor(connection).addPepListener(new PepListener(){

            @Override
            public void eventReceived(EntityBareJid from, final EventElement event, final Message message) {
                if (!MoodManager.MOOD_NODE.equals(event.getEvent().getNode())) {
                    return;
                }
                final BareJid contact = from.asBareJid();
                MoodManager.this.asyncButOrdered.performAsyncButOrdered((Object)contact, new Runnable(){

                    @Override
                    public void run() {
                        ItemsExtension items = (ItemsExtension)event.getExtensions().get(0);
                        PayloadItem payload = (PayloadItem)items.getItems().get(0);
                        MoodElement mood = (MoodElement)payload.getPayload();
                        for (MoodListener listener : MoodManager.this.moodListeners) {
                            listener.onMoodUpdated(contact, message, mood);
                        }
                    }
                });
            }
        });
    }

    public static synchronized MoodManager getInstanceFor(XMPPConnection connection) {
        MoodManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new MoodManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    public void setMood(Mood mood) throws InterruptedException, SmackException.NotLoggedInException, SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException {
        this.setMood(mood, null, null);
    }

    public void setMood(Mood mood, String text) throws InterruptedException, SmackException.NotLoggedInException, SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException {
        this.setMood(mood, null, text);
    }

    public void setMood(Mood mood, MoodConcretisation concretisation) throws InterruptedException, SmackException.NotLoggedInException, SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException {
        this.setMood(mood, concretisation, null);
    }

    public void setMood(Mood mood, MoodConcretisation concretisation, String text) throws InterruptedException, SmackException.NotLoggedInException, SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException {
        MoodElement element = MoodManager.buildMood(mood, concretisation, text);
        this.publishMood(element);
    }

    public void clearMood() throws InterruptedException, SmackException.NotLoggedInException, SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException {
        MoodElement element = MoodManager.buildMood(null, null, null);
        this.publishMood(element);
    }

    private void publishMood(MoodElement moodElement) throws SmackException.NotLoggedInException, InterruptedException, PubSubException.NotALeafNodeException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException {
        if (this.pubSubManager == null) {
            this.pubSubManager = PubSubManager.getInstanceFor(this.getAuthenticatedConnectionOrThrow(), this.connection().getUser().asBareJid());
        }
        LeafNode node = this.pubSubManager.getOrCreateLeafNode(MOOD_NODE);
        node.publish(new PayloadItem<MoodElement>(moodElement));
    }

    private static MoodElement buildMood(Mood mood, MoodConcretisation concretisation, String text) {
        return new MoodElement(new MoodElement.MoodSubjectElement(mood, concretisation), text);
    }

    public static void addMoodToMessage(Message message, Mood mood) {
        MoodManager.addMoodToMessage(message, mood, null);
    }

    public static void addMoodToMessage(Message message, Mood mood, MoodConcretisation concretisation) {
        MoodElement element = MoodManager.buildMood(mood, concretisation, null);
        message.addExtension((ExtensionElement)element);
    }

    public synchronized void addMoodListener(MoodListener listener) {
        this.moodListeners.add(listener);
    }

    public synchronized void removeMoodListener(MoodListener listener) {
        this.moodListeners.remove(listener);
    }
}

