/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.search;

import java.io.IOException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.SimpleIQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.search.ReportedData;
import org.jivesoftware.smackx.search.SimpleUserSearch;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.Jid;

public class UserSearch
extends SimpleIQ {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "jabber:iq:search";

    public UserSearch() {
        super(ELEMENT, NAMESPACE);
    }

    public Form getSearchForm(XMPPConnection con, DomainBareJid searchService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        UserSearch search = new UserSearch();
        search.setType(IQ.Type.get);
        search.setTo((Jid)searchService);
        IQ response = (IQ)con.createStanzaCollectorAndSend((IQ)search).nextResultOrThrow();
        return Form.getFormFrom((Stanza)response);
    }

    public ReportedData sendSearchForm(XMPPConnection con, Form searchForm, DomainBareJid searchService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        UserSearch search = new UserSearch();
        search.setType(IQ.Type.set);
        search.setTo((Jid)searchService);
        search.addExtension(searchForm.getDataFormToSend());
        IQ response = (IQ)con.createStanzaCollectorAndSend((IQ)search).nextResultOrThrow();
        return ReportedData.getReportedDataFrom((Stanza)response);
    }

    public ReportedData sendSimpleSearchForm(XMPPConnection con, Form searchForm, DomainBareJid searchService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        SimpleUserSearch search = new SimpleUserSearch();
        search.setForm(searchForm);
        search.setType(IQ.Type.set);
        search.setTo((Jid)searchService);
        SimpleUserSearch response = (SimpleUserSearch)con.createStanzaCollectorAndSend((IQ)search).nextResultOrThrow();
        return response.getReportedData();
    }

    private static void buildDataForm(SimpleUserSearch search, String instructions, XmlPullParser parser, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        DataForm dataForm = new DataForm(DataForm.Type.form);
        boolean done = false;
        dataForm.setTitle("User Search");
        dataForm.addInstruction(instructions);
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT && !parser.getNamespace().equals("jabber:x:data")) {
                String name = parser.getName();
                FormField.Builder field = FormField.builder(name);
                if (name.equals("first")) {
                    field.setLabel("First Name");
                } else if (name.equals("last")) {
                    field.setLabel("Last Name");
                } else if (name.equals("email")) {
                    field.setLabel("Email Address");
                } else if (name.equals("nick")) {
                    field.setLabel("Nickname");
                }
                field.setType(FormField.Type.text_single);
                dataForm.addField(field.build());
                continue;
            }
            if (eventType == XmlPullParser.Event.END_ELEMENT) {
                if (!parser.getName().equals(ELEMENT)) continue;
                done = true;
                continue;
            }
            if (eventType != XmlPullParser.Event.START_ELEMENT || !parser.getNamespace().equals("jabber:x:data")) continue;
            PacketParserUtils.addExtensionElement((Stanza)search, (XmlPullParser)parser, (XmlEnvironment)xmlEnvironment);
            done = true;
        }
        if (search.getExtension("x", "jabber:x:data") == null) {
            search.addExtension(dataForm);
        }
    }

    public static class Provider
    extends IQProvider<IQ> {
        public IQ parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
            UserSearch search = null;
            SimpleUserSearch simpleUserSearch = new SimpleUserSearch();
            boolean done = false;
            while (!done) {
                XmlPullParser.Event eventType = parser.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT && parser.getName().equals("instructions")) {
                    UserSearch.buildDataForm(simpleUserSearch, parser.nextText(), parser, xmlEnvironment);
                    return simpleUserSearch;
                }
                if (eventType == XmlPullParser.Event.START_ELEMENT && parser.getName().equals("item")) {
                    simpleUserSearch.parseItems(parser);
                    return simpleUserSearch;
                }
                if (eventType == XmlPullParser.Event.START_ELEMENT && parser.getNamespace().equals("jabber:x:data")) {
                    search = new UserSearch();
                    PacketParserUtils.addExtensionElement((Stanza)search, (XmlPullParser)parser, (XmlEnvironment)xmlEnvironment);
                    continue;
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals(UserSearch.ELEMENT)) continue;
                done = true;
            }
            if (search != null) {
                return search;
            }
            return simpleUserSearch;
        }
    }
}

