/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.igniterealtime.smack.inttest.AbstractSmackIntTest;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.AbstractSmackLowLevelIntegrationTest;
import org.igniterealtime.smack.inttest.AbstractSmackSpecificLowLevelIntegrationTest;
import org.igniterealtime.smack.inttest.Configuration;
import org.igniterealtime.smack.inttest.FailedTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.SuccessfulTest;
import org.igniterealtime.smack.inttest.TestNotPossible;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.XmppConnectionManager;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.debugger.EnhancedDebuggerWindow;
import org.jivesoftware.smackx.iqregister.AccountManager;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.MethodParameterScanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;

public class SmackIntegrationTestFramework<DC extends AbstractXMPPConnection> {
    private static final Logger LOGGER = Logger.getLogger(SmackIntegrationTestFramework.class.getName());
    public static boolean SINTTEST_UNIT_TEST = false;
    private final Class<DC> defaultConnectionClass;
    protected final Configuration config;
    protected TestRunResult testRunResult;
    private SmackIntegrationTestEnvironment<DC> environment;
    protected XmppConnectionManager<DC> connectionManager;

    public static void main(String[] args) throws IOException, KeyManagementException, NoSuchAlgorithmException, SmackException, XMPPException, InterruptedException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        int exitStatus;
        Configuration config = Configuration.newConfiguration(args);
        SmackIntegrationTestFramework<XMPPTCPConnection> sinttest = new SmackIntegrationTestFramework<XMPPTCPConnection>(config, XMPPTCPConnection.class);
        TestRunResult testRunResult = sinttest.run();
        for (Map.Entry entry : testRunResult.impossibleTestClasses.entrySet()) {
            LOGGER.info("Could not run " + ((Class)entry.getKey()).getName() + " because: " + ((Throwable)entry.getValue()).getLocalizedMessage());
        }
        for (TestNotPossible testNotPossible : testRunResult.impossibleIntegrationTests) {
            LOGGER.info("Could not run " + testNotPossible.concreteTest + " because: " + testNotPossible.testNotPossibleException.getMessage());
        }
        for (SuccessfulTest successfulTest : testRunResult.successfulIntegrationTests) {
            LOGGER.info(successfulTest.concreteTest + " \u2714");
        }
        int successfulTests = testRunResult.successfulIntegrationTests.size();
        int failedTests = testRunResult.failedIntegrationTests.size();
        int totalIntegrationTests = successfulTests + failedTests;
        int availableTests = testRunResult.getNumberOfAvailableTests();
        int possibleTests = testRunResult.getNumberOfPossibleTests();
        LOGGER.info("SmackIntegrationTestFramework[" + testRunResult.testRunId + ']' + ": Finished [" + successfulTests + '/' + totalIntegrationTests + "] (" + possibleTests + " test methods of " + availableTests + " where possible)");
        if (failedTests > 0) {
            LOGGER.warning("\ud83d\udc80 The following " + failedTests + " tests failed! \ud83d\udc80");
            for (FailedTest failedTest : testRunResult.failedIntegrationTests) {
                Throwable cause = failedTest.failureReason;
                LOGGER.log(Level.SEVERE, failedTest.concreteTest + " failed: " + cause, cause);
            }
            exitStatus = 2;
        } else {
            LOGGER.info("All possible Smack Integration Tests completed successfully. \\o/");
            exitStatus = 0;
        }
        switch (config.debugger) {
            case enhanced: {
                EnhancedDebuggerWindow.getInstance().waitUntilClosed();
                break;
            }
        }
        System.exit(exitStatus);
    }

    public SmackIntegrationTestFramework(Configuration configuration, Class<DC> defaultConnectionClass) throws KeyManagementException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchAlgorithmException, SmackException, IOException, XMPPException, InterruptedException {
        this.config = configuration;
        this.defaultConnectionClass = defaultConnectionClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TestRunResult run() throws KeyManagementException, NoSuchAlgorithmException, SmackException, IOException, XMPPException, InterruptedException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.testRunResult = new TestRunResult();
        this.connectionManager = new XmppConnectionManager<DC>(this, this.defaultConnectionClass);
        LOGGER.info("SmackIntegrationTestFramework [" + this.testRunResult.testRunId + ']' + ": Starting");
        if (this.config.debugger != Configuration.Debugger.none) {
            SmackConfiguration.addDisabledSmackClass((String)"org.jivesoftware.smack.debugger.JulDebugger");
            SmackConfiguration.DEBUG = true;
        }
        if (this.config.replyTimeout > 0) {
            SmackConfiguration.setDefaultReplyTimeout((int)this.config.replyTimeout);
        }
        if (this.config.securityMode != ConnectionConfiguration.SecurityMode.required && this.config.accountRegistration == Configuration.AccountRegistration.inBandRegistration) {
            AccountManager.sensitiveOperationOverInsecureConnectionDefault((boolean)true);
        }
        String[] testPackages = this.config.testPackages == null || this.config.testPackages.isEmpty() ? new String[]{"org.jivesoftware.smackx", "org.jivesoftware.smack"} : this.config.testPackages.toArray(new String[this.config.testPackages.size()]);
        Reflections reflections = new Reflections(new Object[]{testPackages, new SubTypesScanner(), new TypeAnnotationsScanner(), new MethodAnnotationsScanner(), new MethodParameterScanner()});
        Set inttestClasses = reflections.getSubTypesOf(AbstractSmackIntegrationTest.class);
        Set lowLevelInttestClasses = reflections.getSubTypesOf(AbstractSmackLowLevelIntegrationTest.class);
        HashSet<Class<? extends AbstractSmackIntTest>> classes = new HashSet<Class<? extends AbstractSmackIntTest>>(inttestClasses.size() + lowLevelInttestClasses.size());
        classes.addAll(inttestClasses);
        classes.addAll(lowLevelInttestClasses);
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            Class clazz = (Class)it.next();
            if (!Modifier.isAbstract(clazz.getModifiers())) continue;
            it.remove();
        }
        if (classes.isEmpty()) {
            throw new IllegalStateException("No test classes found");
        }
        LOGGER.info("SmackIntegrationTestFramework [" + this.testRunResult.testRunId + "]: Finished scanning for tests, preparing environment");
        this.environment = this.prepareEnvironment();
        try {
            this.runTests(classes);
        }
        finally {
            this.connectionManager.disconnectAndCleanup();
        }
        return this.testRunResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTests(Set<Class<? extends AbstractSmackIntTest>> classes) throws InterruptedException, InstantiationException, IllegalAccessException, IllegalArgumentException, SmackException, IOException, XMPPException {
        for (Class<? extends AbstractSmackIntTest> testClass : classes) {
            TestType testType;
            AbstractSmackIntTest test;
            Constructor<? extends AbstractSmackIntTest> cons;
            String testClassName = testClass.getName();
            if (!SINTTEST_UNIT_TEST && testClassName.startsWith("org.igniterealtime.smack.inttest.unittest")) {
                LOGGER.finer("Skipping integration test '" + testClassName + "' from src/test classpath");
                continue;
            }
            if (this.config.enabledTests != null && !SmackIntegrationTestFramework.isInSet(testClass, this.config.enabledTests)) {
                LOGGER.info("Skipping test class " + testClassName + " because it is not enabled");
                continue;
            }
            if (SmackIntegrationTestFramework.isInSet(testClass, this.config.disabledTests)) {
                LOGGER.info("Skipping test class " + testClassName + " because it is disalbed");
                continue;
            }
            try {
                cons = testClass.getConstructor(SmackIntegrationTestEnvironment.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new IllegalArgumentException("Smack Integration Test class does not declare the correct constructor. Is a public Constructor(SmackIntegrationTestEnvironment) missing?", e);
            }
            Method[] testClassMethods = testClass.getMethods();
            ArrayList<Method> smackIntegrationTestMethods = new ArrayList<Method>(testClassMethods.length);
            for (Method method : testClassMethods) {
                if (!method.isAnnotationPresent(SmackIntegrationTest.class)) continue;
                smackIntegrationTestMethods.add(method);
            }
            if (smackIntegrationTestMethods.isEmpty()) {
                LOGGER.warning("No Smack integration test methods found in " + testClass);
                continue;
            }
            this.testRunResult.numberOfAvailableTestMethods.addAndGet(smackIntegrationTestMethods.size());
            try {
                test = cons.newInstance(this.environment);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                SmackIntegrationTestFramework.throwFatalException(cause);
                this.testRunResult.impossibleTestClasses.put(testClass, cause);
                continue;
            }
            Class specificLowLevelConnectionClass = null;
            if (test instanceof AbstractSmackSpecificLowLevelIntegrationTest) {
                AbstractSmackSpecificLowLevelIntegrationTest specificLowLevelTest = (AbstractSmackSpecificLowLevelIntegrationTest)test;
                specificLowLevelConnectionClass = specificLowLevelTest.getConnectionClass();
                testType = TestType.SpecificLowLevel;
            } else if (test instanceof AbstractSmackLowLevelIntegrationTest) {
                testType = TestType.LowLevel;
            } else if (test instanceof AbstractSmackIntegrationTest) {
                testType = TestType.Normal;
            } else {
                throw new AssertionError();
            }
            for (Method method : smackIntegrationTestMethods) {
                Class<?> retClass = method.getReturnType();
                if (!retClass.equals(Void.TYPE)) {
                    throw new IllegalStateException("SmackIntegrationTest annotation on" + method + " that does not return void");
                }
                switch (testType) {
                    case Normal: {
                        Class<?>[] parameterTypes = method.getParameterTypes();
                        if (parameterTypes.length <= 0) break;
                        throw new IllegalStateException("SmackIntegrationTest annotaton on " + method + " that takes arguments ");
                    }
                    case LowLevel: {
                        SmackIntegrationTestFramework.verifyLowLevelTestMethod(method, AbstractXMPPConnection.class);
                        break;
                    }
                    case SpecificLowLevel: {
                        SmackIntegrationTestFramework.verifyLowLevelTestMethod(method, specificLowLevelConnectionClass);
                    }
                }
            }
            Iterator it = smackIntegrationTestMethods.iterator();
            while (it.hasNext()) {
                Method method;
                method = (Method)it.next();
                String methodName = method.getName();
                if (this.config.enabledTests != null && !this.config.enabledTests.contains(methodName) && !SmackIntegrationTestFramework.isInSet(testClass, this.config.enabledTests)) {
                    LOGGER.fine("Skipping test method " + methodName + " because it is not enabled");
                    it.remove();
                    continue;
                }
                if (this.config.disabledTests == null || !this.config.disabledTests.contains(methodName)) continue;
                LOGGER.info("Skipping test method " + methodName + " because it is disabled");
                it.remove();
            }
            if (smackIntegrationTestMethods.isEmpty()) {
                LOGGER.info("All tests in " + testClassName + " are disabled");
                continue;
            }
            int detectedTestMethodsCount = smackIntegrationTestMethods.size();
            this.testRunResult.numberOfPossibleTestMethods.addAndGet(detectedTestMethodsCount);
            try {
                Set beforeClassMethods = ReflectionUtils.getAllMethods(testClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(BeforeClass.class), ReflectionUtils.withReturnType(Void.TYPE), ReflectionUtils.withParametersCount((int)0), ReflectionUtils.withModifier((int)1)});
                Set allBeforeClassMethods = ReflectionUtils.getAllMethods(testClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(BeforeClass.class)});
                allBeforeClassMethods.removeAll(beforeClassMethods);
                if (!allBeforeClassMethods.isEmpty()) {
                    throw new IllegalArgumentException("@BeforeClass methods with wrong signature found");
                }
                if (beforeClassMethods.size() == 1) {
                    Method beforeClassMethod = (Method)beforeClassMethods.iterator().next();
                    LOGGER.info("Executing @BeforeClass method of " + testClass);
                    try {
                        beforeClassMethod.invoke((Object)test, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        LOGGER.log(Level.SEVERE, "Exception executing @BeforeClass method", e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new AssertionError((Object)e);
                    }
                } else if (beforeClassMethods.size() > 1) {
                    throw new IllegalArgumentException("Only one @BeforeClass method allowed");
                }
                for (Method testMethod : smackIntegrationTestMethods) {
                    List<ConcreteTest> concreteTests = null;
                    block11 : switch (testType) {
                        case Normal: {
                            ConcreteTest.Executor concreteTestExecutor = () -> testMethod.invoke((Object)test, new Object[0]);
                            ConcreteTest concreteTest = new ConcreteTest(testType, testMethod, concreteTestExecutor, new String[0]);
                            concreteTests = Collections.singletonList(concreteTest);
                            break;
                        }
                        case LowLevel: 
                        case SpecificLowLevel: {
                            LowLevelTestMethod lowLevelTestMethod = new LowLevelTestMethod(testMethod);
                            switch (testType) {
                                case LowLevel: {
                                    concreteTests = this.invokeLowLevel(lowLevelTestMethod, (AbstractSmackLowLevelIntegrationTest)test);
                                    break block11;
                                }
                                case SpecificLowLevel: {
                                    ConcreteTest.Executor concreteTestExecutor = () -> this.invokeSpecificLowLevel(lowLevelTestMethod, (AbstractSmackSpecificLowLevelIntegrationTest)test);
                                    ConcreteTest concreteTest = new ConcreteTest(testType, testMethod, concreteTestExecutor, new String[0]);
                                    concreteTests = Collections.singletonList(concreteTest);
                                    break block11;
                                }
                            }
                            throw new AssertionError();
                        }
                    }
                    for (ConcreteTest concreteTest : concreteTests) {
                        this.runConcreteTest(concreteTest);
                    }
                }
            }
            catch (Throwable throwable) {
                Set afterClassMethods = ReflectionUtils.getAllMethods(testClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(AfterClass.class), ReflectionUtils.withReturnType(Void.TYPE), ReflectionUtils.withParametersCount((int)0), ReflectionUtils.withModifier((int)1)});
                Set allAfterClassMethods = ReflectionUtils.getAllMethods(testClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(AfterClass.class)});
                allAfterClassMethods.removeAll(afterClassMethods);
                if (!allAfterClassMethods.isEmpty()) {
                    throw new IllegalArgumentException("@AfterClass methods with wrong signature found");
                }
                if (afterClassMethods.size() == 1) {
                    Method afterClassMethod = (Method)afterClassMethods.iterator().next();
                    LOGGER.info("Executing @AfterClass method of " + testClass);
                    try {
                        afterClassMethod.invoke((Object)test, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        LOGGER.log(Level.SEVERE, "Exception executing @AfterClass method", e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new AssertionError((Object)e);
                    }
                } else if (afterClassMethods.size() > 1) {
                    throw new IllegalArgumentException("Only one @AfterClass method allowed");
                }
                throw throwable;
            }
            Set afterClassMethods = ReflectionUtils.getAllMethods(testClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(AfterClass.class), ReflectionUtils.withReturnType(Void.TYPE), ReflectionUtils.withParametersCount((int)0), ReflectionUtils.withModifier((int)1)});
            Set allAfterClassMethods = ReflectionUtils.getAllMethods(testClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(AfterClass.class)});
            allAfterClassMethods.removeAll(afterClassMethods);
            if (!allAfterClassMethods.isEmpty()) {
                throw new IllegalArgumentException("@AfterClass methods with wrong signature found");
            }
            if (afterClassMethods.size() == 1) {
                Method afterClassMethod = (Method)afterClassMethods.iterator().next();
                LOGGER.info("Executing @AfterClass method of " + testClass);
                try {
                    afterClassMethod.invoke((Object)test, new Object[0]);
                    continue;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOGGER.log(Level.SEVERE, "Exception executing @AfterClass method", e);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (afterClassMethods.size() <= 1) continue;
            throw new IllegalArgumentException("Only one @AfterClass method allowed");
        }
    }

    private void runConcreteTest(ConcreteTest concreteTest) throws InterruptedException, XMPPException, IOException, SmackException {
        LOGGER.info(concreteTest + " Start");
        long testStart = System.currentTimeMillis();
        try {
            concreteTest.executor.execute();
            long testEnd = System.currentTimeMillis();
            LOGGER.info(concreteTest + " Success");
            this.testRunResult.successfulIntegrationTests.add(new SuccessfulTest(concreteTest, testStart, testEnd, null));
        }
        catch (InvocationTargetException e) {
            long testEnd = System.currentTimeMillis();
            Throwable cause = e.getCause();
            if (cause instanceof TestNotPossibleException) {
                LOGGER.info(concreteTest + " is not possible");
                this.testRunResult.impossibleIntegrationTests.add(new TestNotPossible(concreteTest, testStart, testEnd, null, (TestNotPossibleException)cause));
                return;
            }
            Throwable nonFatalFailureReason = cause instanceof AssertionError ? cause : SmackIntegrationTestFramework.throwFatalException(cause);
            this.testRunResult.failedIntegrationTests.add(new FailedTest(concreteTest, testStart, testEnd, null, nonFatalFailureReason));
            LOGGER.log(Level.SEVERE, concreteTest + " Failed", e);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void verifyLowLevelTestMethod(Method method, Class<? extends AbstractXMPPConnection> connectionClass) {
        if (!SmackIntegrationTestFramework.testMethodParametersIsListOfConnections(method, connectionClass) && !SmackIntegrationTestFramework.testMethodParametersVarargsConnections(method, connectionClass)) {
            throw new IllegalArgumentException(method + " is not a valid low level test method");
        }
    }

    private List<ConcreteTest> invokeLowLevel(LowLevelTestMethod lowLevelTestMethod, AbstractSmackLowLevelIntegrationTest test) {
        Set<Class<AbstractXMPPConnection>> connectionClasses;
        if (lowLevelTestMethod.smackIntegrationTestAnnotation.onlyDefaultConnectionType()) {
            Class<AbstractXMPPConnection> defaultConnectionClass = this.connectionManager.getDefaultConnectionClass();
            connectionClasses = Collections.singleton(defaultConnectionClass);
        } else {
            connectionClasses = this.connectionManager.getConnectionClasses();
        }
        ArrayList<ConcreteTest> resultingConcreteTests = new ArrayList<ConcreteTest>(connectionClasses.size());
        for (Class<AbstractXMPPConnection> connectionClass : connectionClasses) {
            ConcreteTest.Executor executor = () -> lowLevelTestMethod.invoke(test, connectionClass);
            ConcreteTest concreteTest = new ConcreteTest(TestType.LowLevel, lowLevelTestMethod.testMethod, executor, new String[]{connectionClass.getSimpleName()});
            resultingConcreteTests.add(concreteTest);
        }
        return resultingConcreteTests;
    }

    private <C extends AbstractXMPPConnection> void invokeSpecificLowLevel(LowLevelTestMethod testMethod, AbstractSmackSpecificLowLevelIntegrationTest<C> test) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InterruptedException, SmackException, IOException, XMPPException {
        if (testMethod.smackIntegrationTestAnnotation.onlyDefaultConnectionType()) {
            throw new IllegalArgumentException("SpecificLowLevelTests must not have set onlyDefaultConnectionType");
        }
        Class<C> connectionClass = test.getConnectionClass();
        testMethod.invoke(test, connectionClass);
    }

    protected SmackIntegrationTestEnvironment<DC> prepareEnvironment() throws SmackException, IOException, XMPPException, InterruptedException, KeyManagementException, NoSuchAlgorithmException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.connectionManager.prepareEnvironment();
    }

    static XMPPTCPConnectionConfiguration.Builder getConnectionConfigurationBuilder(Configuration config) {
        XMPPTCPConnectionConfiguration.Builder builder = XMPPTCPConnectionConfiguration.builder();
        config.configurationApplier.applyConfigurationTo((ConnectionConfiguration.Builder<?, ?>)builder);
        return builder;
    }

    private static Exception throwFatalException(Throwable e) throws Error, SmackException.NoResponseException, InterruptedException {
        if (e instanceof SmackException.NoResponseException) {
            throw (SmackException.NoResponseException)e;
        }
        if (e instanceof InterruptedException) {
            throw (InterruptedException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        return (Exception)e;
    }

    private static boolean isInSet(Class<?> clz, Set<String> classes) {
        if (classes == null) {
            return false;
        }
        String className = clz.getName();
        String unqualifiedClassName = clz.getSimpleName();
        return classes.contains(className) || classes.contains(unqualifiedClassName);
    }

    private static boolean testMethodParametersIsListOfConnections(Method testMethod) {
        return SmackIntegrationTestFramework.testMethodParametersIsListOfConnections(testMethod, AbstractXMPPConnection.class);
    }

    static boolean testMethodParametersIsListOfConnections(Method testMethod, Class<? extends AbstractXMPPConnection> connectionClass) {
        Type[] parameterTypes = testMethod.getGenericParameterTypes();
        if (parameterTypes.length != 1) {
            return false;
        }
        Class<?> soleParameter = testMethod.getParameterTypes()[0];
        if (!Collection.class.isAssignableFrom(soleParameter)) {
            return false;
        }
        ParameterizedType soleParameterizedType = (ParameterizedType)parameterTypes[0];
        Type[] actualTypeArguments = soleParameterizedType.getActualTypeArguments();
        if (actualTypeArguments.length != 1) {
            return false;
        }
        Type soleActualTypeArgument = actualTypeArguments[0];
        if (!(soleActualTypeArgument instanceof Class)) {
            return false;
        }
        Class soleActualTypeArgumentAsClass = (Class)soleActualTypeArgument;
        return connectionClass.isAssignableFrom(soleActualTypeArgumentAsClass);
    }

    static boolean testMethodParametersVarargsConnections(Method testMethod, Class<? extends AbstractXMPPConnection> connectionClass) {
        Class<?>[] parameterTypes;
        for (Class<? extends AbstractXMPPConnection> clazz : parameterTypes = testMethod.getParameterTypes()) {
            if (clazz.isAssignableFrom(connectionClass)) continue;
            return false;
        }
        return true;
    }

    private final class LowLevelTestMethod {
        private final Method testMethod;
        private final SmackIntegrationTest smackIntegrationTestAnnotation;
        private final boolean parameterListOfConnections;

        private LowLevelTestMethod(Method testMethod) {
            this.testMethod = testMethod;
            this.smackIntegrationTestAnnotation = testMethod.getAnnotation(SmackIntegrationTest.class);
            assert (this.smackIntegrationTestAnnotation != null);
            this.parameterListOfConnections = SmackIntegrationTestFramework.testMethodParametersIsListOfConnections(testMethod);
        }

        private void invoke(AbstractSmackLowLevelIntegrationTest test, Class<? extends AbstractXMPPConnection> connectionClass) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InterruptedException, SmackException, IOException, XMPPException {
            int connectionCount;
            if (this.parameterListOfConnections) {
                connectionCount = this.smackIntegrationTestAnnotation.connectionCount();
                if (connectionCount < 1) {
                    throw new IllegalArgumentException(this.testMethod + " is annotated to use less than one connection ('" + connectionCount + ')');
                }
            } else {
                connectionCount = this.testMethod.getParameterCount();
            }
            List<? extends AbstractXMPPConnection> connections = SmackIntegrationTestFramework.this.connectionManager.constructConnectedConnections(connectionClass, connectionCount);
            if (this.parameterListOfConnections) {
                this.testMethod.invoke((Object)test, connections);
            } else {
                Object[] connectionsArray = new Object[connectionCount];
                for (int i = 0; i < connectionsArray.length; ++i) {
                    connectionsArray[i] = connections.remove(0);
                }
                this.testMethod.invoke((Object)test, connectionsArray);
            }
        }
    }

    static final class ConcreteTest {
        private final TestType testType;
        private final Method method;
        private final Executor executor;
        private final String[] subdescriptons;
        private transient String stringCache;

        private ConcreteTest(TestType testType, Method method, Executor executor, String ... subdescriptions) {
            this.testType = testType;
            this.method = method;
            this.executor = executor;
            this.subdescriptons = subdescriptions;
        }

        public String toString() {
            if (this.stringCache != null) {
                return this.stringCache;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.method.getDeclaringClass().getSimpleName()).append('.').append(this.method.getName()).append(" (").append(this.testType.name());
            String SUBDESCRIPTION_DELIMITER = ", ";
            sb.append(", ");
            for (String subdescripton : this.subdescriptons) {
                sb.append(subdescripton).append(", ");
            }
            sb.setLength(sb.length() - ", ".length());
            sb.append(')');
            this.stringCache = sb.toString();
            return this.stringCache;
        }

        private static interface Executor {
            public void execute() throws IllegalAccessException, InterruptedException, InvocationTargetException, XMPPException, IOException, SmackException;
        }
    }

    public static final class TestRunResult {
        public final String testRunId = StringUtils.insecureRandomString((int)5).toLowerCase(Locale.US);
        private final List<SuccessfulTest> successfulIntegrationTests = Collections.synchronizedList(new LinkedList());
        private final List<FailedTest> failedIntegrationTests = Collections.synchronizedList(new LinkedList());
        private final List<TestNotPossible> impossibleIntegrationTests = Collections.synchronizedList(new LinkedList());
        private final Map<Class<? extends AbstractSmackIntTest>, Throwable> impossibleTestClasses = new HashMap<Class<? extends AbstractSmackIntTest>, Throwable>();
        private final AtomicInteger numberOfAvailableTestMethods = new AtomicInteger();
        private final AtomicInteger numberOfPossibleTestMethods = new AtomicInteger();

        TestRunResult() {
        }

        public String getTestRunId() {
            return this.testRunId;
        }

        public int getNumberOfAvailableTests() {
            return this.numberOfAvailableTestMethods.get();
        }

        public int getNumberOfPossibleTests() {
            return this.numberOfPossibleTestMethods.get();
        }

        public List<SuccessfulTest> getSuccessfulTests() {
            return Collections.unmodifiableList(this.successfulIntegrationTests);
        }

        public List<FailedTest> getFailedTests() {
            return Collections.unmodifiableList(this.failedIntegrationTests);
        }

        public List<TestNotPossible> getNotPossibleTests() {
            return Collections.unmodifiableList(this.impossibleIntegrationTests);
        }

        public Map<Class<? extends AbstractSmackIntTest>, Throwable> getImpossibleTestClasses() {
            return Collections.unmodifiableMap(this.impossibleTestClasses);
        }
    }

    static enum AccountNum {
        One,
        Two,
        Three;

    }

    public static enum TestType {
        Normal,
        LowLevel,
        SpecificLowLevel;

    }
}

