/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.List;
import java.util.logging.Level;
import org.igniterealtime.smack.XmppConnectionStressTest;
import org.igniterealtime.smack.inttest.AbstractSmackLowLevelIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.tcp.XmppNioTcpConnection;

public class XmppConnectionIntegrationTest
extends AbstractSmackLowLevelIntegrationTest {
    public XmppConnectionIntegrationTest(SmackIntegrationTestEnvironment<?> environment) {
        super(environment);
    }

    @SmackIntegrationTest(connectionCount=4)
    public void allToAllMessageSendTest(List<AbstractXMPPConnection> connections) throws InterruptedException, XmppConnectionStressTest.StressTestFailedException.NotAllMessagesReceivedException, XmppConnectionStressTest.StressTestFailedException.ErrorsWhileSendingOrReceivingException {
        long seed = 42L;
        int messagesPerConnection = 3;
        int maxPayloadChunkSize = 16;
        int maxPayloadChunks = 4;
        boolean intermixMessages = false;
        XmppConnectionStressTest.Configuration stressTestConfiguration = new XmppConnectionStressTest.Configuration(42L, 3, 16, 4, false);
        XmppConnectionStressTest stressTest = new XmppConnectionStressTest(stressTestConfiguration);
        stressTest.run(connections, this.timeout);
        Level connectionStatsLogLevel = Level.FINE;
        if (LOGGER.isLoggable(connectionStatsLogLevel) && connections.get(0) instanceof XmppNioTcpConnection) {
            for (XMPPConnection xMPPConnection : connections) {
                XmppNioTcpConnection xmppNioTcpConnection = (XmppNioTcpConnection)xMPPConnection;
                XmppNioTcpConnection.Stats stats = xmppNioTcpConnection.getStats();
                LOGGER.log(connectionStatsLogLevel, "Connections stats for " + xmppNioTcpConnection + ":\n{}", stats);
            }
        }
    }
}

