/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.util.logging.Level;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.util.IntegrationTestRosterUtil;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.omemo.AbstractOmemoIntegrationTest;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoManagerSetupHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class AbstractTwoUsersOmemoIntegrationTest
extends AbstractOmemoIntegrationTest {
    protected OmemoManager alice;
    protected OmemoManager bob;

    public AbstractTwoUsersOmemoIntegrationTest(SmackIntegrationTestEnvironment<?> environment) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, TestNotPossibleException {
        super(environment);
    }

    @BeforeClass
    public void setup() throws Exception {
        this.alice = OmemoManagerSetupHelper.prepareOmemoManager(this.conOne);
        this.bob = OmemoManagerSetupHelper.prepareOmemoManager(this.conTwo);
        LOGGER.log(Level.FINE, "Alice: " + this.alice.getOwnDevice() + " Bob: " + this.bob.getOwnDevice());
        Assert.assertFalse((boolean)this.alice.getDeviceId().equals(this.bob.getDeviceId()));
        IntegrationTestRosterUtil.ensureBothAccountsAreSubscribedToEachOther(this.alice.getConnection(), this.bob.getConnection(), this.timeout);
        OmemoManagerSetupHelper.trustAllIdentitiesWithTests(this.alice, this.bob);
        OmemoManagerSetupHelper.trustAllIdentitiesWithTests(this.bob, this.alice);
        Assert.assertEquals((Object)this.bob.getOwnFingerprint(), this.alice.getActiveFingerprints(this.bob.getOwnJid()).get(this.bob.getOwnDevice()));
        Assert.assertEquals((Object)this.alice.getOwnFingerprint(), this.bob.getActiveFingerprints(this.alice.getOwnJid()).get(this.alice.getOwnDevice()));
    }

    @AfterClass
    public void cleanUp() {
        this.alice.stopStanzaAndPEPListeners();
        this.bob.stopStanzaAndPEPListeners();
        OmemoManagerSetupHelper.cleanUpPubSub(this.alice);
        OmemoManagerSetupHelper.cleanUpRoster(this.alice);
        OmemoManagerSetupHelper.cleanUpPubSub(this.bob);
        OmemoManagerSetupHelper.cleanUpRoster(this.bob);
    }
}

