/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.util.List;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.mam.MamManager;
import org.jivesoftware.smackx.mam.element.MamPrefsIQ;
import org.jivesoftware.smackx.omemo.AbstractTwoUsersOmemoIntegrationTest;
import org.jivesoftware.smackx.omemo.OmemoMessage;
import org.jivesoftware.smackx.omemo.exceptions.CryptoFailedException;
import org.jivesoftware.smackx.omemo.exceptions.UndecidedOmemoIdentityException;
import org.jivesoftware.smackx.omemo.util.MessageOrOmemoMessage;
import org.junit.Assert;
import org.jxmpp.jid.Jid;

public class OmemoMamDecryptionTest
extends AbstractTwoUsersOmemoIntegrationTest {
    public OmemoMamDecryptionTest(SmackIntegrationTestEnvironment<?> environment) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, TestNotPossibleException {
        super(environment);
        MamManager bobsMamManager = MamManager.getInstanceFor((XMPPConnection)this.conTwo);
        if (!bobsMamManager.isSupported()) {
            throw new TestNotPossibleException("Test is not possible, because MAM is not supported on the server.");
        }
    }

    @SmackIntegrationTest
    public void mamDecryptionTest() throws XMPPException.XMPPErrorException, SmackException.NotLoggedInException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, CryptoFailedException, UndecidedOmemoIdentityException {
        MamManager bobsMamManager = MamManager.getInstanceFor((XMPPConnection)this.bob.getConnection());
        bobsMamManager.enableMamForAllMessages();
        bobsMamManager.setDefaultBehavior(MamPrefsIQ.DefaultBehavior.always);
        this.bob.stopStanzaAndPEPListeners();
        String body = "This message will be stored in MAM!";
        OmemoMessage.Sent encrypted = this.alice.encrypt(this.bob.getOwnJid(), body);
        this.alice.getConnection().sendStanza((Stanza)encrypted.asMessage((Jid)this.bob.getOwnJid()));
        MamManager.MamQuery query = bobsMamManager.queryArchive(MamManager.MamQueryArgs.builder().limitResultsToJid((Jid)this.alice.getOwnJid()).build());
        Assert.assertEquals((long)1L, (long)query.getMessageCount());
        List decryptedMamQuery = this.bob.decryptMamQueryResult(query);
        Assert.assertEquals((long)1L, (long)decryptedMamQuery.size());
        Assert.assertEquals((Object)body, (Object)((MessageOrOmemoMessage)decryptedMamQuery.get(decryptedMamQuery.size() - 1)).getOmemoMessage().getBody());
    }
}

