/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SmackFuture;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smackx.ping.PingManager;
import org.junit.Assert;
import org.jxmpp.jid.Jid;

public class PingIntegrationTest
extends AbstractSmackIntegrationTest {
    public PingIntegrationTest(SmackIntegrationTestEnvironment<?> environment) {
        super(environment);
    }

    @SmackIntegrationTest
    public void pingServer() throws SmackException.NotConnectedException, InterruptedException {
        PingManager pingManager = PingManager.getInstanceFor((XMPPConnection)this.connection);
        Assert.assertTrue((boolean)pingManager.pingMyServer());
    }

    @SmackIntegrationTest
    public void pingAsync() throws InterruptedException, ExecutionException {
        List<Future> pongFutures = Collections.synchronizedList(new ArrayList());
        Runnable[] pinger = new Runnable[]{new Pinger(this.conOne, pongFutures, new Jid[]{this.conTwo.getUser(), this.conThree.getUser()}), new Pinger(this.conTwo, pongFutures, new Jid[]{this.conOne.getUser(), this.conThree.getUser()}), new Pinger(this.conThree, pongFutures, new Jid[]{this.conOne.getUser(), this.conTwo.getUser()})};
        ExecutorService executorService = Executors.newFixedThreadPool(pinger.length);
        for (Runnable runnable : pinger) {
            executorService.execute(runnable);
        }
        executorService.shutdown();
        executorService.awaitTermination(1L, TimeUnit.MINUTES);
        for (Future pongFuture : pongFutures) {
            Assert.assertTrue((boolean)((Boolean)pongFuture.get()));
        }
    }

    private static final class Pinger
    implements Runnable {
        private final List<Jid> toPing;
        private final Collection<Future<Boolean>> pongFutures;
        private final PingManager pingManager;

        private Pinger(XMPPConnection connection, Collection<Future<Boolean>> pongFutures, Jid ... toPing) {
            this(connection, pongFutures, Arrays.asList(toPing));
        }

        private Pinger(XMPPConnection connection, Collection<Future<Boolean>> pongFutures, List<Jid> toPing) {
            this.toPing = toPing;
            this.pongFutures = pongFutures;
            this.pingManager = PingManager.getInstanceFor((XMPPConnection)connection);
        }

        @Override
        public void run() {
            ArrayList<SmackFuture> futures = new ArrayList<SmackFuture>();
            for (Jid jid : this.toPing) {
                SmackFuture future = this.pingManager.pingAsync(jid);
                futures.add(future);
            }
            this.pongFutures.addAll(futures);
        }
    }
}

