/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.StandardExtensionElement;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.pubsub.ConfigureForm;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.xdata.Form;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainBareJid;

public class PubSubIntegrationTest
extends AbstractSmackIntegrationTest {
    private final PubSubManager pubSubManagerOne;

    public PubSubIntegrationTest(SmackIntegrationTestEnvironment<?> environment) throws TestNotPossibleException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        super(environment);
        DomainBareJid pubSubService = PubSubManager.getPubSubService((XMPPConnection)this.conOne);
        if (pubSubService == null) {
            throw new TestNotPossibleException("No PubSub service found");
        }
        this.pubSubManagerOne = PubSubManager.getInstanceFor((XMPPConnection)this.conOne, (BareJid)pubSubService);
        if (!this.pubSubManagerOne.canCreateNodesAndPublishItems()) {
            throw new TestNotPossibleException("PubSub service does not allow node creation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void transientNotificationOnlyNodeWithoutItemTest() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        String nodename = "sinttest-transient-notificationonly-withoutitem-nodename-" + this.testRunId;
        ConfigureForm defaultConfiguration = this.pubSubManagerOne.getDefaultConfiguration();
        ConfigureForm config = new ConfigureForm(defaultConfiguration.createAnswerForm());
        config.setDeliverPayloads(false);
        config.setPersistentItems(false);
        Node node = this.pubSubManagerOne.createNode(nodename, (Form)config);
        try {
            LeafNode leafNode = (LeafNode)node;
            leafNode.publish();
        }
        finally {
            this.pubSubManagerOne.deleteNode(nodename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void transientNotificationOnlyNodeWithItemTest() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        String nodename = "sinttest-transient-notificationonly-withitem-nodename-" + this.testRunId;
        String itemId = "sinttest-transient-notificationonly-withitem-itemid-" + this.testRunId;
        ConfigureForm defaultConfiguration = this.pubSubManagerOne.getDefaultConfiguration();
        ConfigureForm config = new ConfigureForm(defaultConfiguration.createAnswerForm());
        config.setDeliverPayloads(false);
        config.setPersistentItems(false);
        Node node = this.pubSubManagerOne.createNode(nodename, (Form)config);
        StandardExtensionElement dummyPayload = StandardExtensionElement.builder((String)"dummy-payload", (String)"https://igniterealtime.org/projects/smack").setText(this.testRunId).build();
        try {
            XMPPException.XMPPErrorException e = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> {
                LeafNode leafNode = (LeafNode)node;
                PayloadItem item = new PayloadItem(itemId, (ExtensionElement)dummyPayload);
                leafNode.publish((Item)item);
            });
            Assert.assertEquals((Object)StanzaError.Type.MODIFY, (Object)e.getStanzaError().getType());
            Assert.assertNotNull((Object)e.getStanzaError().getExtension("item-forbidden", "http://jabber.org/protocol/pubsub#errors"));
        }
        finally {
            this.pubSubManagerOne.deleteNode(nodename);
        }
    }
}

