/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.xml.splitter;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.jxmpp.xml.splitter.CompleteElementCallback;
import org.jxmpp.xml.splitter.DeclarationCallback;
import org.jxmpp.xml.splitter.ProcessingInstructionCallback;
import org.jxmpp.xml.splitter.XmlPrinter;

public class XmlSplitter
extends Writer {
    private final DeclarationCallback declarationCallback;
    private final ProcessingInstructionCallback processingInstructionCallback;
    private final XmlPrinter xmlPrinter;
    protected final CompleteElementCallback completeElementCallback;
    private final StringBuilder splittedPartBuffer;
    private final StringBuilder tokenBuffer = new StringBuilder(256);
    private final Map<String, String> attributes = new HashMap<String, String>();
    private int depth;
    private String qName;
    private String attributeName;
    private State state = State.START;
    private AttributeValueQuotes attributeValueQuotes;

    public XmlSplitter(int bufferSize, CompleteElementCallback completeElementCallback, DeclarationCallback declarationCallback, ProcessingInstructionCallback processingInstructionCallback) {
        this(bufferSize, completeElementCallback, declarationCallback, processingInstructionCallback, null);
    }

    public XmlSplitter(int bufferSize, CompleteElementCallback completeElementCallback, XmlPrinter xmlPrinter) {
        this(bufferSize, completeElementCallback, null, null, xmlPrinter);
    }

    public XmlSplitter(int bufferSize, CompleteElementCallback completeElementCallback) {
        this(bufferSize, completeElementCallback, null, null);
    }

    public XmlSplitter(int bufferSize, CompleteElementCallback completeElementCallback, DeclarationCallback declarationCallback, ProcessingInstructionCallback processingInstructionCallback, XmlPrinter xmlPrinter) {
        if (bufferSize < 0) {
            bufferSize = 128;
        }
        this.splittedPartBuffer = new StringBuilder(bufferSize);
        this.completeElementCallback = completeElementCallback;
        this.declarationCallback = declarationCallback;
        this.processingInstructionCallback = processingInstructionCallback;
        this.xmlPrinter = xmlPrinter;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.xmlPrinter != null) {
            this.xmlPrinter.onChunkStart();
        }
        for (int cur = off; cur < off + len; ++cur) {
            this.processChar(cbuf[off + cur]);
        }
        if (this.xmlPrinter != null) {
            this.xmlPrinter.onChunkEnd();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public final int getCurrentSplittedPartSize() {
        return this.splittedPartBuffer.length();
    }

    protected void onNextChar() throws IOException {
    }

    protected void onStartTag(String prefix, String localpart, Map<String, String> attributes) {
    }

    protected void onEndTag(String qName) {
    }

    protected final void newSplittedPart() {
        this.depth = 0;
        this.splittedPartBuffer.setLength(0);
        assert (this.state != State.START);
        this.state = State.START;
    }

    private void processChar(char c) throws IOException {
        this.onNextChar();
        this.splittedPartBuffer.append(c);
        boolean endTagFinished = false;
        State initialState = this.state;
        block0 : switch (this.state) {
            case TAG_RIGHT_ANGLE_BRACKET: {
                this.state = State.START;
            }
            case START: {
                switch (c) {
                    case '<': {
                        this.state = State.TAG_LEFT_ANGLE_BRACKET;
                    }
                }
                break;
            }
            case TAG_LEFT_ANGLE_BRACKET: {
                switch (c) {
                    case '/': {
                        this.state = State.END_TAG_SOLIDUS;
                        break block0;
                    }
                    case '?': {
                        this.state = State.IN_PROCESSING_INSTRUCTION_OR_DECLARATION;
                        break block0;
                    }
                    case '!': {
                        this.state = State.AFTER_COMMENT_BANG;
                        break block0;
                    }
                }
                this.tokenBuffer.append(c);
                this.state = State.IN_TAG_NAME;
                break;
            }
            case END_TAG_SOLIDUS: {
                this.state = State.IN_END_TAG;
                this.tokenBuffer.append(c);
                break;
            }
            case IN_TAG_NAME: {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        this.qName = this.getToken();
                        this.state = State.AFTER_START_NAME;
                        break block0;
                    }
                    case '/': {
                        this.qName = this.getToken();
                        this.onStartTagFinished();
                        this.state = State.IN_EMPTY_TAG;
                        break block0;
                    }
                    case '>': {
                        this.qName = this.getToken();
                        this.onStartTagFinished();
                        this.state = State.TAG_RIGHT_ANGLE_BRACKET;
                        break block0;
                    }
                }
                this.tokenBuffer.append(c);
                break;
            }
            case IN_END_TAG: {
                switch (c) {
                    case '>': {
                        endTagFinished = true;
                        this.state = State.TAG_RIGHT_ANGLE_BRACKET;
                        break block0;
                    }
                }
                this.tokenBuffer.append(c);
                break;
            }
            case AFTER_START_NAME: {
                switch (c) {
                    case '/': {
                        this.onStartTagFinished();
                        this.state = State.IN_EMPTY_TAG;
                        break block0;
                    }
                    case '>': {
                        this.onStartTagFinished();
                        this.state = State.TAG_RIGHT_ANGLE_BRACKET;
                        break block0;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        break block0;
                    }
                }
                this.tokenBuffer.append(c);
                this.state = State.IN_ATTRIBUTE_NAME;
                break;
            }
            case IN_ATTRIBUTE_NAME: {
                switch (c) {
                    case '=': {
                        this.attributeName = this.getToken();
                        this.state = State.AFTER_ATTRIBUTE_EQUALS;
                        break block0;
                    }
                }
                this.tokenBuffer.append(c);
                break;
            }
            case AFTER_ATTRIBUTE_EQUALS: {
                switch (c) {
                    case '\'': {
                        this.attributeValueQuotes = AttributeValueQuotes.apos;
                        this.state = State.IN_ATTRIBUTE_VALUE;
                        break block0;
                    }
                    case '\"': {
                        this.attributeValueQuotes = AttributeValueQuotes.quot;
                        this.state = State.IN_ATTRIBUTE_VALUE;
                        break block0;
                    }
                }
                throw new IOException();
            }
            case IN_ATTRIBUTE_VALUE: {
                if (c == this.attributeValueQuotes.c) {
                    this.attributes.put(this.attributeName, this.getToken());
                    this.state = State.AFTER_START_NAME;
                    break;
                }
                this.tokenBuffer.append(c);
                break;
            }
            case IN_EMPTY_TAG: {
                switch (c) {
                    case '>': {
                        endTagFinished = true;
                        this.state = State.TAG_RIGHT_ANGLE_BRACKET;
                        break block0;
                    }
                }
                throw new IOException();
            }
            case IN_PROCESSING_INSTRUCTION_OR_DECLARATION: {
                switch (c) {
                    case '\'': {
                        this.attributeValueQuotes = AttributeValueQuotes.apos;
                        this.state = State.IN_PROCESSING_INSTRUCTION_OR_DECLARATION_PSEUDO_ATTRIBUTE_VALUE;
                        break;
                    }
                    case '\"': {
                        this.attributeValueQuotes = AttributeValueQuotes.quot;
                        this.state = State.IN_PROCESSING_INSTRUCTION_OR_DECLARATION_PSEUDO_ATTRIBUTE_VALUE;
                        break;
                    }
                    case '?': {
                        this.state = State.IN_PROCESSING_INSTRUCTION_OR_DECLARATION_QUESTION_MARK;
                    }
                }
                break;
            }
            case IN_PROCESSING_INSTRUCTION_OR_DECLARATION_PSEUDO_ATTRIBUTE_VALUE: {
                if (c != this.attributeValueQuotes.c) break;
                this.state = State.IN_PROCESSING_INSTRUCTION_OR_DECLARATION;
                break;
            }
            case IN_PROCESSING_INSTRUCTION_OR_DECLARATION_QUESTION_MARK: {
                if (c == '>') {
                    String processingInstructionOrDeclaration = this.splittedPartBuffer.toString();
                    this.onProcessingInstructionOrDeclaration(processingInstructionOrDeclaration);
                    this.newSplittedPart();
                    break;
                }
                this.state = State.IN_PROCESSING_INSTRUCTION_OR_DECLARATION;
                break;
            }
            case AFTER_COMMENT_BANG: 
            case AFTER_COMMENT_DASH1: 
            case AFTER_COMMENT_DASH2: 
            case AFTER_COMMENT: 
            case AFTER_COMMENT_CLOSING_DASH1: 
            case AFTER_COMMENT_CLOSING_DASH2: {
                throw new UnsupportedOperationException();
            }
        }
        if (this.xmlPrinter != null) {
            this.xmlPrinter.onNextChar(c, this.depth, initialState, this.state);
        }
        if (endTagFinished) {
            this.onEndTagFinished();
        }
    }

    private void onStartTagFinished() {
        ++this.depth;
        String prefix = XmlSplitter.extractPrefix(this.qName);
        String localpart = XmlSplitter.extractLocalpart(this.qName);
        this.onStartTag(prefix, localpart, this.attributes);
        this.attributes.clear();
    }

    private void onEndTagFinished() {
        String endTagName = this.getToken();
        if (endTagName.length() == 0) {
            endTagName = this.qName;
        }
        --this.depth;
        if (this.depth == 0) {
            String completeElement = this.splittedPartBuffer.toString();
            this.splittedPartBuffer.setLength(0);
            if (this.completeElementCallback != null) {
                this.completeElementCallback.onCompleteElement(completeElement);
            }
            if (this.xmlPrinter != null) {
                this.xmlPrinter.onCompleteElement();
            }
        }
        this.onEndTag(endTagName);
        assert (this.state != State.START);
        this.state = State.START;
    }

    private String getToken() {
        String token = this.tokenBuffer.toString();
        this.tokenBuffer.setLength(0);
        return token;
    }

    private void onProcessingInstructionOrDeclaration(String processingInstructionOrDeclaration) {
        if (processingInstructionOrDeclaration.startsWith("<?xml ")) {
            if (this.declarationCallback != null) {
                this.declarationCallback.onDeclaration(processingInstructionOrDeclaration);
            }
        } else if (this.processingInstructionCallback != null) {
            this.processingInstructionCallback.onProcessingInstruction(processingInstructionOrDeclaration);
        }
    }

    private static String extractPrefix(String qName) {
        int index = qName.indexOf(58);
        return index > -1 ? qName.substring(0, index) : qName;
    }

    private static String extractLocalpart(String qName) {
        int index = qName.indexOf(58);
        return index > -1 ? qName.substring(index + 1) : qName;
    }

    private static enum AttributeValueQuotes {
        apos('\''),
        quot('\"');

        final char c;

        private AttributeValueQuotes(char c) {
            this.c = c;
        }
    }

    static enum State {
        START,
        TAG_LEFT_ANGLE_BRACKET,
        TAG_RIGHT_ANGLE_BRACKET,
        END_TAG_SOLIDUS,
        IN_TAG_NAME,
        IN_END_TAG,
        AFTER_START_NAME,
        IN_EMPTY_TAG,
        IN_ATTRIBUTE_NAME,
        AFTER_ATTRIBUTE_EQUALS,
        IN_ATTRIBUTE_VALUE,
        AFTER_COMMENT_BANG,
        AFTER_COMMENT_DASH1,
        AFTER_COMMENT_DASH2,
        AFTER_COMMENT,
        AFTER_COMMENT_CLOSING_DASH1,
        AFTER_COMMENT_CLOSING_DASH2,
        IN_PROCESSING_INSTRUCTION_OR_DECLARATION,
        IN_PROCESSING_INSTRUCTION_OR_DECLARATION_PSEUDO_ATTRIBUTE_VALUE,
        IN_PROCESSING_INSTRUCTION_OR_DECLARATION_QUESTION_MARK;

    }
}

