/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.pgpainless.decryption_verification.DecryptionBuilderInterface;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.DecryptionStreamFactory;
import org.pgpainless.decryption_verification.MissingPublicKeyCallback;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.protection.SecretKeyRingProtector;

public class DecryptionBuilder
implements DecryptionBuilderInterface {
    private InputStream inputStream;
    private PGPSecretKeyRingCollection decryptionKeys;
    private SecretKeyRingProtector decryptionKeyDecryptor;
    private Set<PGPPublicKeyRing> verificationKeys = new HashSet<PGPPublicKeyRing>();
    private MissingPublicKeyCallback missingPublicKeyCallback = null;

    @Override
    public DecryptionBuilderInterface.DecryptWith onInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return new DecryptWithImpl();
    }

    class BuildImpl
    implements DecryptionBuilderInterface.Build {
        BuildImpl() {
        }

        @Override
        public DecryptionStream build() throws IOException, PGPException {
            return DecryptionStreamFactory.create(DecryptionBuilder.this.inputStream, DecryptionBuilder.this.decryptionKeys, DecryptionBuilder.this.decryptionKeyDecryptor, DecryptionBuilder.this.verificationKeys, DecryptionBuilder.this.missingPublicKeyCallback);
        }
    }

    class HandleMissingPublicKeysImpl
    implements DecryptionBuilderInterface.HandleMissingPublicKeys {
        HandleMissingPublicKeysImpl() {
        }

        @Override
        public DecryptionBuilderInterface.Build handleMissingPublicKeysWith(@Nonnull MissingPublicKeyCallback callback) {
            DecryptionBuilder.this.missingPublicKeyCallback = callback;
            return new BuildImpl();
        }

        @Override
        public DecryptionBuilderInterface.Build ignoreMissingPublicKeys() {
            DecryptionBuilder.this.missingPublicKeyCallback = null;
            return new BuildImpl();
        }
    }

    class VerifyWithImpl
    implements DecryptionBuilderInterface.VerifyWith {
        VerifyWithImpl() {
        }

        @Override
        public DecryptionBuilderInterface.HandleMissingPublicKeys verifyWith(@Nonnull PGPPublicKeyRingCollection publicKeyRingCollection) {
            HashSet<PGPPublicKeyRing> publicKeyRings = new HashSet<PGPPublicKeyRing>();
            Iterator i = publicKeyRingCollection.getKeyRings();
            while (i.hasNext()) {
                publicKeyRings.add((PGPPublicKeyRing)i.next());
            }
            return this.verifyWith(publicKeyRings);
        }

        @Override
        public DecryptionBuilderInterface.HandleMissingPublicKeys verifyWith(@Nonnull Set<OpenPgpV4Fingerprint> trustedKeyIds, @Nonnull PGPPublicKeyRingCollection publicKeyRingCollection) {
            HashSet<PGPPublicKeyRing> publicKeyRings = new HashSet<PGPPublicKeyRing>();
            Iterator i = publicKeyRingCollection.getKeyRings();
            while (i.hasNext()) {
                PGPPublicKeyRing p = (PGPPublicKeyRing)i.next();
                OpenPgpV4Fingerprint fingerprint = new OpenPgpV4Fingerprint(p);
                if (!trustedKeyIds.contains(fingerprint)) continue;
                publicKeyRings.add(p);
            }
            return this.verifyWith(publicKeyRings);
        }

        @Override
        public DecryptionBuilderInterface.HandleMissingPublicKeys verifyWith(@Nonnull Set<PGPPublicKeyRing> publicKeyRings) {
            DecryptionBuilder.this.verificationKeys = publicKeyRings;
            return new HandleMissingPublicKeysImpl();
        }

        @Override
        public DecryptionBuilderInterface.Build doNotVerify() {
            DecryptionBuilder.this.verificationKeys = null;
            return new BuildImpl();
        }
    }

    class DecryptWithImpl
    implements DecryptionBuilderInterface.DecryptWith {
        DecryptWithImpl() {
        }

        @Override
        public DecryptionBuilderInterface.VerifyWith decryptWith(@Nonnull SecretKeyRingProtector decryptor, @Nonnull PGPSecretKeyRingCollection secretKeyRings) {
            DecryptionBuilder.this.decryptionKeys = secretKeyRings;
            DecryptionBuilder.this.decryptionKeyDecryptor = decryptor;
            return new VerifyWithImpl();
        }

        @Override
        public DecryptionBuilderInterface.VerifyWith doNotDecrypt() {
            DecryptionBuilder.this.decryptionKeys = null;
            DecryptionBuilder.this.decryptionKeyDecryptor = null;
            return new VerifyWithImpl();
        }
    }
}

