/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MissingPublicKeyCallback;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.protection.SecretKeyRingProtector;

public interface DecryptionBuilderInterface {
    public DecryptWith onInputStream(InputStream var1);

    public static interface Build {
        public DecryptionStream build() throws IOException, PGPException;
    }

    public static interface HandleMissingPublicKeys {
        public Build handleMissingPublicKeysWith(@Nonnull MissingPublicKeyCallback var1);

        public Build ignoreMissingPublicKeys();
    }

    public static interface VerifyWith {
        public HandleMissingPublicKeys verifyWith(@Nonnull PGPPublicKeyRingCollection var1);

        public HandleMissingPublicKeys verifyWith(@Nonnull Set<OpenPgpV4Fingerprint> var1, @Nonnull PGPPublicKeyRingCollection var2);

        public HandleMissingPublicKeys verifyWith(@Nonnull Set<PGPPublicKeyRing> var1);

        public Build doNotVerify();
    }

    public static interface DecryptWith {
        public VerifyWith decryptWith(@Nonnull SecretKeyRingProtector var1, @Nonnull PGPSecretKeyRingCollection var2);

        public VerifyWith doNotDecrypt();
    }
}

