/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.pgpainless.decryption_verification.OpenPgpMetadata;

public class DecryptionStream
extends InputStream {
    private final InputStream inputStream;
    private final OpenPgpMetadata.Builder resultBuilder;
    private boolean isClosed = false;

    DecryptionStream(@Nonnull InputStream wrapped, @Nonnull OpenPgpMetadata.Builder resultBuilder) {
        this.inputStream = wrapped;
        this.resultBuilder = resultBuilder;
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
        this.isClosed = true;
    }

    public OpenPgpMetadata getResult() {
        if (!this.isClosed) {
            throw new IllegalStateException("DecryptionStream MUST be closed before the result can be accessed.");
        }
        return this.resultBuilder.build();
    }
}

