/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SignatureException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.key.OpenPgpV4Fingerprint;

public class SignatureVerifyingInputStream
extends FilterInputStream {
    private static final Logger LOGGER = Logger.getLogger(SignatureVerifyingInputStream.class.getName());
    private static final Level LEVEL = Level.INFO;
    private final PGPObjectFactory objectFactory;
    private final Map<OpenPgpV4Fingerprint, PGPOnePassSignature> onePassSignatures;
    private final OpenPgpMetadata.Builder resultBuilder;
    private boolean validated = false;

    protected SignatureVerifyingInputStream(@Nonnull InputStream inputStream, @Nonnull PGPObjectFactory objectFactory, @Nonnull Map<OpenPgpV4Fingerprint, PGPOnePassSignature> onePassSignatures, @Nonnull OpenPgpMetadata.Builder resultBuilder) {
        super(inputStream);
        this.objectFactory = objectFactory;
        this.resultBuilder = resultBuilder;
        this.onePassSignatures = onePassSignatures;
        LOGGER.log(LEVEL, "Begin verifying OnePassSignatures");
    }

    private void updateOnePassSignatures(byte data) {
        for (PGPOnePassSignature signature : this.onePassSignatures.values()) {
            signature.update(data);
        }
    }

    private void updateOnePassSignatures(byte[] b, int off, int len) {
        for (PGPOnePassSignature signature : this.onePassSignatures.values()) {
            signature.update(b, off, len);
        }
    }

    private void validateOnePassSignatures() throws IOException {
        if (this.validated) {
            LOGGER.log(LEVEL, "Validated signatures already. Skip");
            return;
        }
        this.validated = true;
        if (this.onePassSignatures.isEmpty()) {
            LOGGER.log(LEVEL, "No One-Pass-Signatures found -> No validation");
            return;
        }
        try {
            PGPSignatureList signatureList = null;
            Object obj = this.objectFactory.nextObject();
            while (obj != null && signatureList == null) {
                if (obj instanceof PGPSignatureList) {
                    signatureList = (PGPSignatureList)obj;
                    continue;
                }
                obj = this.objectFactory.nextObject();
            }
            if (signatureList == null || signatureList.isEmpty()) {
                throw new IOException("Verification failed - No Signatures found");
            }
            for (PGPSignature signature : signatureList) {
                PGPOnePassSignature onePassSignature;
                OpenPgpV4Fingerprint fingerprint = null;
                for (OpenPgpV4Fingerprint f : this.onePassSignatures.keySet()) {
                    if (f.getKeyId() != signature.getKeyID()) continue;
                    fingerprint = f;
                    break;
                }
                if (fingerprint == null || (onePassSignature = this.onePassSignatures.get(fingerprint)) == null) {
                    LOGGER.log(LEVEL, "Found Signature without respective OnePassSignature packet -> skip");
                    continue;
                }
                if (!onePassSignature.verify(signature)) {
                    throw new SignatureException("Bad Signature of key " + signature.getKeyID());
                }
                LOGGER.log(LEVEL, "Verified signature of key " + Long.toHexString(signature.getKeyID()));
                this.resultBuilder.addVerifiedSignatureFingerprint(fingerprint);
            }
        }
        catch (SignatureException | PGPException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public int read() throws IOException {
        boolean endOfStream;
        int data = super.read();
        boolean bl = endOfStream = data == -1;
        if (endOfStream) {
            this.validateOnePassSignatures();
        } else {
            this.updateOnePassSignatures((byte)data);
        }
        return data;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        boolean endOfStream;
        int read = super.read(b, off, len);
        boolean bl = endOfStream = read == -1;
        if (endOfStream) {
            this.validateOnePassSignatures();
        } else {
            this.updateOnePassSignatures(b, off, read);
        }
        return read;
    }

    @Override
    public long skip(long n) {
        throw new UnsupportedOperationException("skip() is not supported");
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("mark() not supported");
    }

    @Override
    public synchronized void reset() {
        throw new UnsupportedOperationException("reset() is not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

