/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.collection.PGPKeyRing;
import org.pgpainless.key.generation.KeyRingBuilderInterface;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.ECDH;
import org.pgpainless.key.generation.type.ECDSA;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.RSA_GENERAL;
import org.pgpainless.key.generation.type.curve.EllipticCurve;
import org.pgpainless.key.generation.type.length.RsaLength;
import org.pgpainless.util.KeyRingSubKeyFix;
import org.pgpainless.util.Passphrase;

public class KeyRingBuilder
implements KeyRingBuilderInterface {
    private final Charset UTF8 = Charset.forName("UTF-8");
    private List<KeySpec> keySpecs = new ArrayList<KeySpec>();
    private String userId;
    private Passphrase passphrase;

    public PGPKeyRing simpleRsaKeyRing(@Nonnull String userId, @Nonnull RsaLength length) throws PGPException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        return this.withMasterKey(KeySpec.getBuilder(RSA_GENERAL.withLength(length)).withDefaultKeyFlags().withDefaultAlgorithms()).withPrimaryUserId(userId).withoutPassphrase().build();
    }

    public PGPKeyRing simpleEcKeyRing(@Nonnull String userId) throws PGPException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        return this.withSubKey(KeySpec.getBuilder(ECDH.fromCurve(EllipticCurve._P256)).withKeyFlags(KeyFlag.ENCRYPT_STORAGE, KeyFlag.ENCRYPT_COMMS).withDefaultAlgorithms()).withMasterKey(KeySpec.getBuilder(ECDSA.fromCurve(EllipticCurve._P256)).withKeyFlags(KeyFlag.AUTHENTICATION, KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA).withDefaultAlgorithms()).withPrimaryUserId(userId).withoutPassphrase().build();
    }

    @Override
    public KeyRingBuilderInterface withSubKey(@Nonnull KeySpec type) {
        this.keySpecs.add(type);
        return this;
    }

    @Override
    public KeyRingBuilderInterface.WithPrimaryUserId withMasterKey(@Nonnull KeySpec spec) {
        if ((spec.getSubpackets().getKeyFlags() & 1) == 0) {
            throw new IllegalArgumentException("Certification Key MUST have KeyFlag CERTIFY_OTHER");
        }
        this.keySpecs.add(0, spec);
        return new WithPrimaryUserIdImpl();
    }

    class WithPassphraseImpl
    implements KeyRingBuilderInterface.WithPassphrase {
        WithPassphraseImpl() {
        }

        @Override
        public KeyRingBuilderInterface.Build withPassphrase(@Nonnull Passphrase passphrase) {
            KeyRingBuilder.this.passphrase = passphrase;
            return new BuildImpl();
        }

        @Override
        public KeyRingBuilderInterface.Build withoutPassphrase() {
            KeyRingBuilder.this.passphrase = null;
            return new BuildImpl();
        }

        class BuildImpl
        implements KeyRingBuilderInterface.Build {
            BuildImpl() {
            }

            @Override
            public PGPKeyRing build() throws NoSuchAlgorithmException, PGPException, NoSuchProviderException, InvalidAlgorithmParameterException {
                PBESecretKeyEncryptor encryptor;
                PGPDigestCalculator calculator = new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build().get(HashAlgorithm.SHA1.getAlgorithmId());
                PBESecretKeyEncryptor pBESecretKeyEncryptor = KeyRingBuilder.this.passphrase == null ? null : (encryptor = new JcePBESecretKeyEncryptorBuilder(9, calculator).setProvider("BC").build(KeyRingBuilder.this.passphrase != null ? KeyRingBuilder.this.passphrase.getChars() : null));
                if (KeyRingBuilder.this.passphrase != null) {
                    KeyRingBuilder.this.passphrase.clear();
                }
                KeySpec certKeySpec = (KeySpec)KeyRingBuilder.this.keySpecs.get(0);
                KeyRingBuilder.this.keySpecs.remove(0);
                PGPKeyPair certKey = this.generateKeyPair(certKeySpec);
                JcaPGPContentSignerBuilder signer = new JcaPGPContentSignerBuilder(certKey.getPublicKey().getAlgorithm(), HashAlgorithm.SHA512.getAlgorithmId()).setProvider("BC");
                PGPSignatureSubpacketVector hashedSubPackets = certKeySpec.getSubpackets();
                PGPKeyRingGenerator ringGenerator = new PGPKeyRingGenerator(19, certKey, KeyRingBuilder.this.userId, calculator, hashedSubPackets, null, (PGPContentSignerBuilder)signer, encryptor);
                for (KeySpec subKeySpec : KeyRingBuilder.this.keySpecs) {
                    PGPKeyPair subKey = this.generateKeyPair(subKeySpec);
                    if (subKeySpec.isInheritedSubPackets()) {
                        ringGenerator.addSubKey(subKey);
                        continue;
                    }
                    ringGenerator.addSubKey(subKey, subKeySpec.getSubpackets(), null);
                }
                PGPPublicKeyRing publicKeys = ringGenerator.generatePublicKeyRing();
                PGPSecretKeyRing secretKeys = ringGenerator.generateSecretKeyRing();
                secretKeys = KeyRingSubKeyFix.repairSubkeyPackets(secretKeys, null, null);
                return new PGPKeyRing(publicKeys, secretKeys);
            }

            private PGPKeyPair generateKeyPair(KeySpec spec) throws NoSuchProviderException, NoSuchAlgorithmException, PGPException, InvalidAlgorithmParameterException {
                KeyType type = spec.getKeyType();
                KeyPairGenerator certKeyGenerator = KeyPairGenerator.getInstance(type.getName(), "BC");
                certKeyGenerator.initialize(type.getAlgorithmSpec());
                KeyPair keyPair = certKeyGenerator.generateKeyPair();
                JcaPGPKeyPair pgpKeyPair = new JcaPGPKeyPair(type.getAlgorithm().getAlgorithmId(), keyPair, new Date());
                return pgpKeyPair;
            }
        }
    }

    class WithPrimaryUserIdImpl
    implements KeyRingBuilderInterface.WithPrimaryUserId {
        WithPrimaryUserIdImpl() {
        }

        @Override
        public KeyRingBuilderInterface.WithPassphrase withPrimaryUserId(@Nonnull String userId) {
            KeyRingBuilder.this.userId = userId;
            return new WithPassphraseImpl();
        }

        @Override
        public KeyRingBuilderInterface.WithPassphrase withPrimaryUserId(@Nonnull byte[] userId) {
            return this.withPrimaryUserId(new String(userId, KeyRingBuilder.this.UTF8));
        }
    }
}

