/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;

public class KeyRingSubKeyFix {
    private static final Logger LOGGER = Logger.getLogger(KeyRingSubKeyFix.class.getName());

    public static PGPSecretKeyRing repairSubkeyPackets(@Nonnull PGPSecretKeyRing secretKeys, @Nullable PBESecretKeyDecryptor decryptor, @Nullable PBESecretKeyEncryptor encryptor) throws PGPException {
        PGPDigestCalculator calculator = new BcPGPDigestCalculatorProvider().get(2);
        ArrayList<PGPSecretKey> _secretKeys = new ArrayList<PGPSecretKey>();
        Iterator secretKeyIterator = secretKeys.iterator();
        try {
            while (secretKeyIterator.hasNext()) {
                PGPSecretKey secSubKey = (PGPSecretKey)secretKeyIterator.next();
                if (secSubKey.isMasterKey()) {
                    LOGGER.log(Level.INFO, Long.toHexString(secSubKey.getKeyID()) + " is master key. Skip.");
                    _secretKeys.add(secSubKey);
                    continue;
                }
                PGPPublicKey pubSubKey = secSubKey.getPublicKey();
                Field publicPk = pubSubKey.getClass().getDeclaredField("publicPk");
                publicPk.setAccessible(true);
                PublicKeyPacket keyPacket = (PublicKeyPacket)publicPk.get(pubSubKey);
                if (keyPacket instanceof PublicSubkeyPacket) {
                    _secretKeys.add(secSubKey);
                    continue;
                }
                LOGGER.log(Level.INFO, "Subkey " + Long.toHexString(secSubKey.getKeyID()) + " does not have a subkey key packet. Convert it...");
                keyPacket = new PublicSubkeyPacket(pubSubKey.getAlgorithm(), pubSubKey.getCreationTime(), keyPacket.getKey());
                publicPk.set(pubSubKey, keyPacket);
                PGPPrivateKey privateKey = secSubKey.extractPrivateKey(decryptor);
                PGPSecretKey secretKey = new PGPSecretKey(privateKey, pubSubKey, calculator, false, encryptor);
                _secretKeys.add(secretKey);
            }
            return new PGPSecretKeyRing(_secretKeys);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Cannot apply fix due to an error while using reflections.", e);
        }
    }
}

