/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class MultiMap<K, V> {
    private final Map<K, Set<V>> map;

    public MultiMap() {
        this.map = new HashMap<K, Set<V>>();
    }

    public MultiMap(@Nonnull MultiMap<K, V> other) {
        this.map = new HashMap<K, Set<V>>();
        for (K k : other.map.keySet()) {
            this.map.put(k, new HashSet(other.map.get(k)));
        }
    }

    public MultiMap(@Nonnull Map<K, Set<V>> content) {
        this.map = new HashMap<K, Set<Set<V>>>(content);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(K o) {
        return this.map.containsKey(o);
    }

    public boolean containsValue(V o) {
        for (Set<V> values : this.map.values()) {
            if (!values.contains(o)) continue;
            return true;
        }
        return false;
    }

    public Set<V> get(K o) {
        return this.map.get(o);
    }

    public void put(K k, V v) {
        Set<V> values = this.map.get(k);
        if (values == null) {
            values = new HashSet<V>();
            this.map.put(k, values);
        }
        values.add(v);
    }

    public void put(K k, Set<V> vs) {
        for (V v : vs) {
            this.put(k, v);
        }
    }

    public void remove(K o) {
        for (Set<V> values : this.map.values()) {
            values.remove(o);
        }
    }

    public void putAll(Map<? extends K, ? extends Set<V>> _map) {
        for (K key : _map.keySet()) {
            Set<V> vs = this.map.get(key);
            if (vs == null) {
                vs = new HashSet<V>();
                this.map.put(key, vs);
            }
            vs.addAll((Collection)_map.get(key));
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Collection<Set<V>> values() {
        return this.map.values();
    }

    public Set<Map.Entry<K, Set<V>>> entrySet() {
        return this.map.entrySet();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof MultiMap)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        return this.map.equals(((MultiMap)o).map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }
}

