/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ScheduledAction;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.util.Objects;

public abstract class Manager {
    final WeakReference<XMPPConnection> weakConnection;

    public Manager(XMPPConnection connection) {
        Objects.requireNonNull(connection, "XMPPConnection must not be null");
        this.weakConnection = new WeakReference<XMPPConnection>(connection);
    }

    protected final XMPPConnection connection() {
        return (XMPPConnection)this.weakConnection.get();
    }

    protected final XMPPConnection getAuthenticatedConnectionOrThrow() throws SmackException.NotLoggedInException {
        XMPPConnection connection = this.connection();
        if (!connection.isAuthenticated()) {
            throw new SmackException.NotLoggedInException();
        }
        return connection;
    }

    protected static final ScheduledAction schedule(Runnable runnable, long delay, TimeUnit unit) {
        return AbstractXMPPConnection.SMACK_REACTOR.schedule(runnable, delay, unit);
    }
}

