/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.security.auth.callback.CallbackHandler;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Mechanisms;
import org.jivesoftware.smack.sasl.SASLErrorException;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.sasl.core.ScramSha1PlusMechanism;
import org.jivesoftware.smack.sasl.packet.SaslStreamElements;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;

public final class SASLAuthentication {
    private static final Logger LOGGER = Logger.getLogger(SASLAuthentication.class.getName());
    private static final List<SASLMechanism> REGISTERED_MECHANISMS = new ArrayList<SASLMechanism>();
    private static final Set<String> BLACKLISTED_MECHANISMS = new HashSet<String>();
    private final AbstractXMPPConnection connection;
    private final ConnectionConfiguration configuration;
    private SASLMechanism currentMechanism = null;
    private boolean authenticationSuccessful;
    private Exception saslException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSASLMechanism(SASLMechanism mechanism) {
        List<SASLMechanism> list = REGISTERED_MECHANISMS;
        synchronized (list) {
            REGISTERED_MECHANISMS.add(mechanism);
            Collections.sort(REGISTERED_MECHANISMS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getRegisterdSASLMechanisms() {
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        List<SASLMechanism> list = REGISTERED_MECHANISMS;
        synchronized (list) {
            for (SASLMechanism mechanism : REGISTERED_MECHANISMS) {
                answer.put(mechanism.getClass().getName(), mechanism.toString());
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSaslMechanismRegistered(String saslMechanism) {
        List<SASLMechanism> list = REGISTERED_MECHANISMS;
        synchronized (list) {
            for (SASLMechanism mechanism : REGISTERED_MECHANISMS) {
                if (!mechanism.getName().equals(saslMechanism)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unregisterSASLMechanism(String clazz) {
        List<SASLMechanism> list = REGISTERED_MECHANISMS;
        synchronized (list) {
            Iterator<SASLMechanism> it = REGISTERED_MECHANISMS.iterator();
            while (it.hasNext()) {
                SASLMechanism mechanism = it.next();
                if (!mechanism.getClass().getName().equals(clazz)) continue;
                it.remove();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean blacklistSASLMechanism(String mechanism) {
        Set<String> set = BLACKLISTED_MECHANISMS;
        synchronized (set) {
            return BLACKLISTED_MECHANISMS.add(mechanism);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unBlacklistSASLMechanism(String mechanism) {
        Set<String> set = BLACKLISTED_MECHANISMS;
        synchronized (set) {
            return BLACKLISTED_MECHANISMS.remove(mechanism);
        }
    }

    public static Set<String> getBlacklistedSASLMechanisms() {
        return Collections.unmodifiableSet(BLACKLISTED_MECHANISMS);
    }

    SASLAuthentication(AbstractXMPPConnection connection, ConnectionConfiguration configuration) {
        this.configuration = configuration;
        this.connection = connection;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SASLMechanism authenticate(String username, String password, EntityBareJid authzid, SSLSession sslSession) throws XMPPException.XMPPErrorException, SASLErrorException, IOException, InterruptedException, SmackException.SmackSaslException, SmackException.NotConnectedException, SmackException.NoResponseException {
        this.currentMechanism = this.selectMechanism(authzid);
        CallbackHandler callbackHandler = this.configuration.getCallbackHandler();
        String host = this.connection.getHost();
        DomainBareJid xmppServiceDomain = this.connection.getXMPPServiceDomain();
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            long now;
            if (callbackHandler != null) {
                this.currentMechanism.authenticate(host, xmppServiceDomain, callbackHandler, authzid, sslSession);
            } else {
                this.currentMechanism.authenticate(username, host, xmppServiceDomain, password, authzid, sslSession);
            }
            long deadline = System.currentTimeMillis() + this.connection.getReplyTimeout();
            while (!this.authenticationSuccessful && this.saslException == null && (now = System.currentTimeMillis()) < deadline) {
                this.wait(deadline - now);
            }
        }
        if (this.saslException != null) {
            if (this.saslException instanceof SmackException.SmackSaslException) {
                throw (SmackException.SmackSaslException)this.saslException;
            }
            if (this.saslException instanceof SASLErrorException) {
                throw (SASLErrorException)this.saslException;
            }
            if (this.saslException instanceof SmackException.NotConnectedException) {
                throw (SmackException.NotConnectedException)this.saslException;
            }
            throw new IllegalStateException("Unexpected exception type", this.saslException);
        }
        if (!this.authenticationSuccessful) {
            throw SmackException.NoResponseException.newWith((XMPPConnection)this.connection, "successful SASL authentication");
        }
        return this.currentMechanism;
    }

    public void challengeReceived(String challenge) throws SmackException, InterruptedException {
        this.challengeReceived(challenge, false);
    }

    public void challengeReceived(String challenge, boolean finalChallenge) throws SmackException.SmackSaslException, SmackException.NotConnectedException, InterruptedException {
        try {
            this.currentMechanism.challengeReceived(challenge, finalChallenge);
        }
        catch (InterruptedException | SmackException.NotConnectedException | SmackException.SmackSaslException e) {
            this.authenticationFailed(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticated(SaslStreamElements.Success success) throws SmackException, InterruptedException {
        if (success.getData() != null) {
            this.challengeReceived(success.getData(), true);
        }
        this.currentMechanism.checkIfSuccessfulOrThrow();
        this.authenticationSuccessful = true;
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            this.notify();
        }
    }

    public void authenticationFailed(SaslStreamElements.SASLFailure saslFailure) {
        this.authenticationFailed(new SASLErrorException(this.currentMechanism.getName(), saslFailure));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authenticationFailed(Exception exception) {
        this.saslException = exception;
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            this.notify();
        }
    }

    public boolean authenticationSuccessful() {
        return this.authenticationSuccessful;
    }

    void init() {
        this.authenticationSuccessful = false;
        this.saslException = null;
    }

    String getNameOfLastUsedSaslMechansism() {
        SASLMechanism lastUsedMech = this.currentMechanism;
        if (lastUsedMech == null) {
            return null;
        }
        return lastUsedMech.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SASLMechanism selectMechanism(EntityBareJid authzid) throws SmackException.SmackSaslException {
        Iterator<SASLMechanism> it = REGISTERED_MECHANISMS.iterator();
        List<String> serverMechanisms = this.getServerMechanisms();
        if (serverMechanisms.isEmpty()) {
            LOGGER.warning("Server did not report any SASL mechanisms");
        }
        while (it.hasNext()) {
            SASLMechanism mechanism = it.next();
            String mechanismName = mechanism.getName();
            Set<String> set = BLACKLISTED_MECHANISMS;
            synchronized (set) {
                if (BLACKLISTED_MECHANISMS.contains(mechanismName)) {
                    continue;
                }
            }
            if (!this.configuration.isEnabledSaslMechanism(mechanismName)) continue;
            if (authzid != null && !mechanism.authzidSupported()) {
                LOGGER.fine("Skipping " + mechanism + " because authzid is required by not supported by this SASL mechanism");
                continue;
            }
            if (!serverMechanisms.contains(mechanismName)) continue;
            return mechanism.instanceForAuthentication(this.connection, this.configuration);
        }
        Set<String> set = BLACKLISTED_MECHANISMS;
        synchronized (set) {
            throw new SmackException.SmackSaslException("No supported and enabled SASL Mechanism provided by server. Server announced mechanisms: " + serverMechanisms + ". Registered SASL mechanisms with Smack: " + REGISTERED_MECHANISMS + ". Enabled SASL mechanisms for this connection: " + this.configuration.getEnabledSaslMechanisms() + ". Blacklisted SASL mechanisms: " + BLACKLISTED_MECHANISMS + '.');
        }
    }

    private List<String> getServerMechanisms() {
        Mechanisms mechanisms = (Mechanisms)this.connection.getFeature("mechanisms", "urn:ietf:params:xml:ns:xmpp-sasl");
        if (mechanisms == null) {
            return Collections.emptyList();
        }
        return mechanisms.getMechanisms();
    }

    static {
        SASLAuthentication.blacklistSASLMechanism(ScramSha1PlusMechanism.NAME);
    }
}

