/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SmackFuture;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.Stanza;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityFullJid;

public interface XMPPConnection {
    public DomainBareJid getXMPPServiceDomain();

    public String getHost();

    public int getPort();

    public EntityFullJid getUser();

    public String getStreamId();

    public boolean isConnected();

    public boolean isAuthenticated();

    public boolean isAnonymous();

    public boolean isSecureConnection();

    public boolean isUsingCompression();

    public void sendStanza(Stanza var1) throws SmackException.NotConnectedException, InterruptedException;

    public boolean trySendStanza(Stanza var1) throws SmackException.NotConnectedException;

    public boolean trySendStanza(Stanza var1, long var2, TimeUnit var4) throws SmackException.NotConnectedException, InterruptedException;

    public void sendNonza(Nonza var1) throws SmackException.NotConnectedException, InterruptedException;

    public void addConnectionListener(ConnectionListener var1);

    public void removeConnectionListener(ConnectionListener var1);

    public <I extends IQ> I sendIqRequestAndWaitForResponse(IQ var1) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException;

    public StanzaCollector createStanzaCollectorAndSend(IQ var1) throws SmackException.NotConnectedException, InterruptedException;

    public StanzaCollector createStanzaCollectorAndSend(StanzaFilter var1, Stanza var2) throws SmackException.NotConnectedException, InterruptedException;

    public StanzaCollector createStanzaCollector(StanzaFilter var1);

    public StanzaCollector createStanzaCollector(StanzaCollector.Configuration var1);

    public void removeStanzaCollector(StanzaCollector var1);

    public void addStanzaListener(StanzaListener var1, StanzaFilter var2);

    public boolean removeStanzaListener(StanzaListener var1);

    public void addSyncStanzaListener(StanzaListener var1, StanzaFilter var2);

    public boolean removeSyncStanzaListener(StanzaListener var1);

    public void addAsyncStanzaListener(StanzaListener var1, StanzaFilter var2);

    public boolean removeAsyncStanzaListener(StanzaListener var1);

    public void addStanzaSendingListener(StanzaListener var1, StanzaFilter var2);

    public void removeStanzaSendingListener(StanzaListener var1);

    public void addStanzaInterceptor(StanzaListener var1, StanzaFilter var2);

    public void removeStanzaInterceptor(StanzaListener var1);

    public long getReplyTimeout();

    public void setReplyTimeout(long var1);

    public int getConnectionCounter();

    public void setFromMode(FromMode var1);

    public FromMode getFromMode();

    public <F extends FullyQualifiedElement> F getFeature(String var1, String var2);

    public boolean hasFeature(String var1, String var2);

    public SmackFuture<IQ, Exception> sendIqRequestAsync(IQ var1);

    public SmackFuture<IQ, Exception> sendIqRequestAsync(IQ var1, long var2);

    public <S extends Stanza> SmackFuture<S, Exception> sendAsync(S var1, StanzaFilter var2);

    public <S extends Stanza> SmackFuture<S, Exception> sendAsync(S var1, StanzaFilter var2, long var3);

    public void addOneTimeSyncCallback(StanzaListener var1, StanzaFilter var2);

    public IQRequestHandler registerIQRequestHandler(IQRequestHandler var1);

    public IQRequestHandler unregisterIQRequestHandler(IQRequestHandler var1);

    public IQRequestHandler unregisterIQRequestHandler(String var1, String var2, IQ.Type var3);

    public long getLastStanzaReceived();

    public static enum FromMode {
        UNCHANGED,
        OMITTED,
        USER;

    }
}

