/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.packet.id.StanzaIdUtil;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.PacketUtil;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public abstract class Stanza
implements TopLevelStreamElement {
    public static final String TEXT = "text";
    public static final String ITEM = "item";
    protected static final String DEFAULT_LANGUAGE = Locale.getDefault().getLanguage().toLowerCase(Locale.US);
    private final MultiMap<QName, ExtensionElement> extensionElements = new MultiMap();
    private String id = null;
    private Jid to;
    private Jid from;
    private StanzaError error = null;
    protected String language;

    protected Stanza() {
        this(StanzaIdUtil.newStanzaId());
    }

    protected Stanza(String stanzaId) {
        this.setStanzaId(stanzaId);
    }

    protected Stanza(Stanza p) {
        this.id = p.getStanzaId();
        this.to = p.getTo();
        this.from = p.getFrom();
        this.error = p.error;
        for (ExtensionElement pe : p.getExtensions()) {
            this.addExtension(pe);
        }
    }

    public String getStanzaId() {
        return this.id;
    }

    @Deprecated
    public String getPacketID() {
        return this.getStanzaId();
    }

    public void setStanzaId(String id) {
        if (id != null) {
            StringUtils.requireNotNullNorEmpty(id, "id must either be null or not the empty String");
        }
        this.id = id;
    }

    @Deprecated
    public void setPacketID(String packetID) {
        this.setStanzaId(packetID);
    }

    public boolean hasStanzaIdSet() {
        return this.id != null;
    }

    public String setStanzaId() {
        if (!this.hasStanzaIdSet()) {
            this.setStanzaId(StanzaIdUtil.newStanzaId());
        }
        return this.getStanzaId();
    }

    public Jid getTo() {
        return this.to;
    }

    @Deprecated
    public void setTo(String to) {
        Jid jid;
        try {
            jid = JidCreate.from((String)to);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
        this.setTo(jid);
    }

    public void setTo(Jid to) {
        this.to = to;
    }

    public Jid getFrom() {
        return this.from;
    }

    @Deprecated
    public void setFrom(String from) {
        Jid jid;
        try {
            jid = JidCreate.from((String)from);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
        this.setFrom(jid);
    }

    public void setFrom(Jid from) {
        this.from = from;
    }

    public StanzaError getError() {
        return this.error;
    }

    @Deprecated
    public void setError(StanzaError error) {
        this.error = error;
    }

    public void setError(StanzaError.Builder xmppErrorBuilder) {
        if (xmppErrorBuilder == null) {
            return;
        }
        xmppErrorBuilder.setStanza(this);
        this.error = xmppErrorBuilder.build();
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExtensionElement> getExtensions() {
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            return this.extensionElements.values();
        }
    }

    public List<ExtensionElement> getExtensions(String elementName, String namespace) {
        StringUtils.requireNotNullNorEmpty(elementName, "elementName must not be null nor empty");
        StringUtils.requireNotNullNorEmpty(namespace, "namespace must not be null nor empty");
        QName key = new QName(namespace, elementName);
        return this.extensionElements.getAll(key);
    }

    public ExtensionElement getExtension(String namespace) {
        return PacketUtil.extensionElementFrom(this.getExtensions(), null, namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <PE extends ExtensionElement> PE getExtension(String elementName, String namespace) {
        ExtensionElement packetExtension;
        if (namespace == null) {
            return null;
        }
        QName key = new QName(namespace, elementName);
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            packetExtension = this.extensionElements.getFirst(key);
        }
        if (packetExtension == null) {
            return null;
        }
        return (PE)packetExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtension(ExtensionElement extension) {
        if (extension == null) {
            return;
        }
        QName key = extension.getQName();
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            this.extensionElements.put(key, extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtensionElement overrideExtension(ExtensionElement extension) {
        if (extension == null) {
            return null;
        }
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            ExtensionElement removedExtension = this.removeExtension(extension.getElementName(), extension.getNamespace());
            this.addExtension(extension);
            return removedExtension;
        }
    }

    public void addExtensions(Collection<ExtensionElement> extensions) {
        if (extensions == null) {
            return;
        }
        for (ExtensionElement packetExtension : extensions) {
            this.addExtension(packetExtension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasExtension(String elementName, String namespace) {
        if (elementName == null) {
            return this.hasExtension(namespace);
        }
        QName key = new QName(namespace, elementName);
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            return this.extensionElements.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasExtension(String namespace) {
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            for (ExtensionElement packetExtension : this.extensionElements.values()) {
                if (!packetExtension.getNamespace().equals(namespace)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtensionElement removeExtension(String elementName, String namespace) {
        QName key = new QName(namespace, elementName);
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            return this.extensionElements.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtensionElement removeExtension(ExtensionElement extension) {
        QName key = extension.getQName();
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            List<ExtensionElement> list = this.extensionElements.getAll(key);
            boolean removed = list.remove(extension);
            if (removed) {
                return extension;
            }
        }
        return null;
    }

    public abstract String toString();

    public static String getDefaultLanguage() {
        return DEFAULT_LANGUAGE;
    }

    protected XmlEnvironment addCommonAttributes(XmlStringBuilder xml, XmlEnvironment enclosingXmlEnvironment) {
        String language = this.getLanguage();
        String namespace = "jabber:client";
        if (enclosingXmlEnvironment != null) {
            String effectiveEnclosingNamespace;
            switch (effectiveEnclosingNamespace = enclosingXmlEnvironment.getEffectiveNamespaceOrUse(namespace)) {
                case "jabber:client": 
                case "jabber:server": {
                    break;
                }
                default: {
                    namespace = effectiveEnclosingNamespace;
                }
            }
        }
        xml.xmlnsAttribute(namespace);
        xml.optAttribute("to", (CharSequence)this.getTo());
        xml.optAttribute("from", (CharSequence)this.getFrom());
        xml.optAttribute("id", this.getStanzaId());
        xml.xmllangAttribute(language);
        return new XmlEnvironment(namespace, language);
    }

    protected void logCommonAttributes(StringBuilder sb) {
        if (this.getTo() != null) {
            sb.append("to=").append((CharSequence)this.to).append(',');
        }
        if (this.getFrom() != null) {
            sb.append("from=").append((CharSequence)this.from).append(',');
        }
        if (this.hasStanzaIdSet()) {
            sb.append("id=").append(this.id).append(',');
        }
    }

    protected void appendErrorIfExists(XmlStringBuilder xml, XmlEnvironment enclosingXmlEnvironment) {
        StanzaError error = this.getError();
        if (error != null) {
            xml.append(error.toXML(enclosingXmlEnvironment));
        }
    }
}

