/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public abstract class Provider<E extends Element> {
    private final Class<E> elementClass;

    protected Provider() {
        Type currentType = this.getClass().getGenericSuperclass();
        while (!(currentType instanceof ParameterizedType)) {
            Class currentClass = (Class)currentType;
            currentType = currentClass.getGenericSuperclass();
        }
        ParameterizedType parameterizedGenericSuperclass = (ParameterizedType)currentType;
        Type[] actualTypeArguments = parameterizedGenericSuperclass.getActualTypeArguments();
        Type elementType = actualTypeArguments[0];
        this.elementClass = (Class)elementType;
    }

    public final Class<E> getElementClass() {
        return this.elementClass;
    }

    public final E parse(XmlPullParser parser) throws IOException, XmlPullParserException, SmackParsingException {
        return this.parse(parser, null);
    }

    public final E parse(XmlPullParser parser, XmlEnvironment outerXmlEnvironment) throws IOException, XmlPullParserException, SmackParsingException {
        ParserUtils.assertAtStartTag(parser);
        int initialDepth = parser.getDepth();
        XmlEnvironment xmlEnvironment = XmlEnvironment.from(parser, outerXmlEnvironment);
        E e = this.parse(parser, initialDepth, xmlEnvironment);
        ParserUtils.forwardToEndTagOfDepth(parser, initialDepth);
        return e;
    }

    public abstract E parse(XmlPullParser var1, int var2, XmlEnvironment var3) throws XmlPullParserException, IOException, SmackParsingException;
}

