/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.igniterealtime.smack.inttest.Configuration;
import org.igniterealtime.smack.inttest.ConnectionConfigurationBuilderApplier;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPConnection;

public class XmppConnectionDescriptor<C extends AbstractXMPPConnection, CC extends ConnectionConfiguration, CCB extends ConnectionConfiguration.Builder<?, CC>> {
    private final Class<C> connectionClass;
    private final Class<CC> connectionConfigurationClass;
    private final Constructor<C> connectionConstructor;
    private final Method builderMethod;

    public XmppConnectionDescriptor(Class<C> connectionClass, Class<CC> connectionConfigurationClass) throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        this.connectionClass = connectionClass;
        this.connectionConfigurationClass = connectionConfigurationClass;
        this.connectionConstructor = XmppConnectionDescriptor.getConstructor(connectionClass, connectionConfigurationClass);
        this.builderMethod = XmppConnectionDescriptor.getBuilderMethod(connectionConfigurationClass);
    }

    public C construct(Configuration sinttestConfiguration) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.construct(sinttestConfiguration, Collections.emptyList());
    }

    public C construct(Configuration sinttestConfiguration, ConnectionConfigurationBuilderApplier ... customConnectionConfigurationAppliers) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ArrayList<ConnectionConfigurationBuilderApplier> customConnectionConfigurationAppliersList = new ArrayList<ConnectionConfigurationBuilderApplier>(Arrays.asList(customConnectionConfigurationAppliers));
        return this.construct(sinttestConfiguration, customConnectionConfigurationAppliersList);
    }

    public C construct(Configuration sinttestConfiguration, Collection<ConnectionConfigurationBuilderApplier> customConnectionConfigurationAppliers) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        CCB connectionConfigurationBuilder = this.getNewBuilder();
        for (ConnectionConfigurationBuilderApplier customConnectionConfigurationApplier : customConnectionConfigurationAppliers) {
            customConnectionConfigurationApplier.applyConfigurationTo((ConnectionConfiguration.Builder<?, ?>)connectionConfigurationBuilder);
        }
        sinttestConfiguration.configurationApplier.applyConfigurationTo((ConnectionConfiguration.Builder<?, ?>)connectionConfigurationBuilder);
        ConnectionConfiguration connectionConfiguration = connectionConfigurationBuilder.build();
        ConnectionConfiguration concreteConnectionConfiguration = (ConnectionConfiguration)this.connectionConfigurationClass.cast(connectionConfiguration);
        AbstractXMPPConnection connection = (AbstractXMPPConnection)this.connectionConstructor.newInstance(concreteConnectionConfiguration);
        connection.setReplyTimeout((long)sinttestConfiguration.replyTimeout);
        return (C)connection;
    }

    public CCB getNewBuilder() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (CCB)((ConnectionConfiguration.Builder)this.builderMethod.invoke(null, new Object[0]));
    }

    public Class<C> getConnectionClass() {
        return this.connectionClass;
    }

    private static <C extends XMPPConnection> Constructor<C> getConstructor(Class<C> connectionClass, Class<? extends ConnectionConfiguration> connectionConfigurationClass) throws NoSuchMethodException, SecurityException {
        return connectionClass.getConstructor(connectionConfigurationClass);
    }

    private static <CC extends ConnectionConfiguration> Method getBuilderMethod(Class<CC> connectionConfigurationClass) throws NoSuchMethodException, SecurityException {
        Method builderMethod = connectionConfigurationClass.getMethod("builder", new Class[0]);
        if (!Modifier.isStatic(builderMethod.getModifiers())) {
            throw new IllegalArgumentException();
        }
        Class<?> returnType = builderMethod.getReturnType();
        if (!ConnectionConfiguration.Builder.class.isAssignableFrom(returnType)) {
            throw new IllegalArgumentException();
        }
        return builderMethod;
    }
}

