/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.caps;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.igniterealtime.smack.inttest.AbstractSmackIntTest;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PresenceTypeFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.RosterUtil;
import org.jivesoftware.smackx.caps.EntityCapsManager;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.jxmpp.jid.Jid;

public class EntityCapsTest
extends AbstractSmackIntegrationTest {
    private final EntityCapsManager ecmTwo;
    private final ServiceDiscoveryManager sdmOne;
    private final ServiceDiscoveryManager sdmTwo;
    private final AtomicInteger dummyFeatureId = new AtomicInteger();
    private final Set<String> dummyFeatures = new HashSet<String>();

    public EntityCapsTest(SmackIntegrationTestEnvironment<?> environment) {
        super(environment);
        this.ecmTwo = EntityCapsManager.getInstanceFor(environment.conTwo);
        this.sdmOne = ServiceDiscoveryManager.getInstanceFor(environment.conOne);
        this.sdmTwo = ServiceDiscoveryManager.getInstanceFor(environment.conTwo);
    }

    private String getNewDummyFeature() {
        String dummyFeature = "entityCapsTest" + this.dummyFeatureId.incrementAndGet();
        this.dummyFeatures.add(dummyFeature);
        return dummyFeature;
    }

    @BeforeClass
    public void setUp() throws SmackException.NotLoggedInException, SmackException.NotConnectedException, InterruptedException, TimeoutException {
        RosterUtil.ensureSubscribed((XMPPConnection)this.conOne, (XMPPConnection)this.conTwo, (long)this.timeout);
    }

    @AfterClass
    public void tearDown() throws SmackException.NotConnectedException, InterruptedException {
        ServiceDiscoveryManager[] sdms;
        RosterUtil.ensureNotSubscribedToEachOther((XMPPConnection)this.conOne, (XMPPConnection)this.conTwo);
        for (ServiceDiscoveryManager sdm : sdms = new ServiceDiscoveryManager[]{this.sdmOne, this.sdmTwo}) {
            for (String dummyFeature : this.dummyFeatures) {
                sdm.removeFeature(dummyFeature);
            }
        }
    }

    @SmackIntegrationTest
    public void testLocalEntityCaps() throws InterruptedException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        final String dummyFeature = this.getNewDummyFeature();
        DiscoverInfo info = EntityCapsManager.getDiscoveryInfoByNodeVer((String)this.ecmTwo.getLocalNodeVer());
        Assert.assertFalse((boolean)info.containsFeature((CharSequence)dummyFeature));
        EntityCapsTest.dropWholeEntityCapsCache();
        this.performActionAndWaitUntilStanzaReceived(new Runnable(){

            @Override
            public void run() {
                EntityCapsTest.this.sdmTwo.addFeature(dummyFeature);
            }
        }, this.conOne, (StanzaFilter)new AndFilter(new StanzaFilter[]{PresenceTypeFilter.AVAILABLE, FromMatchesFilter.create((Jid)this.conTwo.getUser())}));
        info = EntityCapsManager.getDiscoveryInfoByNodeVer((String)this.ecmTwo.getLocalNodeVer());
        Assert.assertNotNull((Object)info);
        Assert.assertTrue((boolean)info.containsFeature((CharSequence)dummyFeature));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void testPreventDiscoInfo() throws Exception {
        String dummyFeature = this.getNewDummyFeature();
        final AtomicBoolean discoInfoSend = new AtomicBoolean();
        this.conOne.addStanzaSendingListener(new StanzaListener(){

            public void processStanza(Stanza stanza) {
                discoInfoSend.set(true);
            }
        }, (StanzaFilter)new AndFilter(new StanzaFilter[]{new StanzaTypeFilter(DiscoverInfo.class), IQTypeFilter.GET}));
        final SimpleResultSyncPoint presenceReceivedSyncPoint = new SimpleResultSyncPoint();
        StanzaListener presenceListener = new StanzaListener(){

            public void processStanza(Stanza packet) {
                presenceReceivedSyncPoint.signal();
            }
        };
        this.conOne.addAsyncStanzaListener(presenceListener, (StanzaFilter)PresenceTypeFilter.AVAILABLE);
        this.sdmTwo.addFeature(dummyFeature);
        try {
            presenceReceivedSyncPoint.waitForResult(this.timeout);
        }
        finally {
            this.conOne.removeAsyncStanzaListener(presenceListener);
        }
        EntityCapsTest.dropCapsCache();
        DiscoverInfo info = this.sdmOne.discoverInfo((Jid)this.conTwo.getUser());
        Assert.assertTrue((boolean)discoInfoSend.get());
        Assert.assertTrue((String)("The info response '" + info + "' does not contain the expected feature '" + dummyFeature + '\''), (boolean)info.containsFeature((CharSequence)dummyFeature));
        discoInfoSend.set(false);
        info = this.sdmOne.discoverInfo((Jid)this.conTwo.getUser());
        Assert.assertFalse((boolean)discoInfoSend.get());
        Assert.assertTrue((boolean)info.containsFeature((CharSequence)dummyFeature));
    }

    @SmackIntegrationTest
    public void testCapsChanged() {
        String dummyFeature = this.getNewDummyFeature();
        String nodeVerBefore = EntityCapsManager.getNodeVersionByJid((Jid)this.conTwo.getUser());
        this.sdmTwo.addFeature(dummyFeature);
        String nodeVerAfter = EntityCapsManager.getNodeVersionByJid((Jid)this.conTwo.getUser());
        Assert.assertFalse((boolean)nodeVerBefore.equals(nodeVerAfter));
    }

    @SmackIntegrationTest
    public void testEntityCaps() throws XMPPException, InterruptedException, SmackException.NoResponseException, SmackException.NotConnectedException, TimeoutException {
        final String dummyFeature = this.getNewDummyFeature();
        EntityCapsTest.dropWholeEntityCapsCache();
        this.performActionAndWaitUntilStanzaReceived(new Runnable(){

            @Override
            public void run() {
                EntityCapsTest.this.sdmTwo.addFeature(dummyFeature);
            }
        }, this.connection, (StanzaFilter)new AndFilter(new StanzaFilter[]{PresenceTypeFilter.AVAILABLE, FromMatchesFilter.create((Jid)this.conTwo.getUser())}));
        this.waitUntilTrue(new AbstractSmackIntTest.Condition(){

            @Override
            public boolean evaluate() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
                DiscoverInfo info = EntityCapsTest.this.sdmOne.discoverInfo((Jid)EntityCapsTest.this.conTwo.getUser());
                return info.containsFeature((CharSequence)dummyFeature);
            }
        });
        DiscoverInfo info = this.sdmOne.discoverInfo((Jid)this.conTwo.getUser());
        String u1ver = EntityCapsManager.getNodeVersionByJid((Jid)this.conTwo.getUser());
        Assert.assertNotNull((Object)u1ver);
        DiscoverInfo entityInfo = (DiscoverInfo)EntityCapsManager.CAPS_CACHE.lookup((Object)u1ver);
        Assert.assertNotNull((Object)entityInfo);
        Assert.assertEquals((Object)info.toXML().toString(), (Object)entityInfo.toXML().toString());
    }

    private static void dropWholeEntityCapsCache() {
        EntityCapsManager.CAPS_CACHE.clear();
        EntityCapsManager.JID_TO_NODEVER_CACHE.clear();
    }

    private static void dropCapsCache() {
        EntityCapsManager.CAPS_CACHE.clear();
    }
}

