/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.util.ResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.filetransfer.FileTransferListener;
import org.jivesoftware.smackx.filetransfer.FileTransferManager;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IncomingFileTransfer;
import org.jivesoftware.smackx.filetransfer.OutgoingFileTransfer;

public class FileTransferIntegrationTest
extends AbstractSmackIntegrationTest {
    private static final int MAX_FT_DURATION = 360;
    private final FileTransferManager ftManagerOne;
    private final FileTransferManager ftManagerTwo;
    private static final byte[] dataToSend = StringUtils.insecureRandomString((int)20480).getBytes(StandardCharsets.UTF_8);

    public FileTransferIntegrationTest(SmackIntegrationTestEnvironment<?> environment) {
        super(environment);
        this.ftManagerOne = FileTransferManager.getInstanceFor((XMPPConnection)this.conOne);
        this.ftManagerTwo = FileTransferManager.getInstanceFor((XMPPConnection)this.conTwo);
    }

    @SmackIntegrationTest
    public void fileTransferTest() throws Exception {
        this.genericfileTransferTest();
    }

    @SmackIntegrationTest
    public void ibbFileTransferTest() throws Exception {
        FileTransferNegotiator.IBB_ONLY = true;
        this.genericfileTransferTest();
        FileTransferNegotiator.IBB_ONLY = false;
    }

    private void genericfileTransferTest() throws Exception {
        final ResultSyncPoint resultSyncPoint = new ResultSyncPoint();
        FileTransferListener receiveListener = new FileTransferListener(){

            public void fileTransferRequest(FileTransferRequest request) {
                IncomingFileTransfer ift = request.accept();
                try {
                    int nRead;
                    InputStream is = ift.receiveFile();
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    byte[] buf = new byte[1024];
                    while ((nRead = is.read(buf, 0, buf.length)) != -1) {
                        os.write(buf, 0, nRead);
                    }
                    os.flush();
                    byte[] dataReceived = os.toByteArray();
                    if (Arrays.equals(dataToSend, dataReceived)) {
                        resultSyncPoint.signal("Received data matches send data. \\o/");
                    } else {
                        resultSyncPoint.signal(new Exception("Received data does not match"));
                    }
                }
                catch (IOException | InterruptedException | SmackException | XMPPException.XMPPErrorException e) {
                    resultSyncPoint.signal(e);
                }
            }
        };
        this.ftManagerTwo.addFileTransferListener(receiveListener);
        OutgoingFileTransfer oft = this.ftManagerOne.createOutgoingFileTransfer(this.conTwo.getUser());
        oft.sendStream((InputStream)new ByteArrayInputStream(dataToSend), "hello.txt", (long)dataToSend.length, "A greeting");
        int duration = 0;
        while (!oft.isDone()) {
            switch (oft.getStatus()) {
                case error: {
                    throw new Exception("FileTransfer error: " + oft.getError());
                }
            }
            LOGGER.info("FileTransfer status: " + oft.getStatus() + ". Progress: " + oft.getProgress());
            Thread.sleep(1000L);
            if (++duration <= 360) continue;
            throw new Exception("Max duration reached");
        }
        resultSyncPoint.waitForResult(360000L);
        this.ftManagerTwo.removeFileTransferListener(receiveListener);
    }
}

