/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox;

import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.Set;
import java.util.logging.Level;
import junit.framework.TestCase;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.test.util.FileTestUtil;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.ox.AbstractOpenPgpIntegrationTest;
import org.jivesoftware.smackx.ox.OpenPgpManager;
import org.jivesoftware.smackx.ox.OpenPgpSelf;
import org.jivesoftware.smackx.ox.callback.backup.AskForBackupCodeCallback;
import org.jivesoftware.smackx.ox.callback.backup.DisplayBackupCodeCallback;
import org.jivesoftware.smackx.ox.callback.backup.SecretKeyBackupSelectionCallback;
import org.jivesoftware.smackx.ox.crypto.OpenPgpProvider;
import org.jivesoftware.smackx.ox.crypto.PainlessOpenPgpProvider;
import org.jivesoftware.smackx.ox.exception.InvalidBackupCodeException;
import org.jivesoftware.smackx.ox.exception.MissingOpenPgpKeyException;
import org.jivesoftware.smackx.ox.exception.MissingUserIdOnKeyException;
import org.jivesoftware.smackx.ox.exception.NoBackupFoundException;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpStore;
import org.jivesoftware.smackx.ox.store.filebased.FileBasedOpenPgpStore;
import org.jivesoftware.smackx.ox.util.OpenPgpPubSubUtil;
import org.jivesoftware.smackx.pep.PepManager;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;

public class OXSecretKeyBackupIntegrationTest
extends AbstractOpenPgpIntegrationTest {
    private static final String sessionId = StringUtils.randomString((int)10);
    private static final File beforePath = FileTestUtil.getTempDir((String)("ox_backup_" + sessionId));
    private static final File afterPath = FileTestUtil.getTempDir((String)("ox_restore_" + sessionId));
    private String backupCode = null;
    private OpenPgpManager openPgpManager;

    public OXSecretKeyBackupIntegrationTest(SmackIntegrationTestEnvironment<?> environment) throws XMPPException.XMPPErrorException, TestNotPossibleException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        super(environment);
        if (!OpenPgpManager.serverSupportsSecretKeyBackups((XMPPConnection)this.aliceConnection)) {
            throw new TestNotPossibleException("Server does not support the 'whitelist' PubSub access model.");
        }
    }

    @AfterClass
    @BeforeClass
    public static void cleanStore() {
        LOGGER.log(Level.INFO, "Delete store directories...");
        FileTestUtil.deleteDirectory((File)afterPath);
        FileTestUtil.deleteDirectory((File)beforePath);
    }

    @After
    @Before
    public void cleanUp() throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        OpenPgpPubSubUtil.deleteSecretKeyNode((PepManager)this.alicePepManager);
        if (this.openPgpManager != null) {
            this.openPgpManager.stopMetadataListener();
        }
    }

    @SmackIntegrationTest
    public void test() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, IOException, InterruptedException, PubSubException.NotALeafNodeException, SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.XMPPErrorException, SmackException.NotLoggedInException, SmackException.FeatureNotSupportedException, MissingUserIdOnKeyException, NoBackupFoundException, InvalidBackupCodeException, PGPException, MissingOpenPgpKeyException {
        FileBasedOpenPgpStore beforeStore = new FileBasedOpenPgpStore(beforePath);
        beforeStore.setKeyRingProtector((SecretKeyRingProtector)new UnprotectedKeysProtector());
        PainlessOpenPgpProvider beforeProvider = new PainlessOpenPgpProvider(this.aliceConnection, (OpenPgpStore)beforeStore);
        this.openPgpManager = OpenPgpManager.getInstanceFor((XMPPConnection)this.aliceConnection);
        this.openPgpManager.setOpenPgpProvider((OpenPgpProvider)beforeProvider);
        OpenPgpSelf self = this.openPgpManager.getOpenPgpSelf();
        TestCase.assertNull((Object)self.getSigningKeyFingerprint());
        OpenPgpV4Fingerprint keyFingerprint = this.openPgpManager.generateAndImportKeyPair(this.alice);
        TestCase.assertEquals((Object)keyFingerprint, (Object)self.getSigningKeyFingerprint());
        TestCase.assertTrue((boolean)self.getSecretKeys().contains(keyFingerprint.getKeyId()));
        PGPSecretKeyRing beforeSec = beforeStore.getSecretKeyRing(this.alice, keyFingerprint);
        TestCase.assertNotNull((Object)beforeSec);
        PGPPublicKeyRing beforePub = beforeStore.getPublicKeyRing(this.alice, keyFingerprint);
        TestCase.assertNotNull((Object)beforePub);
        this.openPgpManager.backupSecretKeyToServer(new DisplayBackupCodeCallback(){

            public void displayBackupCode(String backupCode) {
                OXSecretKeyBackupIntegrationTest.this.backupCode = backupCode;
            }
        }, new SecretKeyBackupSelectionCallback(){

            public Set<OpenPgpV4Fingerprint> selectKeysToBackup(Set<OpenPgpV4Fingerprint> availableSecretKeys) {
                return availableSecretKeys;
            }
        });
        FileBasedOpenPgpStore afterStore = new FileBasedOpenPgpStore(afterPath);
        afterStore.setKeyRingProtector((SecretKeyRingProtector)new UnprotectedKeysProtector());
        PainlessOpenPgpProvider afterProvider = new PainlessOpenPgpProvider(this.aliceConnection, (OpenPgpStore)afterStore);
        this.openPgpManager.setOpenPgpProvider((OpenPgpProvider)afterProvider);
        OpenPgpV4Fingerprint fingerprint = this.openPgpManager.restoreSecretKeyServerBackup(new AskForBackupCodeCallback(){

            public String askForBackupCode() {
                return OXSecretKeyBackupIntegrationTest.this.backupCode;
            }
        });
        TestCase.assertEquals((Object)keyFingerprint, (Object)fingerprint);
        TestCase.assertTrue((boolean)self.getSecretKeys().contains(keyFingerprint.getKeyId()));
        TestCase.assertEquals((Object)keyFingerprint, (Object)self.getSigningKeyFingerprint());
        PGPSecretKeyRing afterSec = afterStore.getSecretKeyRing(this.alice, keyFingerprint);
        TestCase.assertNotNull((Object)afterSec);
        TestCase.assertTrue((boolean)Arrays.equals(beforeSec.getEncoded(), afterSec.getEncoded()));
        PGPPublicKeyRing afterPub = afterStore.getPublicKeyRing(this.alice, keyFingerprint);
        TestCase.assertNotNull((Object)afterPub);
        TestCase.assertTrue((boolean)Arrays.equals(beforePub.getEncoded(), afterPub.getEncoded()));
    }
}

