/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import org.jivesoftware.smack.ConnectionConfiguration;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.jid.JidTestUtil;

public class ConnectionConfigurationTest {
    @Test
    public void setIp() {
        DummyConnectionConfiguration.Builder builder = ConnectionConfigurationTest.newUnitTestBuilder();
        String ip = "192.168.0.1";
        builder.setHostAddressByNameOrIp("192.168.0.1");
        DummyConnectionConfiguration connectionConfiguration = builder.build();
        Assert.assertEquals((Object)"/192.168.0.1", (Object)connectionConfiguration.getHostAddress().toString());
    }

    @Test
    public void setFqdn() {
        DummyConnectionConfiguration.Builder builder = ConnectionConfigurationTest.newUnitTestBuilder();
        String fqdn = "foo.example.org";
        builder.setHostAddressByNameOrIp("foo.example.org");
        DummyConnectionConfiguration connectionConfiguration = builder.build();
        Assert.assertEquals((Object)"foo.example.org", (Object)connectionConfiguration.getHost().toString());
    }

    private static DummyConnectionConfiguration.Builder newUnitTestBuilder() {
        DummyConnectionConfiguration.Builder builder = DummyConnectionConfiguration.builder();
        builder.setXmppDomain(JidTestUtil.DOMAIN_BARE_JID_1);
        return builder;
    }

    private static final class DummyConnectionConfiguration
    extends ConnectionConfiguration {
        protected DummyConnectionConfiguration(Builder builder) {
            super((ConnectionConfiguration.Builder)builder);
        }

        public static Builder builder() {
            return new Builder();
        }

        private static final class Builder
        extends ConnectionConfiguration.Builder<Builder, DummyConnectionConfiguration> {
            private Builder() {
            }

            public DummyConnectionConfiguration build() {
                return new DummyConnectionConfiguration(this);
            }

            protected Builder getThis() {
                return this;
            }
        }
    }
}

