/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.io.IOException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.test.util.SmackTestUtil;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.junit.Assert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class StreamErrorTest {
    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testParsingOfSimpleStreamError(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException, SmackParsingException {
        String xml = "<stream:stream from='im.example.com' id='++TR84Sm6A3hnt3Q065SnAbbk3Y=' xmlns:stream='http://etherx.jabber.org/streams'><stream:error><conflict xmlns='urn:ietf:params:xml:ns:xmpp-streams' /> +</stream:error></stream:stream>";
        XmlPullParser parser = SmackTestUtil.getParserFor("<stream:stream from='im.example.com' id='++TR84Sm6A3hnt3Q065SnAbbk3Y=' xmlns:stream='http://etherx.jabber.org/streams'><stream:error><conflict xmlns='urn:ietf:params:xml:ns:xmpp-streams' /> +</stream:error></stream:stream>", "error", parserKind);
        StreamError error = PacketParserUtils.parseStreamError((XmlPullParser)parser);
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((Object)StreamError.Condition.conflict, (Object)error.getCondition());
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testParsingOfStreamErrorWithText(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException, SmackParsingException {
        String xml = "<stream:stream from='im.example.com' id='++TR84Sm6A3hnt3Q065SnAbbk3Y=' xmlns:stream='http://etherx.jabber.org/streams'><stream:error><conflict xmlns='urn:ietf:params:xml:ns:xmpp-streams' /><text xml:lang='' xmlns='urn:ietf:params:xml:ns:xmpp-streams'>Replaced by new connection</text></stream:error></stream:stream>";
        XmlPullParser parser = SmackTestUtil.getParserFor("<stream:stream from='im.example.com' id='++TR84Sm6A3hnt3Q065SnAbbk3Y=' xmlns:stream='http://etherx.jabber.org/streams'><stream:error><conflict xmlns='urn:ietf:params:xml:ns:xmpp-streams' /><text xml:lang='' xmlns='urn:ietf:params:xml:ns:xmpp-streams'>Replaced by new connection</text></stream:error></stream:stream>", "error", parserKind);
        StreamError error = PacketParserUtils.parseStreamError((XmlPullParser)parser);
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((Object)StreamError.Condition.conflict, (Object)error.getCondition());
        Assert.assertEquals((Object)"Replaced by new connection", (Object)error.getDescriptiveText());
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testParsingOfStreamErrorWithTextAndOptionalElement(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException, SmackParsingException {
        String xml = "<stream:stream from='im.example.com' id='++TR84Sm6A3hnt3Q065SnAbbk3Y=' xmlns:stream='http://etherx.jabber.org/streams'><stream:error><conflict xmlns='urn:ietf:params:xml:ns:xmpp-streams' /><text xml:lang='' xmlns='urn:ietf:params:xml:ns:xmpp-streams'>Replaced by new connection</text><appSpecificElement xmlns='myns'>Text contents of application-specific condition element: Foo Bar</appSpecificElement></stream:error></stream:stream>";
        XmlPullParser parser = SmackTestUtil.getParserFor("<stream:stream from='im.example.com' id='++TR84Sm6A3hnt3Q065SnAbbk3Y=' xmlns:stream='http://etherx.jabber.org/streams'><stream:error><conflict xmlns='urn:ietf:params:xml:ns:xmpp-streams' /><text xml:lang='' xmlns='urn:ietf:params:xml:ns:xmpp-streams'>Replaced by new connection</text><appSpecificElement xmlns='myns'>Text contents of application-specific condition element: Foo Bar</appSpecificElement></stream:error></stream:stream>", "error", parserKind);
        StreamError error = PacketParserUtils.parseStreamError((XmlPullParser)parser);
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((Object)StreamError.Condition.conflict, (Object)error.getCondition());
        Assert.assertEquals((Object)"Replaced by new connection", (Object)error.getDescriptiveText());
        ExtensionElement appSpecificElement = error.getExtension("appSpecificElement", "myns");
        Assert.assertNotNull((Object)appSpecificElement);
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testStreamErrorXmlNotWellFormed(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException, SmackParsingException {
        String xml = "<stream:stream from='im.example.com' id='++TR84Sm6A3hnt3Q065SnAbbk3Y=' xmlns:stream='http://etherx.jabber.org/streams'><stream:error><xml-not-well-formed xmlns='urn:ietf:params:xml:ns:xmpp-streams'/></stream:error></stream:stream>";
        XmlPullParser parser = SmackTestUtil.getParserFor("<stream:stream from='im.example.com' id='++TR84Sm6A3hnt3Q065SnAbbk3Y=' xmlns:stream='http://etherx.jabber.org/streams'><stream:error><xml-not-well-formed xmlns='urn:ietf:params:xml:ns:xmpp-streams'/></stream:error></stream:stream>", "error", parserKind);
        StreamError error = PacketParserUtils.parseStreamError((XmlPullParser)parser);
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((Object)StreamError.Condition.not_well_formed, (Object)error.getCondition());
    }
}

