/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.test.util.SmackTestUtil;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class XmlPullParserTest {
    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testSimpleEmptyElement(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException {
        StringReader reader = new StringReader("<empty-element/>");
        XmlPullParser parser = parserKind.factory.newXmlPullParser((Reader)reader);
        Assertions.assertEquals((Object)XmlPullParser.Event.START_DOCUMENT, (Object)parser.getEventType());
        Assertions.assertEquals((Object)XmlPullParser.Event.START_ELEMENT, (Object)parser.next());
        QName qname = parser.getQName();
        Assertions.assertEquals((Object)qname.getLocalPart(), (Object)"empty-element");
        Assertions.assertEquals((Object)qname.getPrefix(), (Object)"");
        Assertions.assertEquals((Object)qname.getNamespaceURI(), (Object)"");
        Assertions.assertEquals((Object)XmlPullParser.Event.END_ELEMENT, (Object)parser.next());
        Assertions.assertEquals((Object)XmlPullParser.Event.END_DOCUMENT, (Object)parser.next());
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testQNameSimpleElement(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException {
        String simpleElement = "<outer-element xmlns='outer-namespace'><inner-element/></outer-element>";
        XmlPullParser parser = SmackTestUtil.getParserFor(simpleElement, parserKind);
        QName qname = parser.getQName();
        Assertions.assertEquals((Object)"outer-element", (Object)qname.getLocalPart());
        Assertions.assertEquals((Object)"outer-namespace", (Object)qname.getNamespaceURI());
        Assertions.assertEquals((Object)XmlPullParser.Event.START_ELEMENT, (Object)parser.next());
        qname = parser.getQName();
        Assertions.assertEquals((Object)"inner-element", (Object)qname.getLocalPart());
        Assertions.assertEquals((Object)"outer-namespace", (Object)qname.getNamespaceURI());
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testQNamePrefixElement(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException {
        String prefixElement = "<outer-element xmlns='outer-namespace' xmlns:inner-prefix='inner-namespace'><inner-prefix:inner-element></outer-element>";
        XmlPullParser parser = SmackTestUtil.getParserFor(prefixElement, parserKind);
        QName qname = parser.getQName();
        Assertions.assertEquals((Object)"outer-element", (Object)qname.getLocalPart());
        Assertions.assertEquals((Object)"outer-namespace", (Object)qname.getNamespaceURI());
        Assertions.assertEquals((Object)XmlPullParser.Event.START_ELEMENT, (Object)parser.next());
        qname = parser.getQName();
        Assertions.assertEquals((Object)"inner-element", (Object)qname.getLocalPart());
        Assertions.assertEquals((Object)"inner-namespace", (Object)qname.getNamespaceURI());
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testAttributesElementWithOneAttribute(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException {
        String elementWithOneAttribute = "<element attribute-one='attribute-one-value'/>";
        XmlPullParser parser = SmackTestUtil.getParserFor(elementWithOneAttribute, parserKind);
        XmlPullParserTest.assertAttributeHolds(parser, 0, "attribute-one", "", "");
        Assertions.assertThrows(NullPointerException.class, () -> XmlPullParserTest.assertAttributeHolds(parser, 1, "attribute-one", "", ""));
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testAttributesNamespacedElementWithOneAttribute(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException {
        String namespacedElementWithOneAttribute = "<element xmlns='element-namespace' attribute-one='attribute-one-value'/>";
        XmlPullParser parser = SmackTestUtil.getParserFor(namespacedElementWithOneAttribute, parserKind);
        XmlPullParserTest.assertAttributeHolds(parser, 0, "attribute-one", "", "");
        Assertions.assertThrows(NullPointerException.class, () -> XmlPullParserTest.assertAttributeHolds(parser, 1, "attribute-one", "", ""));
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testAttributesNamespacedElementWithOneNamespacedAttribute(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException {
        String namespacedElementWithOneNamespacedAttribute = "<element xmlns='element-namespace' xmlns:attribute-namespace='attribute-namespace-value' attribute-namespace:attribute-one='attribute-one-value'/>";
        XmlPullParser parser = SmackTestUtil.getParserFor(namespacedElementWithOneNamespacedAttribute, parserKind);
        XmlPullParserTest.assertAttributeHolds(parser, 0, "attribute-one", "attribute-namespace", "attribute-namespace-value");
        Assertions.assertThrows(NullPointerException.class, () -> XmlPullParserTest.assertAttributeHolds(parser, 1, "attribute-one", "", ""));
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testNamespacedAttributes(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException {
        String element = "<element xmlns:attr='attribute-namespace' attr:attributeOneName='attributeOneValue'/>";
        XmlPullParser parser = SmackTestUtil.getParserFor(element, parserKind);
        Assertions.assertEquals((int)1, (int)parser.getAttributeCount());
        Assertions.assertEquals((Object)"attributeOneName", (Object)parser.getAttributeName(0));
        Assertions.assertEquals((Object)"attr", (Object)parser.getAttributePrefix(0));
        Assertions.assertEquals((Object)"attribute-namespace", (Object)parser.getAttributeNamespace(0));
        QName attributeZeroQname = parser.getAttributeQName(0);
        Assertions.assertEquals((Object)"attributeOneName", (Object)attributeZeroQname.getLocalPart());
        Assertions.assertEquals((Object)"attr", (Object)attributeZeroQname.getPrefix());
        Assertions.assertEquals((Object)"attribute-namespace", (Object)attributeZeroQname.getNamespaceURI());
        Assertions.assertNull((Object)parser.getAttributeName(1));
        Assertions.assertNull((Object)parser.getAttributePrefix(1));
        Assertions.assertNull((Object)parser.getAttributeNamespace(1));
        QName attributeOneQname = parser.getAttributeQName(1);
        Assertions.assertNull((Object)attributeOneQname);
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testAttributeType(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException {
        String element = "<element xmlns:attr='attribute-namespace' attr:attributeOneName='attributeOneValue'/>";
        XmlPullParser parser = SmackTestUtil.getParserFor(element, parserKind);
        Assertions.assertEquals((Object)"CDATA", (Object)parser.getAttributeType(0));
        Assertions.assertNull((Object)parser.getAttributeType(1));
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testNextText(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException {
        String simpleElement = "<element>Element text</element>";
        XmlPullParser parser = SmackTestUtil.getParserFor(simpleElement, parserKind);
        Assertions.assertEquals((Object)"Element text", (Object)parser.nextText());
        String complexElement = "<outer-elment><element1>Element 1 &apos; text</element1><element2>Element 2 text</element2></outer-element>";
        parser = SmackTestUtil.getParserFor(complexElement, parserKind);
        Assertions.assertEquals((Object)XmlPullParser.Event.START_ELEMENT, (Object)parser.next());
        Assertions.assertEquals((Object)"element1", (Object)parser.getName());
        Assertions.assertEquals((int)0, (int)parser.getAttributeCount());
        Assertions.assertEquals((Object)"Element 1 ' text", (Object)parser.nextText());
        Assertions.assertEquals((Object)XmlPullParser.Event.START_ELEMENT, (Object)parser.next());
        Assertions.assertEquals((Object)"element2", (Object)parser.getName());
        Assertions.assertEquals((int)0, (int)parser.getAttributeCount());
        Assertions.assertEquals((Object)"Element 2 text", (Object)parser.nextText());
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testNextTextMixedContent(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException {
        String element = "<element>Mixed content element text<inner-element>Inner element text</inner-element></element>";
        XmlPullParser parser = SmackTestUtil.getParserFor(element, parserKind);
        Assertions.assertThrows(XmlPullParserException.class, () -> parser.nextText());
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testNextTextOnEndElement(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException {
        String element = "<element>Element text</element>";
        XmlPullParser parser = SmackTestUtil.getParserFor(element, parserKind);
        Assertions.assertEquals((Object)XmlPullParser.Event.START_ELEMENT, (Object)parser.getEventType());
        Assertions.assertEquals((Object)XmlPullParser.Event.TEXT_CHARACTERS, (Object)parser.next());
        Assertions.assertEquals((Object)XmlPullParser.Event.END_ELEMENT, (Object)parser.next());
        Assertions.assertThrows(XmlPullParserException.class, () -> parser.nextText());
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testNextTextOnEmptyElement(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException {
        String[] emptyElementStream;
        for (String emptyElement : emptyElementStream = (String[])Stream.of(new Object[0]).toArray(String[]::new)) {
            XmlPullParser parser = SmackTestUtil.getParserFor(emptyElement, parserKind);
            Assertions.assertEquals((Object)XmlPullParser.Event.START_ELEMENT, (Object)parser.getEventType());
            Assertions.assertEquals((Object)"", (Object)parser.nextText());
        }
    }

    private static void assertAttributeHolds(XmlPullParser parser, int attributeIndex, String expectedLocalpart, String expectedPrefix, String expectedNamespace) {
        QName qname = parser.getAttributeQName(attributeIndex);
        String qnameNamespaceUri = qname.getNamespaceURI();
        Assertions.assertEquals((Object)expectedLocalpart, (Object)qname.getLocalPart());
        Assertions.assertEquals((Object)expectedPrefix, (Object)qname.getPrefix());
        Assertions.assertEquals((Object)expectedNamespace, (Object)qnameNamespaceUri);
        Assertions.assertEquals((Object)qname.getLocalPart(), (Object)parser.getAttributeName(attributeIndex));
        Assertions.assertEquals((Object)qname.getPrefix(), (Object)parser.getAttributePrefix(attributeIndex));
        String expectedGetAttributeNamespace = qnameNamespaceUri.equals("") ? null : qnameNamespaceUri;
        Assertions.assertEquals((Object)expectedGetAttributeNamespace, (Object)parser.getAttributeNamespace(attributeIndex));
    }
}

